/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.access.EnumAccess;
import forestry.core.access.FakeAccessHandler;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.packets.PacketAccessUpdateEntity;
import forestry.core.network.packets.PacketErrorUpdateEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class ContainerEntity<T extends Entity>
extends ContainerForestry {
    protected final T entity;
    private final IAccessHandler accessHandler;
    private ImmutableSet<IErrorState> previousErrorStates;
    private EnumAccess previousAccess;

    protected ContainerEntity(T entity) {
        this.entity = entity;
        this.accessHandler = entity instanceof IRestrictedAccess ? ((IRestrictedAccess)entity).getAccessHandler() : FakeAccessHandler.getInstance();
    }

    protected ContainerEntity(T entity, InventoryPlayer playerInventory, int xInv, int yInv) {
        this(entity);
        this.addPlayerInventory(playerInventory, xInv, yInv);
    }

    @Override
    protected final boolean canAccess(EntityPlayer player) {
        return player != null && this.accessHandler.allowsAlteration(player);
    }

    public final boolean func_75145_c(EntityPlayer entityplayer) {
        return ((IInventory)this.entity).func_70300_a(entityplayer) && this.accessHandler.allowsViewing(entityplayer);
    }

    public void func_75142_b() {
        IRestrictedAccess restrictedAccess;
        IAccessHandler accessHandler;
        EnumAccess access;
        super.func_75142_b();
        if (this.entity instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.entity;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (this.previousErrorStates == null || !errorStates.equals(this.previousErrorStates)) {
                PacketErrorUpdateEntity packet = new PacketErrorUpdateEntity((Entity)this.entity, errorLogicSource);
                this.sendPacketToListeners(packet);
            }
            this.previousErrorStates = errorStates;
        }
        if (this.entity instanceof IRestrictedAccess && (access = (accessHandler = (restrictedAccess = (IRestrictedAccess)this.entity).getAccessHandler()).getAccess()) != this.previousAccess) {
            PacketAccessUpdateEntity packet = new PacketAccessUpdateEntity(restrictedAccess, (Entity)this.entity);
            this.sendPacketToListeners(packet);
            this.previousAccess = access;
        }
    }
}

