/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import com.google.common.collect.ImmutableMap;
import forestry.api.greenhouse.IGreenhouseHousing;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.proxy.Proxies;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileGreenhouseClimatiser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;

public class TileGreenhouseSprinkler
extends TileGreenhouseClimatiser {
    private final IAnimationStateMachine asm;
    private final TimeValues.VariableValue cycleLength = new TimeValues.VariableValue(4.0f);
    private final TimeValues.VariableValue clickTime = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);
    protected static final int WATER_PER_OPERATION = 2;
    private static final SprinklerDefinition definition = new SprinklerDefinition();

    public TileGreenhouseSprinkler() {
        super(definition);
        this.asm = Proxies.render.loadAnimationState(new ResourceLocation("forestry", "asms/block/sprinkler.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)this.cycleLength, (Object)"click_time", (Object)this.clickTime));
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public <G extends IGreenhouseController & IGreenhouseHousing> void changeClimate(int tick, G greenhouse) {
        IGreenhouseControllerInternal greenhouseInternal = (IGreenhouseControllerInternal)greenhouse;
        if (this.workingTime < 20 && this.consumeWaterToDoWork(1, 2, (StandardTank)greenhouseInternal.getTankManager().getTank(0))) {
            this.workingTime += 4;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            greenhouse.addHumidityChange(definition.getChangePerTransfer(), definition.getBoundaryDown(), definition.getBoundaryUp());
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (this.asm.currentState().equals("moving") && !this.isActive()) {
                this.clickTime.setValue(Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime()));
                this.asm.transition("stopping");
            } else if (this.asm.currentState().equals("default") && this.isActive()) {
                float time = Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime());
                this.clickTime.setValue(time);
                this.asm.transition("starting");
            }
        }
    }

    public boolean consumeWaterToDoWork(int ticksPerWorkCycle, int fluidPerWorkCycle, StandardTank tank) {
        int fluidPerCycle = (int)Math.ceil((float)fluidPerWorkCycle / (float)ticksPerWorkCycle);
        if (tank.getFluid() == null || tank.getFluid().amount < fluidPerCycle) {
            return false;
        }
        this.modifyWaterStored(-fluidPerCycle, tank);
        return true;
    }

    public void modifyWaterStored(int fluid, StandardTank tank) {
        tank.getFluid().amount += fluid;
        if (tank.getFluid().amount > tank.getCapacity()) {
            tank.getFluid().amount = tank.getCapacity();
        } else if (tank.getFluid().amount < 0) {
            tank.getFluid().amount = 0;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }

    private static class SprinklerDefinition
    implements TileGreenhouseClimatiser.IClimitiserDefinition {
        private SprinklerDefinition() {
        }

        @Override
        public float getChangePerTransfer() {
            return 0.02f;
        }

        @Override
        public float getBoundaryUp() {
            return 2.5f;
        }

        @Override
        public float getBoundaryDown() {
            return 0.05f;
        }

        @Override
        public TileGreenhouseClimatiser.ClimitiserType getType() {
            return TileGreenhouseClimatiser.ClimitiserType.HUMIDITY;
        }
    }
}

