/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.Translator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MutationConditionTemperature
implements IMutationCondition {
    private final EnumTemperature minTemperature;
    private final EnumTemperature maxTemperature;

    public MutationConditionTemperature(EnumTemperature minTemperature, EnumTemperature maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        Biome biome = world.func_72959_q().func_180631_a(pos);
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, world, pos);
        if (biomeTemperature.ordinal() < this.minTemperature.ordinal() || biomeTemperature.ordinal() > this.maxTemperature.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public String getDescription() {
        String minString = AlleleManager.climateHelper.toDisplay(this.minTemperature);
        if (this.minTemperature != this.maxTemperature) {
            String maxString = AlleleManager.climateHelper.toDisplay(this.maxTemperature);
            return Translator.translateToLocal("for.mutation.condition.temperature.range").replace("%LOW", minString).replace("%HIGH", maxString);
        }
        return Translator.translateToLocalFormatted("for.mutation.condition.temperature.single", minString);
    }
}

