/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.models.BlankItemModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.tiles.TileUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelWoodPile
extends BlankItemModel {
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter = new DefaultTextureGetter();
    @SideOnly(value=Side.CLIENT)
    private IModel modelWoodPileItem;
    private IModel modelWoodPileBlock;
    private static final Map<String, IBakedModel> blockCache = new HashMap<String, IBakedModel>();
    private static final Map<String, IBakedModel> itemCache = new HashMap<String, IBakedModel>();

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state instanceof IExtendedBlockState) {
            BlockPos pos;
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
            TilePile pile = TileUtil.getTile(world, pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS), TilePile.class);
            if (pile == null) {
                return Collections.emptyList();
            }
            IAlleleTreeSpecies treeSpecies = pile.getTreeSpecies();
            if (treeSpecies == null) {
                treeSpecies = (IAlleleTreeSpecies)TreeManager.treeRoot.getDefaultTemplate()[TreeManager.treeRoot.getSpeciesChromosomeType().ordinal()];
            }
            if (this.modelWoodPileBlock == null) {
                try {
                    this.modelWoodPileBlock = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:block/woodPile"));
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
                if (this.modelWoodPileBlock == null) {
                    return Collections.emptyList();
                }
            }
            IBakedModel model = this.bakeModel(treeSpecies, false);
            return model.func_188616_a(state, side, rand);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean func_177555_b() {
        return false;
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return TreeDefinition.Oak.getGenome().getPrimary().getWoodProvider().getSprite(false);
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new PileItemOverrideList();
    }

    private IBakedModel bakeModel(IAlleleTreeSpecies treeSpecies, boolean isItem) {
        Map<String, IBakedModel> map;
        ImmutableMap.Builder textures = ImmutableMap.builder();
        String treeUID = treeSpecies.getUID();
        Map<String, IBakedModel> map2 = map = isItem ? itemCache : blockCache;
        if (!map.containsKey(treeUID)) {
            textures.put((Object)"woodBark", (Object)treeSpecies.getWoodProvider().getSprite(false).func_94215_i());
            textures.put((Object)"woodTop", (Object)treeSpecies.getWoodProvider().getSprite(true).func_94215_i());
            IModel retextureWoodPile = ModelProcessingHelper.retexture((IModel)(isItem ? this.modelWoodPileItem : this.modelWoodPileBlock), (ImmutableMap)textures.build());
            map.put(treeUID, retextureWoodPile.bake((IModelState)ModelRotation.X0_Y0, isItem ? DefaultVertexFormats.field_176599_b : DefaultVertexFormats.field_176600_a, this.textureGetter));
        }
        return map.get(treeUID);
    }

    private class PileItemOverrideList
    extends ItemOverrideList {
        public PileItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IAlleleTreeSpecies treeSpecies;
            if (ModelWoodPile.this.modelWoodPileItem == null) {
                try {
                    ModelWoodPile.this.modelWoodPileItem = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:item/woodPile"));
                }
                catch (Exception e) {
                    return null;
                }
                if (ModelWoodPile.this.modelWoodPileItem == null) {
                    return null;
                }
            }
            if ((treeSpecies = BlockPile.getTreeSpecies(stack)) == null) {
                treeSpecies = (IAlleleTreeSpecies)TreeManager.treeRoot.getDefaultTemplate()[TreeManager.treeRoot.getSpeciesChromosomeType().ordinal()];
            }
            return ModelWoodPile.this.bakeModel(treeSpecies, true);
        }
    }
}

