/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockArbDoor
extends BlockDoor
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    private final EnumForestryWoodType woodType;

    public BlockArbDoor(EnumForestryWoodType woodType) {
        super(Material.field_151575_d);
        this.woodType = woodType;
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, (IStateMapper)new WoodTypeStateMapper(this, null).addPropertyToRemove((IProperty)field_176522_N));
    }

    @Override
    @Nonnull
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.DOOR;
    }

    @Override
    public boolean isFireproof() {
        return false;
    }

    @Override
    @Nonnull
    public EnumForestryWoodType getWoodType(int meta) {
        return this.woodType;
    }

    @Nonnull
    public Collection<EnumForestryWoodType> getWoodTypes() {
        return Collections.singleton(this.woodType);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        EnumForestryWoodType woodType = this.getWoodType(meta);
        return woodType.getHardness();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : this.getItem();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        return TreeManager.woodAccess.getStack(this.woodType, this.getBlockKind(), false).func_77973_b();
    }
}

