/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.ForestryAPI;
import forestry.arboriculture.IWoodTyped;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WoodHelper {
    @Nonnull
    public static String getDisplayName(IWoodTyped wood, IWoodType woodType) {
        String displayName;
        WoodBlockKind blockKind = wood.getBlockKind();
        if (woodType instanceof EnumForestryWoodType) {
            String customUnlocalizedName = "tile.for." + (Object)((Object)blockKind) + "." + woodType + ".name";
            if (Translator.canTranslateToLocal(customUnlocalizedName)) {
                displayName = Translator.translateToLocal(customUnlocalizedName);
            } else {
                String woodGrammar = Translator.translateToLocal("for." + (Object)((Object)blockKind) + ".grammar");
                String woodTypeName = Translator.translateToLocal("for.trees.woodType." + woodType);
                displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
            }
        } else if (woodType instanceof EnumVanillaWoodType) {
            displayName = TreeManager.woodAccess.getStack(woodType, blockKind, false).func_82833_r();
        } else {
            throw new IllegalArgumentException("Unknown wood type: " + woodType);
        }
        if (wood.isFireproof()) {
            displayName = Translator.translateToLocalFormatted("tile.for.fireproof", displayName);
        }
        return displayName;
    }

    public static ResourceLocation[] getResourceLocations(IWoodTyped typed) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        WoodBlockKind blockKind = typed.getBlockKind();
        for (IWoodType iWoodType : typed.getWoodTypes()) {
            if (iWoodType instanceof EnumForestryWoodType) {
                resourceLocations.add(new ResourceLocation("forestry", (Object)((Object)blockKind) + "/" + iWoodType));
                continue;
            }
            if (!(iWoodType instanceof EnumVanillaWoodType)) continue;
            resourceLocations.add(new ResourceLocation("minecraft", iWoodType + "_" + (Object)((Object)blockKind)));
        }
        return resourceLocations.toArray(new ResourceLocation[resourceLocations.size()]);
    }

    @SideOnly(value=Side.CLIENT)
    public static class WoodMeshDefinition
    implements ItemMeshDefinition {
        @Nonnull
        public IWoodTyped wood;

        public WoodMeshDefinition(@Nonnull IWoodTyped wood) {
            this.wood = wood;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            int meta = stack.func_77960_j();
            IWoodType woodType = this.wood.getWoodType(meta);
            WoodBlockKind blockKind = this.wood.getBlockKind();
            if (woodType instanceof EnumForestryWoodType) {
                return ForestryAPI.modelManager.getModelLocation((Object)((Object)blockKind) + "/" + woodType);
            }
            if (woodType instanceof EnumVanillaWoodType) {
                return new ModelResourceLocation("minecraft:" + woodType + "_" + (Object)((Object)blockKind), "inventory");
            }
            throw new IllegalArgumentException("Unknown wood type: " + woodType);
        }
    }
}

