/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.blocks.BlockBase;
import forestry.core.models.ModelEscritoire;
import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;
import forestry.core.tiles.TileEscritoire;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RenderEscritoire
extends TileEntitySpecialRenderer<TileEscritoire> {
    private static final ResourceLocation texture = new ForestryResource("textures/blocks/escritoire.png");
    private final ModelEscritoire modelEscritoire = new ModelEscritoire();
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private long lastTick;

    public void renderTileEntityAt(@Nullable TileEscritoire escritoire, double x, double y, double z, float partialTicks, int destroyStage) {
        World world;
        IBlockState blockState;
        if (escritoire != null && (blockState = (world = escritoire.getWorldObj()).func_180495_p(escritoire.func_174877_v())) != null && blockState.func_177230_c() instanceof BlockBase) {
            EnumFacing facing = (EnumFacing)blockState.func_177229_b(BlockBase.FACING);
            this.render(escritoire.getIndividualOnDisplay(), world, facing, x, y, z);
            return;
        }
        this.render(null, null, EnumFacing.SOUTH, x, y, z);
    }

    private void render(@Nullable ItemStack itemstack, @Nullable World world, EnumFacing orientation, double x, double y, double z) {
        float factor = 0.0625f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.875f), (float)((float)z + 0.5f));
        float[] angle = new float[]{(float)Math.PI, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = EnumFacing.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = 1.5707964f;
                break;
            }
            case SOUTH: {
                break;
            }
            case NORTH: {
                angle[1] = (float)Math.PI;
                break;
            }
            default: {
                angle[1] = -1.5707964f;
            }
        }
        Proxies.render.bindTexture(texture);
        this.modelEscritoire.func_78088_a(null, angle[0], angle[1], angle[2], 0.0f, 0.0f, factor);
        GlStateManager.func_179121_F();
        if (itemstack != null && world != null) {
            this.dummyEntityItem.field_70170_p = world;
            float renderScale = 0.75f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.6f), (float)((float)z + 0.5f));
            GlStateManager.func_179152_a((float)renderScale, (float)renderScale, (float)renderScale);
            this.dummyEntityItem.func_92058_a(itemstack);
            if (world.func_82737_E() != this.lastTick) {
                this.lastTick = world.func_82737_E();
                this.dummyEntityItem.func_70071_h_();
            }
            RenderManager rendermanager = Proxies.common.getClientInstance().func_175598_ae();
            rendermanager.func_188391_a((Entity)this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
            GlStateManager.func_179121_F();
        }
    }
}

