/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationBuilder;
import forestry.api.genetics.IMutationCondition;
import forestry.core.genetics.mutations.MutationConditionBiome;
import forestry.core.genetics.mutations.MutationConditionDaytime;
import forestry.core.genetics.mutations.MutationConditionHumidity;
import forestry.core.genetics.mutations.MutationConditionRequiresResource;
import forestry.core.genetics.mutations.MutationConditionTemperature;
import forestry.core.genetics.mutations.MutationConditionTimeLimited;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public abstract class Mutation
implements IMutation,
IMutationBuilder {
    private final int chance;
    private final IAlleleSpecies species0;
    private final IAlleleSpecies species1;
    private final IAllele[] template;
    private final List<IMutationCondition> mutationConditions = new ArrayList<IMutationCondition>();
    private final List<String> specialConditions = new ArrayList<String>();
    private boolean isSecret = false;

    protected Mutation(IAlleleSpecies species0, IAlleleSpecies species1, IAllele[] template, int chance) {
        this.species0 = species0;
        this.species1 = species1;
        this.template = template;
        this.chance = chance;
    }

    @Override
    public Collection<String> getSpecialConditions() {
        return this.specialConditions;
    }

    @Override
    public Mutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    @Override
    public Mutation restrictTemperature(EnumTemperature temperature) {
        return this.restrictTemperature(temperature, temperature);
    }

    @Override
    public Mutation restrictTemperature(EnumTemperature minTemperature, EnumTemperature maxTemperature) {
        MutationConditionTemperature mutationCondition = new MutationConditionTemperature(minTemperature, maxTemperature);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation restrictHumidity(EnumHumidity humidity) {
        return this.restrictHumidity(humidity, humidity);
    }

    @Override
    public Mutation restrictHumidity(EnumHumidity minHumidity, EnumHumidity maxHumidity) {
        MutationConditionHumidity mutationCondition = new MutationConditionHumidity(minHumidity, maxHumidity);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation restrictBiomeType(BiomeDictionary.Type ... types) {
        MutationConditionBiome mutationCondition = new MutationConditionBiome(types);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireDay() {
        MutationConditionDaytime mutationCondition = new MutationConditionDaytime(true);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireNight() {
        MutationConditionDaytime mutationCondition = new MutationConditionDaytime(false);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation restrictDateRange(int startMonth, int startDay, int endMonth, int endDay) {
        MutationConditionTimeLimited mutationCondition = new MutationConditionTimeLimited(startMonth, startDay, endMonth, endDay);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireResource(IBlockState ... acceptedBlockStates) {
        MutationConditionRequiresResource mutationCondition = new MutationConditionRequiresResource(acceptedBlockStates);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation requireResource(String oreName) {
        MutationConditionRequiresResource mutationCondition = new MutationConditionRequiresResource(oreName);
        return this.addMutationCondition(mutationCondition);
    }

    @Override
    public Mutation addMutationCondition(IMutationCondition mutationCondition) {
        this.mutationConditions.add(mutationCondition);
        this.specialConditions.add(mutationCondition.getDescription());
        return this;
    }

    protected float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float mutationChance = this.chance;
        for (IMutationCondition mutationCondition : this.mutationConditions) {
            if ((mutationChance *= mutationCondition.getChance(world, pos, allele0, allele1, genome0, genome1)) != 0.0f) continue;
            return 0.0f;
        }
        return mutationChance;
    }

    @Override
    public IAlleleSpecies getAllele0() {
        return this.species0;
    }

    @Override
    public IAlleleSpecies getAllele1() {
        return this.species1;
    }

    @Override
    public float getBaseChance() {
        return this.chance;
    }

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public boolean isPartner(IAllele allele) {
        return this.species0.getUID().equals(allele.getUID()) || this.species1.getUID().equals(allele.getUID());
    }

    @Override
    public IAllele getPartner(IAllele allele) {
        if (this.species0.getUID().equals(allele.getUID())) {
            return this.species1;
        }
        return this.species0;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }
}

