/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.tiles.TileFabricator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class InventoryFabricator
extends InventoryAdapterTile<TileFabricator> {
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_INVENTORY_1 = 3;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 21;

    public InventoryFabricator(TileFabricator fabricator) {
        super(fabricator, 21, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return FabricatorSmeltingRecipeManager.findMatchingSmelting(itemStack) != null;
        }
        if (slotIndex == 1) {
            return FabricatorRecipeManager.isPlan(itemStack);
        }
        if (SlotUtil.isSlotInRange(slotIndex, 3, 18)) {
            if (FabricatorRecipeManager.isPlan(itemStack)) {
                return false;
            }
            if (FabricatorSmeltingRecipeManager.findMatchingSmelting(itemStack) != null) {
                return false;
            }
        }
        return SlotUtil.isSlotInRange(slotIndex, 3, 18);
    }

    @Override
    public boolean func_180461_b(int slotIndex, ItemStack stack, EnumFacing side) {
        return slotIndex == 2;
    }
}

