/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.greenhouse.IGreenhouseHousing;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IGreenhouseController;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileGreenhouse;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class TileGreenhouseClimatiser
extends TileGreenhouse
implements IActivatable,
IGreenhouseComponent.Climatiser {
    protected static final int WORK_CYCLES = 1;
    protected static final int ENERGY_PER_OPERATION = 50;
    private final IClimitiserDefinition definition;
    protected int workingTime = 0;
    private boolean active;

    protected TileGreenhouseClimatiser(IClimitiserDefinition definition) {
        this.definition = definition;
    }

    @Override
    public <G extends IGreenhouseController & IGreenhouseHousing> void changeClimate(int tick, G greenhouse) {
        IGreenhouseControllerInternal greenhouseInternal = (IGreenhouseControllerInternal)greenhouse;
        if (this.workingTime < 20 && greenhouseInternal.getEnergyManager().consumeEnergyToDoWork(1, 50)) {
            this.workingTime += 5;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            if (this.definition.getType() == ClimitiserType.TEMPERATURE) {
                greenhouse.addTemperatureChange(this.definition.getChangePerTransfer(), this.definition.getBoundaryDown(), this.definition.getBoundaryUp());
            } else if (this.definition.getType() == ClimitiserType.HUMIDITY) {
                greenhouse.addHumidityChange(this.definition.getChangePerTransfer(), this.definition.getBoundaryDown(), this.definition.getBoundaryUp());
            }
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.workingTime = nbttagcompound.func_74762_e("Heating");
        this.setActive(this.workingTime > 0);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.workingTime);
        return nbttagcompound;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public IClimitiserDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            } else {
                Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
            }
        }
    }

    protected static interface IClimitiserDefinition {
        public float getChangePerTransfer();

        public float getBoundaryUp();

        public float getBoundaryDown();

        public ClimitiserType getType();
    }

    protected static enum ClimitiserType {
        TEMPERATURE,
        HUMIDITY;

    }
}

