/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class TileApiary
extends TileBeeHousingBase
implements IApiary {
    @Nonnull
    private final IBeeModifier beeModifier = new ApiaryBeeModifier();
    @Nonnull
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    @Nonnull
    private final InventoryApiary inventory = new InventoryApiary(this.getAccessHandler());

    public TileApiary() {
        super("apiary");
        this.setInternalInventory(this.inventory);
    }

    @Override
    @Nonnull
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(this.beeModifier);
        for (IHiveFrame frame : this.inventory.getFrames()) {
            beeModifiers.add(frame.getBeeModifier());
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        ContainerBeeHousing container = new ContainerBeeHousing(player.field_71071_by, this, true);
        return new GuiBeeHousing<ContainerBeeHousing>(this, container, GuiBeeHousing.Icon.APIARY);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerBeeHousing(player.field_71071_by, this, true);
    }
}

