package forestry.arboriculture.tiles;

import javax.annotation.Nonnull;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.multiblock.ICharcoalPileComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockPile;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.multiblock.EnumPilePosition;
import forestry.arboriculture.multiblock.MultiblockLogicCharcoalPile;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.tiles.TileUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePile extends MultiblockTileEntityForestry<MultiblockLogicCharcoalPile> implements ICharcoalPileComponent<MultiblockLogicCharcoalPile>{

	private IAlleleTreeSpecies treeSpecies;
	@SideOnly(Side.CLIENT)
	private BlockPos woodPos;

	public TilePile() {
		super(new MultiblockLogicCharcoalPile());
	}

	@Override
	public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
		// Re-render this block on the client
		if (field_145850_b.field_72995_K) {
			this.field_145850_b.func_175704_b(func_174877_v(), func_174877_v());
		}
		field_145850_b.func_180496_d(func_174877_v(), func_145838_q());
		
		if(getPileType() != EnumPileType.ASH){
			this.field_145850_b.func_180501_a(func_174877_v(), updateState(), 2);
		}
	}

	@Override
	public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
		Block newBlock = newState.func_177230_c();
		return oldState.func_177230_c() != newBlock && newBlock != PluginArboriculture.blocks.piles.get(EnumPileType.ASH);
	}

	@Override
	public void onMachineBroken() {
		// Re-render this block on the client
		if (field_145850_b.field_72995_K) {
			this.field_145850_b.func_175704_b(func_174877_v(), func_174877_v());
			woodPos = null;
		}
		field_145850_b.func_180496_d(func_174877_v(), func_145838_q());
		func_70296_d();
		if(getPileType() != EnumPileType.ASH){
			this.field_145850_b.func_180501_a(func_174877_v(), updateState(), 2);
		}
	}
	
	private IBlockState updateState() {
		TilePile pile = TileUtil.getTile(field_145850_b, field_174879_c, TilePile.class);
		EnumPilePosition pileType =  EnumPilePosition.INTERIOR;
		if(pile != null && pile.getMultiblockLogic().isConnected() && pile.getMultiblockLogic().getController().isAssembled()){
			BlockPos maxCoord = pile.getMultiblockLogic().getController().getMaximumCoord();
			BlockPos minCoord = pile.getMultiblockLogic().getController().getMinimumCoord();
			int level = field_174879_c.func_177956_o() - minCoord.func_177956_o();
			
			int levelMinX = minCoord.func_177958_n() + level;
			int levelMinY = minCoord.func_177956_o() + level;
			int levelMinZ = minCoord.func_177952_p() + level;
			int levelMaxX = maxCoord.func_177958_n() - level;
			int levelMaxY = maxCoord.func_177956_o() - level;
			int levelMaxZ = maxCoord.func_177952_p() - level;
			int facesMatching = 0;
			if (levelMaxX == field_174879_c.func_177958_n() || levelMinX == field_174879_c.func_177958_n()) {
				facesMatching++;
			}
			if (levelMaxZ == field_174879_c.func_177952_p() || levelMinZ == field_174879_c.func_177952_p()) {
				facesMatching++;
			}
			
			if ( facesMatching > 0 ) {
				if (levelMaxX == field_174879_c.func_177958_n()) {
					if (levelMaxZ == field_174879_c.func_177952_p()) {
						pileType = EnumPilePosition.CORNER_BACK_RIGHT;
					} else if (levelMinZ == field_174879_c.func_177952_p()) {
						pileType = EnumPilePosition.CORNER_FRONT_RIGHT;
					} else {
						pileType = EnumPilePosition.SIDE_RIGHT;
					}
				} else if (levelMinX == field_174879_c.func_177958_n()) {
					if (levelMaxZ == field_174879_c.func_177952_p()) {
						pileType = EnumPilePosition.CORNER_BACK_LEFT;
					} else if (levelMinZ == field_174879_c.func_177952_p()) {
						pileType = EnumPilePosition.CORNER_FRONT_LEFT;
					} else {
						pileType = EnumPilePosition.SIDE_LEFT;
					}
				} else if (levelMaxZ == field_174879_c.func_177952_p()) {
					if (levelMaxX == field_174879_c.func_177958_n()) {
						pileType = EnumPilePosition.CORNER_FRONT_RIGHT;
					} else if (levelMinX == field_174879_c.func_177958_n()) {
						pileType = EnumPilePosition.CORNER_FRONT_LEFT;
					} else {
						pileType = EnumPilePosition.FRONT;
					}
				} else if (levelMinZ == field_174879_c.func_177952_p()) {
					if (levelMaxX == field_174879_c.func_177958_n()) {
						pileType = EnumPilePosition.CORNER_BACK_RIGHT;
					} else if (levelMinX == field_174879_c.func_177958_n()) {
						pileType = EnumPilePosition.CORNER_BACK_LEFT;
					} else {
						pileType = EnumPilePosition.BACK;
					}
				}
			}
		}
		return func_145838_q().func_176223_P().func_177226_a(BlockPile.PILE_POSITION, pileType);
	}
	
	@Override
	public void func_145839_a(NBTTagCompound data) {
		super.func_145839_a(data);

		// legacy
		if (data.func_74764_b("ContainedTree")) {
			Tree containedTree = new Tree(data.func_74775_l("ContainedTree"));
			setTreeSpecies(containedTree.getGenome().getPrimary());
		}

		if (data.func_74764_b("TreeSpecies")) {
			String treeSpeciesUid = data.func_74779_i("TreeSpecies");
			IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies) AlleleManager.alleleRegistry.getAllele(treeSpeciesUid);
			setTreeSpecies(treeSpecies);
		}
	}
	
	@Nonnull
	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound data) {
		data = super.func_189515_b(data);
		if (treeSpecies != null) {
			data.func_74778_a("TreeSpecies", treeSpecies.getUID());
		}
		return data;
	}
	
	@Override
	protected void encodeDescriptionPacket(NBTTagCompound packetData) {
		super.encodeDescriptionPacket(packetData);
		if (treeSpecies != null) {
			packetData.func_74778_a("TreeSpecies", treeSpecies.getUID());
		}
	}

	@Override
	protected void decodeDescriptionPacket(NBTTagCompound packetData) {
		super.decodeDescriptionPacket(packetData);
		if (packetData.func_74764_b("TreeSpecies")) {
			String treeSpeciesUid = packetData.func_74779_i("TreeSpecies");
			IAlleleTreeSpecies treeSpecies = (IAlleleTreeSpecies) AlleleManager.alleleRegistry.getAllele(treeSpeciesUid);
			setTreeSpecies(treeSpecies);
		}
	}
	
	/* CLIENT INFORMATION */
	
	/* CONTAINED TREE */
	@Override
	public void setTreeSpecies(@Nonnull IAlleleTreeSpecies treeSpecies) {
		this.treeSpecies = treeSpecies;
		if (field_145850_b != null && field_145850_b.field_72995_K) {
			field_145850_b.func_175704_b(func_174877_v(), func_174877_v());
		}
	}
	
	@Override
	public IAlleleTreeSpecies getTreeSpecies() {
		return this.treeSpecies;
	}
	
	@Override
	public EnumPileType getPileType() {
		IBlockState state = field_145850_b.func_180495_p(field_174879_c);
		return ((BlockPile)state.func_177230_c()).getPileType();
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public IAlleleTreeSpecies getNextWoodPile() {
		if(woodPos == null){
			woodPos = getNextWoodPilePos();
		}
		TilePile pile = TileUtil.getTile(field_145850_b, woodPos, TilePile.class);
		if (pile != null) {
			return pile.getTreeSpecies();
		}
		return null;
	}
	
	@SideOnly(Side.CLIENT)
	private BlockPos getNextWoodPilePos(){
		EnumPilePosition pilePos = field_145850_b.func_180495_p(field_174879_c).func_177229_b(BlockPile.PILE_POSITION);
		int layer = field_174879_c.func_177956_o() - getMultiblockLogic().getController().getMinimumCoord().func_177956_o();
		IBlockState state;
		Block woodPile = PluginArboriculture.blocks.piles.get(EnumPileType.WOOD);
		switch (pilePos) {
		case BACK:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(0, 0, 1));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(0, 0, 1);
		case FRONT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(0, 0, -1));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(0, 0, -1);
		case SIDE_LEFT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(1, 0, 0));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(1, 0, 0);
		case SIDE_RIGHT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(-1, 0, 0));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(-1, 0, 0);
		case CORNER_FRONT_LEFT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(1, 0, 1));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(1, 0, 1);
		case CORNER_FRONT_RIGHT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(-1, 0, 1));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(-1, 0, 1);
		case CORNER_BACK_LEFT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(1, 0, -1));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(1, 0, -1);
		case CORNER_BACK_RIGHT:
			state = field_145850_b.func_180495_p(field_174879_c.func_177982_a(-1, 0, -1));
			if(state.func_177230_c() != woodPile){
				return field_174879_c.func_177982_a(0, -1, 0);
			}
			return field_174879_c.func_177982_a(-1, 0, -1);
		default:
			return field_174879_c.func_177982_a(0, -1, 0);
		}
		
	}

	@Override
	public Object getGui(EntityPlayer player, int data) {
		return null;
	}

	@Override
	public Object getContainer(EntityPlayer player, int data) {
		return null;
	}
}
