/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.core.IC2;
import ic2.core.util.LogCategory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.util.ResourceLocation;

public class ProfileManager {
    private static final File PACK;
    private static ZipFile zip;

    public static File getPack() {
        return PACK;
    }

    public static InputStream getFromPack(ResourceLocation location) throws IOException {
        return ProfileManager.getFromPack(String.format("assets/%s/%s", location.func_110624_b(), location.func_110623_a()));
    }

    public static InputStream getFromPack(String name) throws IOException {
        ZipEntry entry;
        if (zip == null) {
            zip = new ZipFile(PACK);
        }
        if ((entry = zip.getEntry(name)) == null) {
            throw new FileNotFoundException(String.format("'%s' in '%s'", name, PACK));
        }
        return zip.getInputStream(entry);
    }

    static {
        File pack;
        try {
            pack = new File(ProfileManager.class.getResource("/assets/ic2/config/alt.zip").toURI());
        }
        catch (URISyntaxException e) {
            try {
                pack = File.createTempFile("recovery_attempt", ".tmp");
                try (InputStream input = ProfileManager.class.getResourceAsStream("/assets/ic2/config/alt.zip");
                     FileOutputStream out = new FileOutputStream(pack);){
                    int read;
                    byte[] bytes = new byte[1024];
                    while ((read = input.read(bytes)) != -1) {
                        ((OutputStream)out).write(bytes, 0, read);
                    }
                }
                pack.deleteOnExit();
            }
            catch (IOException io) {
                IC2.log.error(LogCategory.Resource, e, "Recovery attempt failed");
                throw new RuntimeException("Error getting file URL", io);
            }
        }
        PACK = pack;
    }
}

