/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import ic2.api.crops.ICropTile;
import ic2.core.crop.IC2CropCard;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockCrops;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class CropVanilla
extends IC2CropCard {
    private final BlockCrops block;

    protected CropVanilla(BlockCrops block) {
        this.block = block;
    }

    @Override
    public List<ResourceLocation> getTexturesLocation() {
        ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(this.getMaxSize());
        for (int size = 1; size <= this.getMaxSize(); ++size) {
            ret.add(new ResourceLocation("blocks/" + this.getId() + "_stage_" + size));
        }
        return ret;
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public int getMaxSize() {
        return this.block.func_185526_g();
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getCurrentSize() < this.getMaxSize() && crop.getLightLevel() >= 9;
    }

    protected abstract ItemStack getSeeds();

    protected abstract ItemStack getProduct();

    @Override
    public ItemStack getGain(ICropTile crop) {
        return this.getProduct();
    }

    @Override
    public ItemStack getSeeds(ICropTile crop) {
        if (crop.getStatGain() <= 1 && crop.getStatGrowth() <= 1 && crop.getStatResistance() <= 1) {
            return this.getSeeds();
        }
        return this.getProduct();
    }
}

