/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.network.GuiSynced;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityConversionGenerator
extends TileEntityInventory
implements IHasGui,
IEnergySource {
    @GuiSynced
    private double production;
    private boolean registeredToEnet;
    private boolean newActive;

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() != this.newActive) {
            this.setActive(this.newActive);
        }
        if (!this.newActive) {
            this.getOfferedEnergy();
        }
        this.newActive = false;
    }

    @Override
    protected void onUnloaded() {
        super.onUnloaded();
        if (this.registeredToEnet && !this.field_145850_b.field_72995_K) {
            EnergyNet.instance.removeTile(this);
            this.registeredToEnet = false;
        }
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (!this.registeredToEnet && !this.field_145850_b.field_72995_K) {
            EnergyNet.instance.addTile(this);
            this.registeredToEnet = true;
        }
    }

    public double getProduction() {
        return this.production;
    }

    public ContainerBase<TileEntityConversionGenerator> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    protected abstract int getEnergyAvailable();

    protected abstract void drawEnergyAvailable(int var1);

    protected abstract double getMultiplier();

    @Override
    public double getOfferedEnergy() {
        this.production = (double)this.getEnergyAvailable() * this.getMultiplier();
        return this.production;
    }

    @Override
    public void drawEnergy(double amount) {
        this.drawEnergyAvailable((int)Math.ceil(amount / this.getMultiplier()));
    }

    @Override
    public int getSourceTier() {
        return Math.max(EnergyNet.instance.getTierFromPower(this.production), 2);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return side != this.getFacing();
    }
}

