/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import ic2.core.item.armor.ItemArmorFluidTank;
import ic2.core.item.armor.jetpack.IJetpack;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.util.Util;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorJetpack
extends ItemArmorFluidTank
implements IJetpack {
    public ItemArmorJetpack() {
        super(ItemName.jetpack, "jetpack", FluidName.biogas.getInstance(), 30000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack stack = new ItemStack((Item)this, 1);
        this.filltank(stack);
        stack.func_77964_b(1);
        subItems.add((Object)stack);
        stack = new ItemStack((Item)this, 1);
        stack.func_77964_b(this.func_77612_l());
        subItems.add((Object)stack);
    }

    @Override
    public boolean drainEnergy(ItemStack pack, int amount) {
        if (this.isEmpty(pack)) {
            return false;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)pack);
        assert (handler != null);
        FluidStack drained = handler.drain(amount, false);
        if (drained == null || drained.amount < amount) {
            return false;
        }
        handler.drain(amount, true);
        this.Updatedamage(pack);
        return true;
    }

    @Override
    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public float getDropPercentage(ItemStack stack) {
        return 0.2f;
    }

    @Override
    public boolean isJetpackActive(ItemStack stack) {
        return true;
    }

    @Override
    public double getChargeLevel(ItemStack stack) {
        return this.getCharge(stack) / this.getMaxCharge(stack);
    }

    @Override
    public float getHoverMultiplier(ItemStack stack, boolean upwards) {
        return 0.2f;
    }

    @Override
    public float getWorldHeightDivisor(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public int getBarPercent(ItemStack stack) {
        return (int)Util.map(this.getCharge(stack), this.getMaxCharge(stack), 100.0);
    }
}

