/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.energy.EnergyNet;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import ic2.api.item.IEnhancedOverlayProvider;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import ic2.api.tile.ExplosionWhitelist;
import ic2.api.tile.IWrenchable;
import ic2.api.util.Keys;
import ic2.core.ChunkLoaderLogic;
import ic2.core.CreativeTabIC2;
import ic2.core.EnhancedOverlay;
import ic2.core.ExplosionIC2;
import ic2.core.IC2Achievements;
import ic2.core.IC2BucketHandler;
import ic2.core.IC2Potion;
import ic2.core.Ic2WorldDecorator;
import ic2.core.Platform;
import ic2.core.TickHandler;
import ic2.core.WorldData;
import ic2.core.apihelper.ApiHelper;
import ic2.core.audio.AudioManager;
import ic2.core.block.BlockIC2Fluid;
import ic2.core.block.EntityDynamite;
import ic2.core.block.EntityItnt;
import ic2.core.block.EntityNuke;
import ic2.core.block.EntityStickyDynamite;
import ic2.core.block.comp.Components;
import ic2.core.block.comp.Obscuration;
import ic2.core.block.generator.tileentity.TileEntitySemifluidGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityFluidHeatGenerator;
import ic2.core.block.machine.tileentity.TileEntityBlastFurnace;
import ic2.core.block.machine.tileentity.TileEntityBlockCutter;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityCentrifuge;
import ic2.core.block.machine.tileentity.TileEntityCompressor;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityExtractor;
import ic2.core.block.machine.tileentity.TileEntityFermenter;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.block.machine.tileentity.TileEntityMacerator;
import ic2.core.block.machine.tileentity.TileEntityMatter;
import ic2.core.block.machine.tileentity.TileEntityMetalFormer;
import ic2.core.block.machine.tileentity.TileEntityOreWashing;
import ic2.core.block.machine.tileentity.TileEntityRecycler;
import ic2.core.block.steam.TileEntityCokeKiln;
import ic2.core.command.CommandIc2;
import ic2.core.crop.IC2Crops;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.init.BlocksItems;
import ic2.core.init.Ic2Loot;
import ic2.core.init.Localization;
import ic2.core.init.MainConfig;
import ic2.core.init.OreValues;
import ic2.core.init.Rezepte;
import ic2.core.item.ElectricItemManager;
import ic2.core.item.EntityBoatCarbon;
import ic2.core.item.EntityBoatElectric;
import ic2.core.item.EntityBoatRubber;
import ic2.core.item.EntityIC2Boat;
import ic2.core.item.GatewayElectricItemManager;
import ic2.core.item.ItemIC2Boat;
import ic2.core.item.armor.jetpack.JetpackAttachmentRecipe;
import ic2.core.item.armor.jetpack.JetpackHandler;
import ic2.core.item.tfbp.Tfbp;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.item.tool.EntityParticle;
import ic2.core.item.type.CellType;
import ic2.core.item.type.CraftingItemType;
import ic2.core.network.NetworkManager;
import ic2.core.profile.ProfileManager;
import ic2.core.profile.Version;
import ic2.core.recipe.OreDictionaryEntries;
import ic2.core.recipe.RecipeInputFactory;
import ic2.core.recipe.ScrapboxRecipeManager;
import ic2.core.ref.BlockName;
import ic2.core.ref.ItemName;
import ic2.core.ref.TeBlock;
import ic2.core.util.ConfigUtil;
import ic2.core.util.ItemInfo;
import ic2.core.util.Keyboard;
import ic2.core.util.Log;
import ic2.core.util.LogCategory;
import ic2.core.util.PriorityExecutor;
import ic2.core.util.RotationUtil;
import ic2.core.util.SideGateway;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import ic2.core.uu.UuIndex;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.lwjgl.opengl.GL11;

@Mod(modid="ic2", name="IndustrialCraft 2", version="2.8.218-ex112", acceptedMinecraftVersions="[1.12]", useMetadata=true, certificateFingerprint="de041f9f6187debbc77034a344134053277aa3b0", dependencies="required-after:forge@[13.20.0.2206,)", guiFactory="ic2.core.gui.Ic2GuiFactory")
public class IC2
implements IFuelHandler {
    public static final String VERSION = "2.8.218-ex112";
    public static final String MODID = "ic2";
    public static final String RESOURCE_DOMAIN = "ic2";
    private static IC2 instance;
    @SidedProxy(clientSide="ic2.core.PlatformClient", serverSide="ic2.core.Platform")
    public static Platform platform;
    public static SideGateway<NetworkManager> network;
    @SidedProxy(clientSide="ic2.core.util.KeyboardClient", serverSide="ic2.core.util.Keyboard")
    public static Keyboard keyboard;
    @SidedProxy(clientSide="ic2.core.audio.AudioManagerClient", serverSide="ic2.core.audio.AudioManager")
    public static AudioManager audioManager;
    public static Log log;
    public static IC2Achievements achievements;
    public static TickHandler tickHandler;
    public static Random random;
    public static boolean suddenlyHoes;
    public static boolean seasonal;
    public static boolean initialized;
    public static Version version;
    public static final CreativeTabIC2 tabIC2;
    public static final int setBlockNotify = 1;
    public static final int setBlockUpdate = 2;
    public static final int setBlockNoUpdateFromClient = 4;
    public final PriorityExecutor threadPool = new PriorityExecutor(Math.max(Runtime.getRuntime().availableProcessors(), 2));

    public IC2() {
        instance = this;
        Info.ic2ModInstance = instance;
    }

    public static IC2 getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        long startTime = System.nanoTime();
        log = new Log(event.getModLog());
        log.debug(LogCategory.General, "Starting pre-init.");
        MainConfig.load();
        ProfileManager.init();
        Localization.preInit(event.getSourceFile());
        tickHandler = new TickHandler();
        audioManager.initialize();
        Recipes.inputFactory = new RecipeInputFactory();
        ElectricItem.manager = new GatewayElectricItemManager();
        ElectricItem.rawManager = new ElectricItemManager();
        Info.itemInfo = new ItemInfo();
        Keys.instance = keyboard;
        Components.init();
        BlocksItems.init();
        Blocks.field_150343_Z.func_149752_b(60.0f);
        Blocks.field_150381_bn.func_149752_b(60.0f);
        Blocks.field_150477_bB.func_149752_b(60.0f);
        Blocks.field_150467_bQ.func_149752_b(60.0f);
        Blocks.field_150355_j.func_149752_b(30.0f);
        Blocks.field_150358_i.func_149752_b(30.0f);
        Blocks.field_150353_l.func_149752_b(30.0f);
        ExplosionWhitelist.addWhitelistedBlock(Blocks.field_150357_h);
        ScrapboxRecipeManager.setup();
        Tfbp.init();
        TileEntityCanner.init();
        TileEntityCompressor.init();
        TileEntityExtractor.init();
        TileEntityMacerator.init();
        TileEntityRecycler.init();
        TileEntityCentrifuge.init();
        TileEntityMatter.init();
        TileEntityMetalFormer.init();
        TileEntitySemifluidGenerator.init();
        TileEntityOreWashing.init();
        TileEntityFluidHeatGenerator.init();
        TileEntityBlockCutter.init();
        TileEntityBlastFurnace.init();
        TileEntityLiquidHeatExchanger.init();
        TileEntityFermenter.init();
        TileEntityElectrolyzer.init();
        TileEntityCokeKiln.init();
        Rezepte.registerRecipes();
        EntityIC2Boat.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        Rezepte.registerWithSorter();
        for (String oreName : OreDictionary.getOreNames()) {
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                this.registerOre(new OreDictionary.OreRegisterEvent(oreName, ore));
            }
        }
        OreDictionaryEntries.load();
        EnergyNet.instance = EnergyNetGlobal.create();
        IC2Crops.init();
        IC2Potion.init();
        ApiHelper.preload();
        achievements = new IC2Achievements();
        Ic2Loot.init();
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("mining_laser"), EntityMiningLaser.class, (String)"MiningLaser", (int)0, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("dynamite"), EntityDynamite.class, (String)"Dynamite", (int)1, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("sticky_dynamite"), EntityStickyDynamite.class, (String)"StickyDynamite", (int)2, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("itnt"), EntityItnt.class, (String)"Itnt", (int)3, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("nuke"), EntityNuke.class, (String)"Nuke", (int)4, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("carbon_boat"), EntityBoatCarbon.class, (String)"BoatCarbon", (int)5, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("rubber_boat"), EntityBoatRubber.class, (String)"BoatRubber", (int)6, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("electric_boat"), EntityBoatElectric.class, (String)"BoatElectric", (int)7, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("particle"), EntityParticle.class, (String)"Particle", (int)8, (Object)this, (int)160, (int)1, (boolean)true);
        if (Util.inDev()) {
            EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("beam"), ic2.core.block.beam.EntityParticle.class, (String)"Beam", (int)9, (Object)this, (int)160, (int)1, (boolean)true);
        }
        EntityRegistry.registerModEntity((ResourceLocation)IC2.getIdentifier("fireproof_item"), ItemIC2Boat.FireproofItem.class, (String)"FireproofItem", (int)10, (Object)this, (int)80, (int)1, (boolean)false);
        int d = Integer.parseInt(new SimpleDateFormat("Mdd").format(new Date()));
        suddenlyHoes = (double)d > Math.cbrt(6.4E7) && (double)d < Math.cbrt(6.5939264E7);
        seasonal = (double)d > Math.cbrt(1.089547389E9) && (double)d < Math.cbrt(1.338273208E9);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new Ic2WorldDecorator(), (int)0);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        MinecraftForge.EVENT_BUS.register((Object)new IC2BucketHandler());
        TeBlock.registerTeMappings();
        Obscuration.ObscurationComponentEventHandler.init();
        platform.preInit();
        initialized = true;
        log.debug(LogCategory.General, "Finished pre-init after %d ms.", (System.nanoTime() - startTime) / 1000000L);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        long startTime = System.nanoTime();
        log.debug(LogCategory.General, "Starting init.");
        ScrapboxRecipeManager.load();
        new ChunkLoaderLogic();
        TeBlock.buildDummies();
        IC2Crops.ensureInit();
        log.debug(LogCategory.General, "Finished init after %d ms.", (System.nanoTime() - startTime) / 1000000L);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        long startTime = System.nanoTime();
        log.debug(LogCategory.General, "Starting post-init.");
        if (!initialized) {
            platform.displayError("IndustrialCraft 2 has failed to initialize properly.", new Object[0]);
        }
        Rezepte.loadFailedRecipes();
        for (IRecipeInput input : ConfigUtil.asRecipeInputList(MainConfig.get(), "misc/additionalValuableOres")) {
            for (ItemStack stack : input.getInputs()) {
                OreValues.add(stack, 1);
            }
        }
        if (IC2.loadSubModule("bcIntegration")) {
            log.debug(LogCategory.SubModule, "BuildCraft integration module loaded.");
        }
        ArrayList<IRecipeInput> purgedRecipes = new ArrayList<IRecipeInput>();
        purgedRecipes.addAll(ConfigUtil.asRecipeInputList(MainConfig.get(), "recipes/purge"));
        if (ConfigUtil.getBool(MainConfig.get(), "balance/disableEnderChest")) {
            purgedRecipes.add(Recipes.inputFactory.forStack(new ItemStack(Blocks.field_150477_bB)));
        }
        ArrayList<IRecipe> recipesToPurge = new ArrayList<IRecipe>();
        block2: for (IRecipe recipe : ForgeRegistries.RECIPES) {
            ItemStack itemStack = recipe.func_77571_b();
            if (StackUtil.isEmpty(itemStack) || recipe.getRegistryName().func_110624_b() == "ic2") continue;
            for (IRecipeInput input : purgedRecipes) {
                if (!input.matches(itemStack)) continue;
                recipesToPurge.add(recipe);
                continue block2;
            }
        }
        recipesToPurge.stream().map(IForgeRegistryEntry::getRegistryName).forEach(arg_0 -> ((IForgeRegistryModifiable)((IForgeRegistryModifiable)ForgeRegistries.RECIPES)).remove(arg_0));
        if (ConfigUtil.getBool(MainConfig.get(), "recipes/smeltToIc2Items")) {
            Map smeltingMap = FurnaceRecipes.func_77602_a().func_77599_b();
            block4: for (Map.Entry entry : smeltingMap.entrySet()) {
                ItemStack output = (ItemStack)entry.getValue();
                if (StackUtil.isEmpty(output)) continue;
                boolean found = false;
                for (int oreId : OreDictionary.getOreIDs((ItemStack)output)) {
                    String oreName = OreDictionary.getOreName((int)oreId);
                    for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                        if (ore.func_77973_b() == null || !Util.getName(ore.func_77973_b()).func_110624_b().equals("ic2")) continue;
                        entry.setValue(StackUtil.copyWithSize(ore, StackUtil.getSize(output)));
                        found = true;
                        break;
                    }
                    if (found) continue block4;
                }
            }
        }
        TileEntityRecycler.initLate();
        JetpackAttachmentRecipe.init();
        JetpackHandler.init();
        UuIndex.instance.init();
        UuIndex.instance.refresh(true);
        platform.onPostInit();
        log.debug(LogCategory.General, "Finished post-init after %d ms.", (System.nanoTime() - startTime) / 1000000L);
        log.info(LogCategory.General, "%s version %s loaded.", "ic2", VERSION);
    }

    @Mod.EventHandler
    public void finished(FMLLoadCompleteEvent event) {
    }

    private static boolean loadSubModule(String name) {
        log.debug(LogCategory.SubModule, "Loading %s submodule: %s.", "ic2", name);
        try {
            Class<?> subModuleClass = IC2.class.getClassLoader().loadClass("ic2." + name + ".SubModule");
            return (Boolean)subModuleClass.getMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            log.debug(LogCategory.SubModule, "Submodule %s not loaded.", name);
            return false;
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandIc2());
    }

    public int getBurnTime(ItemStack stack) {
        if (!BlockName.sapling.hasItemStack()) {
            return 0;
        }
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (StackUtil.checkItemEquality(stack, BlockName.sapling.getItemStack())) {
                return 80;
            }
            if (item == Items.field_151120_aE) {
                return 50;
            }
            if (item == Item.func_150898_a((Block)Blocks.field_150434_aF)) {
                return 50;
            }
            if (StackUtil.checkItemEquality(stack, ItemName.crafting.getItemStack(CraftingItemType.scrap))) {
                return 350;
            }
            if (StackUtil.checkItemEquality(stack, ItemName.crafting.getItemStack(CraftingItemType.scrap_box))) {
                return 3150;
            }
            if (item == ItemName.fluid_cell.getInstance()) {
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
                if (fs != null && fs.getFluid() == FluidRegistry.LAVA) {
                    int ret = TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151129_at));
                    return ret * fs.amount / 1000;
                }
            } else if (StackUtil.checkItemEquality(stack, ItemName.cell.getItemStack(CellType.lava))) {
                return TileEntityFurnace.func_145952_a((ItemStack)new ItemStack(Items.field_151129_at));
            }
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (platform.isSimulating()) {
            keyboard.removePlayerReferences(event.player);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        WorldData.onWorldUnload(event.getWorld());
    }

    public static void explodeMachineAt(World world, int x, int y, int z, boolean noDrop) {
        ExplosionIC2 explosion = new ExplosionIC2(world, null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 2.5f, 0.75f);
        explosion.destroy(x, y, z, noDrop);
        explosion.doExplosion();
    }

    public static int getSeaLevel(World world) {
        return world.field_73011_w.func_76557_i();
    }

    public static int getWorldHeight(World world) {
        return world.func_72800_K();
    }

    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent event) {
        String oreClass = event.getName();
        ItemStack ore = event.getOre();
        if (!(ore.func_77973_b() instanceof ItemBlock)) {
            return;
        }
        int multiplier = 1;
        if (oreClass.startsWith("dense")) {
            multiplier *= 3;
            oreClass = oreClass.substring("dense".length());
        }
        int value = 0;
        if (oreClass.equals("oreCoal")) {
            value = 1;
        } else if (oreClass.equals("oreCopper") || oreClass.equals("oreTin") || oreClass.equals("oreLead") || oreClass.equals("oreQuartz")) {
            value = 2;
        } else if (oreClass.equals("oreIron") || oreClass.equals("oreGold") || oreClass.equals("oreRedstone") || oreClass.equals("oreLapis") || oreClass.equals("oreSilver")) {
            value = 3;
        } else if (oreClass.equals("oreUranium") || oreClass.equals("oreGemRuby") || oreClass.equals("oreGemGreenSapphire") || oreClass.equals("oreGemSapphire") || oreClass.equals("oreRuby") || oreClass.equals("oreGreenSapphire") || oreClass.equals("oreSapphire")) {
            value = 4;
        } else if (oreClass.equals("oreDiamond") || oreClass.equals("oreEmerald") || oreClass.equals("oreTungsten")) {
            value = 5;
        } else if (oreClass.startsWith("ore")) {
            value = 1;
        }
        if (value > 0 && multiplier >= 1) {
            OreValues.add(ore, value * multiplier);
        }
    }

    @SubscribeEvent
    public void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (seasonal && (event.getEntityLiving() instanceof EntityZombie || event.getEntityLiving() instanceof EntitySkeleton) && event.getEntityLiving().func_130014_f_().field_73012_v.nextFloat() < 0.1f) {
            EntityLiving entity = (EntityLiving)event.getEntityLiving();
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                entity.func_184642_a(slot, Float.NEGATIVE_INFINITY);
            }
            if (entity instanceof EntityZombie) {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemName.nano_saber.getItemStack());
            }
            if (entity.func_130014_f_().field_73012_v.nextFloat() < 0.1f) {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, ItemName.quantum_helmet.getItemStack());
                entity.func_184201_a(EntityEquipmentSlot.CHEST, ItemName.quantum_chestplate.getItemStack());
                entity.func_184201_a(EntityEquipmentSlot.LEGS, ItemName.quantum_leggings.getItemStack());
                entity.func_184201_a(EntityEquipmentSlot.FEET, ItemName.quantum_boots.getItemStack());
            } else {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, ItemName.nano_helmet.getItemStack());
                entity.func_184201_a(EntityEquipmentSlot.CHEST, ItemName.nano_chestplate.getItemStack());
                entity.func_184201_a(EntityEquipmentSlot.LEGS, ItemName.nano_leggings.getItemStack());
                entity.func_184201_a(EntityEquipmentSlot.FEET, ItemName.nano_boots.getItemStack());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onViewRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (!(event.getState().func_177230_c() instanceof BlockIC2Fluid)) {
            return;
        }
        event.setCanceled(true);
        Fluid fluid = ((BlockIC2Fluid)event.getState().func_177230_c()).getFluid();
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        event.setDensity((float)Util.map(Math.abs(fluid.getDensity()), 20000.0, 2.0));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onViewRenderFogColors(EntityViewRenderEvent.FogColors event) {
        if (!(event.getState().func_177230_c() instanceof BlockIC2Fluid)) {
            return;
        }
        int color = ((BlockIC2Fluid)event.getState().func_177230_c()).getColor();
        event.setRed((float)(color >>> 16 & 0xFF) / 255.0f);
        event.setGreen((float)(color >>> 8 & 0xFF) / 255.0f);
        event.setBlue((float)(color & 0xFF) / 255.0f);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderEnhancedOverlay(DrawBlockHighlightEvent event) {
        ItemStack inHand = StackUtil.get(event.getPlayer(), EnumHand.MAIN_HAND);
        if (event.getSubID() == 0 && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && inHand.func_77973_b() instanceof IEnhancedOverlayProvider) {
            World world = event.getPlayer().field_70170_p;
            BlockPos blockPos = event.getTarget().func_178782_a();
            EnumFacing side = event.getTarget().field_178784_b;
            if (((IEnhancedOverlayProvider)inHand.func_77973_b()).providesEnhancedOverlay(world, blockPos, side, event.getPlayer(), inHand)) {
                GL11.glPushMatrix();
                EnhancedOverlay.transformToFace((Entity)event.getPlayer(), blockPos, side, event.getPartialTicks());
                GL11.glLineWidth((float)2.0f);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                GL11.glBegin((int)1);
                GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.5);
                GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.5);
                GL11.glVertex3d((double)0.5, (double)0.0, (double)0.5);
                GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.5);
                GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.5);
                GL11.glVertex3d((double)0.5, (double)0.0, (double)0.5);
                GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.5);
                GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.5);
                GL11.glEnd();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                EnumMap<EnumFacing, Runnable> additionalRenders = new EnumMap<EnumFacing, Runnable>(EnumFacing.class);
                if (world.func_180495_p(blockPos).func_177230_c() instanceof IWrenchable) {
                    EnumFacing hoveredSpin = RotationUtil.rotateByRay(event.getTarget());
                    IWrenchable block = (IWrenchable)world.func_180495_p(blockPos).func_177230_c();
                    ArrayList<EnhancedOverlay.Segment> skippedSegments = new ArrayList<EnhancedOverlay.Segment>();
                    for (EnhancedOverlay.Segment segment : EnhancedOverlay.Segment.values()) {
                        EnumFacing spin;
                        switch (segment) {
                            case CENTRE: {
                                spin = side;
                                break;
                            }
                            case TOP: {
                                if (side.func_176740_k().func_176720_b()) {
                                    spin = EnumFacing.NORTH;
                                    break;
                                }
                                spin = EnumFacing.UP;
                                break;
                            }
                            case BOTTOM: {
                                if (side.func_176740_k().func_176720_b()) {
                                    spin = EnumFacing.SOUTH;
                                    break;
                                }
                                spin = EnumFacing.DOWN;
                                break;
                            }
                            case LEFT: {
                                if (side.func_176740_k().func_176720_b()) {
                                    spin = EnumFacing.WEST;
                                    break;
                                }
                                spin = side.func_176746_e();
                                break;
                            }
                            case RIGHT: {
                                if (side.func_176740_k().func_176720_b()) {
                                    spin = EnumFacing.EAST;
                                    break;
                                }
                                spin = side.func_176735_f();
                                break;
                            }
                            case TOP_LEFT: 
                            case TOP_RIGHT: 
                            case BOTTOM_LEFT: 
                            case BOTTOM_RIGHT: {
                                spin = side.func_176734_d();
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected segment: " + (Object)((Object)segment));
                            }
                        }
                        if (block.canSetFacing(world, blockPos, spin, event.getPlayer())) {
                            int green;
                            int red;
                            int blue;
                            if (hoveredSpin == spin) {
                                blue = 0;
                                red = 0;
                                green = 255;
                            } else {
                                green = 0;
                                red = 0;
                                blue = 255;
                            }
                            EnhancedOverlay.forFace(side).drawArea(segment, Tessellator.func_178181_a().func_178180_c(), red, green, blue);
                            if (hoveredSpin != spin) continue;
                            if (side.func_176734_d() == spin) {
                                EnumFacing[] edges = null;
                                EnumFacing[] sides = null;
                                switch (side.func_176740_k()) {
                                    case X: {
                                        edges = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
                                        break;
                                    }
                                    case Y: {
                                        sides = EnumFacing.Plane.HORIZONTAL.func_179516_a();
                                        break;
                                    }
                                    case Z: {
                                        sides = EnumFacing.Plane.VERTICAL.func_179516_a();
                                        edges = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
                                    }
                                }
                                if (edges != null) {
                                    for (EnumFacing face : edges) {
                                        additionalRenders.put(face, () -> {
                                            GlStateManager.func_179131_c((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)0.5f);
                                            EnhancedOverlay.drawArea(face, EnhancedOverlay.Segment.TOP_LEFT, EnhancedOverlay.Segment.TOP, EnhancedOverlay.Segment.TOP_RIGHT, EnhancedOverlay.Segment.BOTTOM_LEFT, EnhancedOverlay.Segment.BOTTOM, EnhancedOverlay.Segment.BOTTOM_RIGHT);
                                        });
                                    }
                                }
                                if (sides == null) continue;
                                for (EnumFacing face : sides) {
                                    additionalRenders.put(face, () -> {
                                        GlStateManager.func_179131_c((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)0.5f);
                                        EnhancedOverlay.drawArea(face, EnhancedOverlay.Segment.TOP_LEFT, EnhancedOverlay.Segment.LEFT, EnhancedOverlay.Segment.BOTTOM_LEFT, EnhancedOverlay.Segment.TOP_RIGHT, EnhancedOverlay.Segment.RIGHT, EnhancedOverlay.Segment.BOTTOM_RIGHT);
                                    });
                                }
                                continue;
                            }
                            if (segment == EnhancedOverlay.Segment.CENTRE) {
                                additionalRenders.put(spin, () -> {
                                    GlStateManager.func_179131_c((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)0.5f);
                                    EnhancedOverlay.drawArea(spin, skippedSegments.toArray(new EnhancedOverlay.Segment[skippedSegments.size()]));
                                });
                                continue;
                            }
                            additionalRenders.put(spin, () -> EnhancedOverlay.forFace(spin).drawSide(Tessellator.func_178181_a().func_178180_c(), red, green, blue));
                            continue;
                        }
                        skippedSegments.add(segment);
                    }
                } else {
                    EnhancedOverlay.forFace(side).drawArea(EnhancedOverlay.Segment.forRayTrace(event.getTarget()), Tessellator.func_178181_a().func_178180_c(), 0, 0, 0);
                }
                Runnable r = (Runnable)additionalRenders.remove(side);
                if (r != null) {
                    r.run();
                }
                GL11.glPopMatrix();
                for (Map.Entry entry : additionalRenders.entrySet()) {
                    GlStateManager.func_179094_E();
                    EnhancedOverlay.transformToFace((Entity)event.getPlayer(), blockPos, (EnumFacing)entry.getKey(), event.getPartialTicks());
                    ((Runnable)entry.getValue()).run();
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        }
    }

    public static ResourceLocation getIdentifier(String name) {
        return new ResourceLocation("ic2", name);
    }

    static {
        try {
            new BlockPos(1, 2, 3).func_177982_a(2, 3, 4);
        }
        catch (Throwable t) {
            throw new Error("IC2 is incompatible with this environment, use the normal IC2 version, not the dev one.", t);
        }
        instance = null;
        network = new SideGateway("ic2.core.network.NetworkManager", "ic2.core.network.NetworkManagerClient");
        random = new Random();
        suddenlyHoes = false;
        seasonal = false;
        initialized = false;
        version = ProfileManager.selected.style;
        tabIC2 = new CreativeTabIC2();
    }
}

