/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IEnhancedOverlayProvider;
import ic2.api.tile.IWrenchable;
import ic2.api.transport.IPipe;
import ic2.core.IC2;
import ic2.core.IHitSoundOverride;
import ic2.core.audio.PositionSpec;
import ic2.core.item.ItemToolIC2;
import ic2.core.item.tool.HarvestLevel;
import ic2.core.item.tool.ToolClass;
import ic2.core.ref.ItemName;
import ic2.core.util.RotationUtil;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolWrenchNew
extends ItemToolIC2
implements IEnhancedOverlayProvider,
IHitSoundOverride {
    public ItemToolWrenchNew() {
        super(ItemName.wrench_new, HarvestLevel.Iron, Collections.singleton(ToolClass.Wrench));
        this.func_77656_e(120);
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = StackUtil.get(player, hand);
        if (!this.canTakeDamage(stack, 1)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = Util.getBlockState((IBlockAccess)world, pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_175625_s(pos) instanceof IPipe) {
            IPipe target = (IPipe)world.func_175625_s(pos);
            EnumFacing newFacing = RotationUtil.rotateByHit(side, hitX, hitY, hitZ);
            target.flipConnection(newFacing);
            return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
        }
        if (block instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)block;
            EnumFacing newFacing = RotationUtil.rotateByHit(side, hitX, hitY, hitZ);
            wrenchable.setFacing(world, pos, newFacing, player);
            if (world.field_72995_K) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair != null && Util.matchesOD(repair, "ingotBronze");
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> info, ITooltipFlag flagIn) {
        info.add(Minecraft.func_71410_x().field_71474_y.field_74312_F.getDisplayName() + ":");
        info.add(" Safely mine IC2 machines (Yes you will get the machine and not the machine block)");
        info.add("");
        info.add(Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName() + ":");
        info.add(" Set the machine facing (rotate)");
    }

    @Override
    public boolean providesEnhancedOverlay(World world, BlockPos pos, ItemStack stack) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof IWrenchable;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHitSoundForBlock(EntityPlayerSP player, World world, BlockPos pos, ItemStack stack) {
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getBreakSoundForBlock(EntityPlayerSP player, World world, BlockPos pos, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IWrenchable) {
            return "Tools/wrench.ogg";
        }
        return null;
    }
}

