/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.items;

import ic2.core.block.state.IIdProvider;
import java.util.HashMap;
import java.util.Map;

public enum PipeSize implements IIdProvider
{
    tiny(1, 0.25f),
    small(4, 0.375f),
    medium(16, 0.5f),
    large(64, 0.625f);

    public final int maxStackSize;
    public final float thickness;
    public static final PipeSize[] values;
    private static final Map<String, PipeSize> nameMap;

    private PipeSize(int maxStackSize, float thickness) {
        this.maxStackSize = maxStackSize;
        this.thickness = thickness;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    public static PipeSize get(String name) {
        return nameMap.get(name);
    }

    static {
        values = PipeSize.values();
        nameMap = new HashMap<String, PipeSize>();
        for (PipeSize type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

