/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import ic2.api.transport.IFluidPipe;
import ic2.core.IC2;
import ic2.core.block.transport.TileEntityPipe;
import ic2.core.block.transport.cover.CoverProperty;
import ic2.core.block.transport.cover.ICoverItem;
import ic2.core.block.transport.items.PipeSize;
import ic2.core.block.transport.items.PipeType;
import ic2.core.item.block.ItemPipe;
import ic2.core.util.LiquidUtil;
import ic2.core.util.Util;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFluidPipe
extends TileEntityPipe
implements IFluidPipe {
    protected PipeType type = PipeType.bronze;
    protected PipeSize size = PipeSize.small;
    protected byte tracker = 0;
    protected byte oldTracker = 0;
    protected PipeFluidTank tank;

    public TileEntityFluidPipe() {
    }

    public TileEntityFluidPipe(PipeType type, PipeSize size) {
        this();
        this.tickRate = 5;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
        this.type = type;
        this.size = size;
        this.tank = new PipeFluidTank(Util.allFacings, Util.allFacings, (Predicate<Fluid>)Predicates.alwaysTrue(), (int)(size.thickness * 2.0f * 1000.0f));
    }

    @Override
    public Set<CoverProperty> getCoverProperties() {
        return EnumSet.of(CoverProperty.FluidConsuming);
    }

    @Override
    public int getTransferRate() {
        return this.type.transferRate;
    }

    @Override
    public int getCurrentInnerCapacity() {
        return this.tank.getFluidAmount();
    }

    @Override
    public int getMaxInnerCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public void flipConnection(EnumFacing facing) {
        TileEntity tile;
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        if (!world.field_72995_K && (tile = world.func_175625_s(pos.func_177972_a(facing))) != null && (LiquidUtil.isFluidTile(tile, facing.func_176734_d()) || tile instanceof IFluidPipe)) {
            this.connectivity = (byte)(this.connectivity ^ 1 << facing.ordinal());
            IC2.network.get(true).updateTileEntityField(this, "connectivity");
            world.func_175685_c(pos, this.field_145854_h, true);
            this.func_70296_d();
        }
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.updateTicker++ % this.tickRate != 0) {
            return;
        }
        boolean needsUpdate = false;
        if (this.tracker == 63) {
            this.tracker = 0;
        }
        if (this.tracker == this.oldTracker) {
            if (this.tank.getFluid() != null) {
                FluidStack fStack = this.tank.getFluid().copy();
                int outputs = 0;
                for (EnumFacing facing : EnumFacing.values()) {
                    if ((this.tracker & 1 << facing.ordinal()) != 0 || !this.isConnected(facing)) continue;
                    ++outputs;
                }
                int maxTransfer = Math.min(fStack.amount, this.type.transferRate / 4);
                int maxAmountPerOutput = (int)Math.floor((float)maxTransfer / (float)outputs);
                for (EnumFacing facing : EnumFacing.values()) {
                    LiquidUtil.AdjacentFluidHandler target;
                    if (!this.isConnected(facing) || (this.tracker & 1 << facing.ordinal()) != 0 || (target = LiquidUtil.getAdjacentHandler(this, facing)) == null) continue;
                    LiquidUtil.transfer(this, facing, target.handler, maxAmountPerOutput);
                }
                needsUpdate = true;
            }
            this.tracker = 0;
        }
        this.oldTracker = this.tracker;
        if (needsUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = PipeType.values[nbt.func_74771_c("type") & 0xFF];
        this.size = PipeSize.values()[nbt.func_74771_c("size") & 0xFF];
        this.tracker = nbt.func_74771_c("tracker");
        this.oldTracker = nbt.func_74771_c("oldTracker");
        this.tickRate = 5;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
        this.tank = new PipeFluidTank(Util.allFacings, Util.allFacings, (Predicate<Fluid>)Predicates.alwaysTrue(), (int)(this.size.thickness * 2.0f * 1000.0f));
        System.out.println(this.tank.getFluidAmount());
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)this.type.ordinal());
        nbt.func_74774_a("size", (byte)this.size.ordinal());
        nbt.func_74774_a("tracker", this.tracker);
        nbt.func_74774_a("oldTracker", this.oldTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    protected ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return ItemPipe.getPipe(this.type, this.size);
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> ret = super.getNetworkedFields();
        ret.add("type");
        ret.add("size");
        return ret;
    }

    @Override
    protected void updateRenderState() {
        this.renderState = new TileEntityPipe.PipeRenderState(this.type, this.size, this.connectivity, this.covers, this.getFacing().ordinal());
    }

    @Override
    protected void updateConnectivity() {
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        int mask = 1;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tile = world.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tile != null && tile instanceof IFluidPipe && ((IFluidPipe)tile).isConnected(direction.func_176734_d())) {
                newConnectivity = (byte)(newConnectivity | mask);
            }
            mask *= 2;
        }
        if (this.connectivity != newConnectivity) {
            this.connectivity = newConnectivity;
            IC2.network.get(true).updateTileEntityField(this, "connectivity");
        }
    }

    @Override
    protected void onBlockBreak() {
        super.onBlockBreak();
        if (this.tank.getFluidAmount() > 1000 && LiquidUtil.fillBlock(this.tank.getFluid(), this.func_145831_w(), this.func_174877_v(), true)) {
            LiquidUtil.fillBlock(this.tank.getFluid(), this.func_145831_w(), this.func_174877_v(), false);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.isConnected(facing);
        }
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.isConnected(facing)) {
                return (T)new PipeFluidHandler(facing);
            }
            return null;
        }
        return null;
    }

    private class PipeFluidTank
    extends FluidTank {
        private final Predicate<Fluid> acceptedFluids;
        private Collection<EnumFacing> inputSides;
        private Collection<EnumFacing> outputSides;

        protected PipeFluidTank(Collection<EnumFacing> inputSides, Collection<EnumFacing> outputSides, Predicate<Fluid> acceptedFluids, int capacity) {
            super(capacity);
            this.acceptedFluids = acceptedFluids;
            this.inputSides = inputSides;
            this.outputSides = outputSides;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && this.acceptsFluid(fluid.getFluid());
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return fluid != null && this.acceptsFluid(fluid.getFluid());
        }

        public boolean acceptsFluid(Fluid fluid) {
            return this.acceptedFluids.apply((Object)fluid);
        }

        IFluidTankProperties getTankProperties(final EnumFacing side) {
            assert (side == null || this.inputSides.contains(side) || this.outputSides.contains(side));
            return new IFluidTankProperties(){

                public FluidStack getContents() {
                    return PipeFluidTank.this.getFluid();
                }

                public int getCapacity() {
                    return PipeFluidTank.this.capacity;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    if (fluidStack == null || fluidStack.amount <= 0) {
                        return false;
                    }
                    return PipeFluidTank.this.acceptsFluid(fluidStack.getFluid()) && (side == null || PipeFluidTank.this.canFill(side));
                }

                public boolean canFill() {
                    return PipeFluidTank.this.canFill(side);
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    if (fluidStack == null || fluidStack.amount <= 0) {
                        return false;
                    }
                    return PipeFluidTank.this.acceptsFluid(fluidStack.getFluid()) && (side == null || PipeFluidTank.this.canDrain(side));
                }

                public boolean canDrain() {
                    return PipeFluidTank.this.canDrain(side);
                }
            };
        }

        public boolean canFill(EnumFacing side) {
            return this.inputSides.contains(side);
        }

        public boolean canDrain(EnumFacing side) {
            return this.outputSides.contains(side);
        }
    }

    private class PipeFluidHandler
    implements IFluidHandler {
        private final EnumFacing side;

        public PipeFluidHandler(EnumFacing side) {
            this.side = side;
        }

        public IFluidTankProperties[] getTankProperties() {
            return TileEntityFluidPipe.this.tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            ICoverItem cover;
            if (TileEntityFluidPipe.this.coversComponent.hasCover(this.side) && !(cover = TileEntityFluidPipe.this.coversComponent.getCoverItem(this.side)).allowsInput(resource)) {
                return 0;
            }
            int ret = TileEntityFluidPipe.this.tank.fill(resource, doFill);
            if (ret > 0) {
                TileEntityFluidPipe.this.tracker = (byte)(TileEntityFluidPipe.this.tracker | 1 << this.side.ordinal());
            }
            return ret;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            ICoverItem cover;
            if (TileEntityFluidPipe.this.coversComponent.hasCover(this.side) && !(cover = TileEntityFluidPipe.this.coversComponent.getCoverItem(this.side)).allowsOutput(resource)) {
                return null;
            }
            return TileEntityFluidPipe.this.tank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            ICoverItem cover;
            if (TileEntityFluidPipe.this.coversComponent.hasCover(this.side) && !(cover = TileEntityFluidPipe.this.coversComponent.getCoverItem(this.side)).allowsOutput(new FluidStack(TileEntityFluidPipe.this.tank.getFluid(), maxDrain))) {
                return null;
            }
            return TileEntityFluidPipe.this.tank.drain(maxDrain, doDrain);
        }
    }
}

