/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.steam;

import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.Recipes;
import ic2.core.block.steam.IKineticProvider;
import ic2.core.block.steam.TileEntityKineticMachine;
import ic2.core.item.type.OreResourceType;
import ic2.core.recipe.dynamic.DynamicRecipeManager;
import ic2.core.recipe.dynamic.RecipeInputIngredient;
import ic2.core.recipe.dynamic.RecipeInputItemStack;
import ic2.core.recipe.dynamic.RecipeOutputIngredient;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCrusher
extends TileEntityKineticMachine {
    protected ItemStack currentlyProcessing;

    public TileEntityCrusher() {
        super(2, 4);
    }

    public static void init() {
        Recipes.crusher = new DynamicRecipeManager();
        Recipes.crusher.createRecipe().withInput("oreIron").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.iron.getId())).register();
        Recipes.crusher.createRecipe().withInput("oreCopper").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.copper.getId())).register();
        Recipes.crusher.createRecipe().withInput("oreTin").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.tin.getId())).register();
        Recipes.crusher.createRecipe().withInput("oreGold").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.gold.getId())).register();
        Recipes.crusher.createRecipe().withInput("oreSilver").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.silver.getId())).register();
        Recipes.crusher.createRecipe().withInput("oreLead").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.lead.getId())).register();
        Recipes.crusher.createRecipe().withInput("oreUranium").withOutput(new ItemStack(ItemName.crushed.getInstance(), 2, OreResourceType.uranium.getId())).register();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        World world = this.func_145831_w();
        if (this.getActive() && world.field_73012_v.nextInt(8) == 0) {
            for (int i = 0; i < 4; ++i) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)world.field_73012_v.nextFloat() * 0.6 - 0.3;
                double y = (double)(this.field_174879_c.func_177956_o() + 1) + (double)world.field_73012_v.nextFloat() * 0.2 - 0.1;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)world.field_73012_v.nextFloat() * 0.6 - 0.3;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    protected boolean canOperate() {
        return this.hasValidInput();
    }

    @Override
    protected boolean hasValidInput() {
        return !StackUtil.isEmpty(this.currentlyProcessing);
    }

    @Override
    protected boolean searchForValidInput() {
        TileEntity feeder = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP));
        if (!StackUtil.isInventoryTile(feeder, EnumFacing.DOWN)) {
            return false;
        }
        IInventory inventory = (IInventory)feeder;
        if (inventory.func_70302_i_() <= 0) {
            return false;
        }
        for (int index = 0; index < inventory.func_70302_i_(); ++index) {
            MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result;
            ItemStack candidate = inventory.func_70301_a(index);
            if (StackUtil.isEmpty(candidate) || (result = Recipes.crusher.apply((Collection<RecipeInputIngredient>)Collections.singleton(RecipeInputItemStack.of(candidate)), false)) == null) continue;
            ItemStack adjustedInput = (ItemStack)new ArrayList<RecipeInputIngredient>(result.getAdjustedInput()).get((int)0).ingredient;
            inventory.func_70299_a(index, adjustedInput);
            this.currentlyProcessing = StackUtil.copy(adjustedInput);
            return true;
        }
        return false;
    }

    @Override
    protected int getAvailablePower() {
        int power = 0;
        TileEntity kineticProvider = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing().func_176734_d()));
        if (kineticProvider instanceof IKineticProvider) {
            power = ((IKineticProvider)kineticProvider).getProvidedPower(this.getFacing());
        }
        return power;
    }

    @Override
    protected boolean operateOnce() {
        TileEntity collector = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.DOWN));
        if (!StackUtil.isInventoryTile(collector, EnumFacing.UP)) {
            return false;
        }
        MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result = Recipes.crusher.apply((Collection<RecipeInputIngredient>)Collections.singleton(RecipeInputItemStack.of(this.currentlyProcessing)), false);
        if (result == null) {
            return false;
        }
        return false;
    }

    @Override
    protected void clearInput() {
        this.currentlyProcessing = null;
    }

    @Override
    public double getGuiValue(String name) {
        if (!name.equals("progress")) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " Cannot get value for " + name);
        }
        return 0.0;
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/MaceratorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

