/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.transport;

import ic2.core.block.transport.cover.CoverProperty;
import ic2.core.block.transport.cover.CoverRegistry;
import ic2.core.block.transport.cover.ICoverHolder;
import ic2.core.block.transport.cover.IFluidConsumingCover;
import ic2.core.item.ItemMulti;
import ic2.core.item.transport.CoverType;
import ic2.core.ref.ItemName;
import ic2.core.util.LiquidUtil;
import ic2.core.util.RotationUtil;
import ic2.core.util.StackUtil;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCover
extends ItemMulti<CoverType>
implements IFluidConsumingCover {
    public ItemCover() {
        super(ItemName.cover, CoverType.class);
        this.func_77627_a(true);
        for (CoverType type : CoverType.values()) {
            CoverRegistry.register(new ItemStack((Item)this, 1, type.getId()));
        }
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        ItemStack stack = StackUtil.get(player, hand);
        CoverType type = (CoverType)this.getType(stack);
        if (type == null) {
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof ICoverHolder)) {
                return EnumActionResult.PASS;
            }
            EnumFacing facingHit = RotationUtil.rotateByHit(side, xOffset, yOffset, zOffset);
            switch (type) {
                case fluid_pulling: {
                    if (((ICoverHolder)tileEntity).canPlaceCover(world, pos, facingHit, stack)) {
                        ((ICoverHolder)tileEntity).placeCover(world, pos, facingHit, StackUtil.copyWithSize(stack, 1));
                        stack.func_190918_g(1);
                        return EnumActionResult.SUCCESS;
                    }
                    return EnumActionResult.FAIL;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean isSuitableFor(ItemStack stack, Set<CoverProperty> types) {
        CoverType type = (CoverType)this.getType(stack);
        if (type == null) {
            return false;
        }
        switch (type) {
            case fluid_pulling: {
                return types.contains((Object)CoverProperty.FluidConsuming);
            }
        }
        return false;
    }

    @Override
    public boolean onTick(ItemStack stack, ICoverHolder parent, EnumFacing side) {
        CoverType type = (CoverType)this.getType(stack);
        if (type == null) {
            return false;
        }
        boolean ret = false;
        TileEntity holder = (TileEntity)parent;
        switch (type) {
            case fluid_pulling: {
                LiquidUtil.AdjacentFluidHandler target = LiquidUtil.getAdjacentHandler(holder, side);
                if (target == null) break;
                int amount = (int)(50.0 * Math.pow(4.0, 1.0));
                LiquidUtil.transfer(target.handler, target.dir.func_176734_d(), holder, amount);
                break;
            }
            default: {
                return false;
            }
        }
        return ret;
    }
}

