/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.items;

import ic2.core.block.state.IIdProvider;
import ic2.core.block.transport.items.PipeSize;
import java.util.HashMap;
import java.util.Map;

public enum PipeType implements IIdProvider
{
    bronze(500, 255, 128, 0),
    steel(2000, 128, 128, 128);

    public final int transferRate;
    public final int red;
    public final int green;
    public final int blue;
    public static final PipeType[] values;
    private static final Map<String, PipeType> nameMap;

    private PipeType(int transferRate, int red, int green, int blue) {
        this.transferRate = transferRate;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public String getName(PipeSize size) {
        StringBuilder ret = new StringBuilder(this.getName());
        ret.append("_pipe");
        if (size != null) {
            ret.append('_');
            ret.append(size.name());
        }
        return ret.toString();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    public static PipeType get(String name) {
        return nameMap.get(name);
    }

    static {
        values = PipeType.values();
        nameMap = new HashMap<String, PipeType>();
        for (PipeType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

