/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport;

import ic2.api.transport.IPipe;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.block.state.UnlistedProperty;
import ic2.core.block.transport.items.PipeSize;
import ic2.core.block.transport.items.PipeType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class TileEntityPipe
extends TileEntityBlock
implements IPipe {
    public static final IUnlistedProperty<PipeRenderState> renderStateProperty = new UnlistedProperty<PipeRenderState>("renderstate", PipeRenderState.class);
    protected volatile PipeRenderState renderState;
    protected byte connectivity = 0;
    protected byte[] covers = new byte[6];
    protected int updateTicker;
    protected int tickRate;

    @Override
    public boolean isConnected(EnumFacing facing) {
        return (this.connectivity & 1 << facing.ordinal()) != 0;
    }

    @Override
    public abstract void flipConnection(EnumFacing var1);

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            this.updateRenderState();
        } else {
            this.updateConnectivity();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.connectivity = nbt.func_74771_c("connectivity");
        for (EnumFacing facing : EnumFacing.values()) {
            int ordinal = facing.ordinal();
            this.covers[ordinal] = nbt.func_74771_c("cover_" + ordinal);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("connectivity", this.connectivity);
        for (EnumFacing facing : EnumFacing.values()) {
            int ordinal = facing.ordinal();
            nbt.func_74774_a("cover_" + ordinal, this.covers[ordinal]);
        }
        return nbt;
    }

    @Override
    protected void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        if (this.func_145831_w().field_72995_K) {
            this.updateRenderState();
        } else {
            this.updateConnectivity();
        }
        super.onPlaced(stack, placer, facing);
    }

    protected abstract void updateConnectivity();

    @Override
    public Ic2BlockState.Ic2BlockStateInstance getExtendedState(Ic2BlockState.Ic2BlockStateInstance state) {
        state = super.getExtendedState(state);
        PipeRenderState pipeRenderState = this.renderState;
        if (pipeRenderState != null) {
            state = state.withProperties(renderStateProperty, pipeRenderState);
        }
        return state;
    }

    @Override
    protected SoundType getBlockSound(Entity entity) {
        return SoundType.field_185852_e;
    }

    @Override
    protected boolean isNormalCube() {
        return false;
    }

    @Override
    protected boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    protected boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    protected int getLightOpacity() {
        return 0;
    }

    @Override
    protected boolean clientNeedsExtraModelInfo() {
        return true;
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.updateRenderState();
        this.rerender();
        super.onNetworkUpdate(field);
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> ret = super.getNetworkedFields();
        ret.add("connectivity");
        return ret;
    }

    protected abstract void updateRenderState();

    public static class PipeRenderState {
        public final PipeType type;
        public final PipeSize size;
        public final int connectivity;
        public final int facing;

        public PipeRenderState(PipeType type, PipeSize size, int connectivity, int facing) {
            this.type = type;
            this.size = size;
            this.connectivity = connectivity;
            this.facing = facing;
        }

        public int hashCode() {
            int ret = this.type.hashCode();
            ret = ret * 31 + this.size.hashCode();
            ret = ret * 31 + this.connectivity;
            ret = ret * 31 + this.facing;
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PipeRenderState)) {
                return false;
            }
            PipeRenderState o = (PipeRenderState)obj;
            return o.type == this.type && o.size == this.size && o.connectivity == this.connectivity && o.facing == this.facing;
        }

        public String toString() {
            return "PipeState<" + this.type + ", " + this.size + ", " + this.connectivity + ", " + this.facing + '>';
        }
    }
}

