/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.steam;

import com.google.common.collect.Lists;
import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Fluids;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.steam.TileEntityBurningBox;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import ic2.core.recipe.dynamic.DynamicRecipeManager;
import ic2.core.recipe.dynamic.RecipeInputIngredient;
import ic2.core.recipe.dynamic.RecipeInputItemStack;
import ic2.core.recipe.dynamic.RecipeOutputFluidStack;
import ic2.core.recipe.dynamic.RecipeOutputIngredient;
import ic2.core.ref.FluidName;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCrucible
extends TileEntityInventory
implements IHasGui,
IGuiValueProvider {
    protected int tickRate = 20;
    protected int updateTicker = IC2.random.nextInt(this.tickRate);
    protected int progress = 0;
    protected int operationLength = 100;
    @GuiSynced
    protected float guiProgress;
    protected final InvSlot inputSlot = new InvSlot(this, "input", InvSlot.Access.I, 1, InvSlot.InvSide.ANY);
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    @GuiSynced
    protected final Fluids.InternalFluidTank fluidTank = this.fluids.addTank("fluidTank", 16000, InvSlot.Access.O, InvSlot.InvSide.SIDE);

    public static void init() {
        Recipes.crucible = new DynamicRecipeManager();
        Recipes.crucible.createRecipe().withInput("ingotIron").withOutput(new FluidStack(FluidName.molten_iron.getInstance(), 144)).withMetadata("meltingPoint", 1811).register();
        Recipes.crucible.createRecipe().withInput("ingotSteel").withOutput(new FluidStack(FluidName.molten_steel.getInstance(), 144)).withMetadata("meltingPoint", 1811).register();
        Recipes.crucible.createRecipe().withInput("ingotCopper").withOutput(new FluidStack(FluidName.molten_copper.getInstance(), 144)).withMetadata("meltingPoint", 1358).register();
        Recipes.crucible.createRecipe().withInput("ingotTin").withOutput(new FluidStack(FluidName.molten_tin.getInstance(), 144)).withMetadata("meltingPoint", 505).register();
        Recipes.crucible.createRecipe().withInput("ingotLead").withOutput(new FluidStack(FluidName.molten_lead.getInstance(), 144)).withMetadata("meltingPoint", 601).register();
        Recipes.crucible.createRecipe().withInput("ingotGold").withOutput(new FluidStack(FluidName.molten_gold.getInstance(), 144)).withMetadata("meltingPoint", 1337).register();
        Recipes.crucible.createRecipe().withInput("ingotBronze").withOutput(new FluidStack(FluidName.molten_bronze.getInstance(), 144)).withMetadata("meltingPoint", 1223).register();
        Recipes.alloying = new DynamicRecipeManager();
        Recipes.alloying.createRecipe().withInput(new FluidStack(FluidName.molten_copper.getInstance(), 48)).withInput(new FluidStack(FluidName.molten_tin.getInstance(), 16)).withOutput(new FluidStack(FluidName.molten_bronze.getInstance(), 64)).register();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.updateTicker++ % this.tickRate != 0) {
            return;
        }
        boolean needsInventoryUpdate = false;
        MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> output = this.getOutput();
        if (output != null) {
            this.setActive(true);
            this.progress += 20;
            if (this.progress >= this.operationLength) {
                this.operate(output);
                needsInventoryUpdate = true;
                this.progress = 0;
            }
        } else {
            if (output == null) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        this.guiProgress = this.progress == 0 || this.operationLength == 0 ? 0.0f : (float)this.progress / (float)this.operationLength;
        if (needsInventoryUpdate) {
            super.func_70296_d();
        }
    }

    protected void operate(MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result) {
        Collection<RecipeOutputIngredient> processResult = this.getOutput(result.getOutput());
        this.operateOnce(result, processResult);
        result = this.getOutput();
    }

    protected Collection<RecipeOutputIngredient> getOutput(Collection<RecipeOutputIngredient> output) {
        ArrayList<RecipeOutputIngredient> ret = new ArrayList<RecipeOutputIngredient>(output.size());
        for (RecipeOutputIngredient entry : output) {
            ret.add(entry.copy());
        }
        return ret;
    }

    protected void operateOnce(MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result, Collection<RecipeOutputIngredient> processResult) {
        for (RecipeInputIngredient recipeInputIngredient : result.getAdjustedInput()) {
            if (!(recipeInputIngredient instanceof RecipeInputItemStack)) continue;
            this.inputSlot.put((ItemStack)recipeInputIngredient.ingredient);
        }
        for (RecipeOutputIngredient recipeOutputIngredient : result.getOutput()) {
            if (!(recipeOutputIngredient instanceof RecipeOutputFluidStack)) continue;
            this.fluidTank.fillInternal((FluidStack)recipeOutputIngredient.ingredient, true);
        }
    }

    protected MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> getOutput() {
        int requiredTemp;
        if (this.inputSlot.isEmpty()) {
            return null;
        }
        MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result = Recipes.crucible.apply(Lists.newArrayList((Object[])new RecipeInputIngredient[]{RecipeInputItemStack.of(this.inputSlot.get())}), false);
        if (result == null) {
            return null;
        }
        int providedTemp = 0;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.DOWN));
        if (tileEntity instanceof TileEntityBurningBox) {
            providedTemp = ((TileEntityBurningBox)tileEntity).getProvidedHeat(EnumFacing.UP);
        }
        if (providedTemp < (requiredTemp = result.getRecipe().getMetaData().func_74762_e("meltingPoint"))) {
            return null;
        }
        for (RecipeOutputIngredient entry : result.getOutput()) {
            if (!(entry instanceof RecipeOutputFluidStack) || this.fluidTank.fillInternal((FluidStack)entry.ingredient, false) >= ((FluidStack)entry.ingredient).amount) continue;
            return null;
        }
        return result;
    }

    public ContainerBase<TileEntityCrucible> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public double getGuiValue(String name) {
        if (name.equals("progress")) {
            return this.guiProgress;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Cannot get value for " + name);
    }
}

