/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.steam;

import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.steam.IMultiBlockController;
import ic2.core.block.steam.TileEntityCokeKilnGrate;
import ic2.core.block.steam.TileEntityCokeKilnHatch;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import ic2.core.recipe.dynamic.DynamicRecipeManager;
import ic2.core.recipe.dynamic.RecipeInputIngredient;
import ic2.core.recipe.dynamic.RecipeInputItemStack;
import ic2.core.recipe.dynamic.RecipeOutputIngredient;
import ic2.core.ref.BlockName;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.util.ParticleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCokeKiln
extends TileEntityInventory
implements IMultiBlockController,
IHasGui,
IGuiValueProvider {
    protected int tickRate = 20;
    protected int updateTicker = IC2.random.nextInt(this.tickRate);
    protected boolean isFormed = false;
    protected final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, InvSlot.InvSide.ANY);
    protected int progress = 0;
    protected int operationLength = 0;
    @GuiSynced
    protected float guiProgress;

    public static void init() {
        Recipes.cokeKilnRecipeManager = new DynamicRecipeManager();
        Recipes.cokeKilnRecipeManager.createRecipe().withInput("logWood").withOutput(new ItemStack(Items.field_151044_h, 1, 1)).withOutput(new FluidStack(FluidName.creosote.getInstance(), 250)).withMetadata("operationLength", 1800).register();
        Recipes.cokeKilnRecipeManager.createRecipe().withInput(new ItemStack(Items.field_151044_h, 1, 0)).withOutput(new ItemStack(ItemName.coke.getInstance(), 1)).withOutput(new FluidStack(FluidName.creosote.getInstance(), 500)).withMetadata("operationLength", 1800).register();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.updateTicker++ % this.tickRate != 0) {
            return;
        }
        this.isFormed = this.hasValidStructure();
        if (!this.isFormed) {
            this.progress = 0;
            this.guiProgress = 0.0f;
            this.setActive(false);
            return;
        }
        boolean needsInventoryUpdate = false;
        MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> output = this.getOutput();
        if (output != null) {
            this.setActive(true);
            this.operationLength = output.getRecipe().getMetaData().func_74762_e("operationLength");
            this.progress += 20;
            if (this.progress >= this.operationLength) {
                this.operate(output);
                needsInventoryUpdate = true;
                this.progress = 0;
            }
        } else {
            if (output == null) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        this.guiProgress = this.progress == 0 || this.operationLength == 0 ? 0.0f : (float)this.progress / (float)this.operationLength;
        if (needsInventoryUpdate) {
            super.func_70296_d();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            World world = this.func_145831_w();
            ParticleUtil.showFlames(world, this.field_174879_c, this.getFacing());
            if (world.field_73012_v.nextDouble() < 0.1) {
                world.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    @Override
    public boolean hasValidStructure() {
        IBlockState state;
        TileEntity tileEntity;
        int z;
        int x;
        int range = 2;
        ChunkCache cache = new ChunkCache(this.func_145831_w(), this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2), 0);
        BlockPos.MutableBlockPos cPos = new BlockPos.MutableBlockPos();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                cPos.func_181079_c(this.field_174879_c.func_177958_n() + (x - this.getFacing().func_82601_c()), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + (z - this.getFacing().func_82599_e()));
                if (x == 0 && z == 0) {
                    tileEntity = cache.func_175625_s((BlockPos)cPos);
                    if (tileEntity == null) {
                        return false;
                    }
                    if (tileEntity instanceof TileEntityCokeKilnGrate) continue;
                    return false;
                }
                state = cache.func_180495_p((BlockPos)cPos);
                if (state.func_177230_c() == BlockName.refractory_bricks.getInstance()) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                cPos.func_181079_c(this.field_174879_c.func_177958_n() + (x - this.getFacing().func_82601_c()), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + (z - this.getFacing().func_82599_e()));
                if (x == 0 && z == 0) {
                    state = cache.func_180495_p((BlockPos)cPos);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    return false;
                }
                if (this.field_174879_c.func_177958_n() == cPos.func_177958_n() && this.field_174879_c.func_177952_p() == cPos.func_177952_p()) {
                    tileEntity = cache.func_175625_s((BlockPos)cPos);
                    if (tileEntity == null) {
                        return false;
                    }
                    if (tileEntity == this) continue;
                    return false;
                }
                state = cache.func_180495_p((BlockPos)cPos);
                if (state.func_177230_c() == BlockName.refractory_bricks.getInstance()) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                cPos.func_181079_c(this.field_174879_c.func_177958_n() + (x - this.getFacing().func_82601_c()), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + (z - this.getFacing().func_82599_e()));
                if (x == 0 && z == 0) {
                    tileEntity = cache.func_175625_s((BlockPos)cPos);
                    if (tileEntity == null) {
                        return false;
                    }
                    if (tileEntity instanceof TileEntityCokeKilnHatch) continue;
                    return false;
                }
                state = cache.func_180495_p((BlockPos)cPos);
                if (state.func_177230_c() == BlockName.refractory_bricks.getInstance()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFormed() {
        return this.isFormed;
    }

    private void operate(MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result) {
        Collection<RecipeOutputIngredient> processResult = this.getOutput(result.getOutput());
        this.operateOnce(result, processResult);
        result = this.getOutput();
    }

    protected Collection<RecipeOutputIngredient> getOutput(Collection<RecipeOutputIngredient> output) {
        ArrayList<RecipeOutputIngredient> ret = new ArrayList<RecipeOutputIngredient>(output.size());
        for (RecipeOutputIngredient entry : output) {
            ret.add(entry.copy());
        }
        return ret;
    }

    protected void operateOnce(MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result, Collection<RecipeOutputIngredient> processResult) {
        for (RecipeInputIngredient recipeInputIngredient : result.getAdjustedInput()) {
            if (!(recipeInputIngredient.ingredient instanceof ItemStack)) continue;
            BlockPos hatchPos = new BlockPos(this.field_174879_c.func_177958_n() + -this.getFacing().func_82601_c(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + -this.getFacing().func_82599_e());
            TileEntity hatch = this.field_145850_b.func_175625_s(hatchPos);
            if (!(hatch instanceof TileEntityCokeKilnHatch)) {
                return;
            }
            ((TileEntityCokeKilnHatch)hatch).inventory.put((ItemStack)recipeInputIngredient.ingredient);
        }
        for (RecipeOutputIngredient recipeOutputIngredient : result.getOutput()) {
            if (recipeOutputIngredient.ingredient instanceof ItemStack) {
                this.outputSlot.add((ItemStack)recipeOutputIngredient.ingredient);
                continue;
            }
            if (!(recipeOutputIngredient.ingredient instanceof FluidStack)) continue;
            BlockPos gratePos = new BlockPos(this.field_174879_c.func_177958_n() + -this.getFacing().func_82601_c(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + -this.getFacing().func_82599_e());
            TileEntity grate = this.field_145850_b.func_175625_s(gratePos);
            if (!(grate instanceof TileEntityCokeKilnGrate)) {
                return;
            }
            ((TileEntityCokeKilnGrate)grate).fluidTank.fillInternal((FluidStack)recipeOutputIngredient.ingredient, true);
        }
    }

    protected MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> getOutput() {
        BlockPos hatchPos = new BlockPos(this.field_174879_c.func_177958_n() + -this.getFacing().func_82601_c(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + -this.getFacing().func_82599_e());
        TileEntity hatch = this.field_145850_b.func_175625_s(hatchPos);
        if (!(hatch instanceof TileEntityCokeKilnHatch)) {
            return null;
        }
        if (((TileEntityCokeKilnHatch)hatch).inventory.isEmpty()) {
            return null;
        }
        MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> result = Recipes.cokeKilnRecipeManager.apply((Collection<RecipeInputIngredient>)Collections.singleton(RecipeInputItemStack.of(((TileEntityCokeKilnHatch)hatch).inventory.get())), false);
        if (result == null) {
            return null;
        }
        for (RecipeOutputIngredient entry : result.getOutput()) {
            if (entry.ingredient instanceof ItemStack) {
                if (this.outputSlot.canAdd((ItemStack)entry.ingredient)) continue;
                return null;
            }
            if (!(entry.ingredient instanceof FluidStack)) continue;
            BlockPos gratePos = new BlockPos(this.field_174879_c.func_177958_n() + -this.getFacing().func_82601_c(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + -this.getFacing().func_82599_e());
            TileEntity grate = this.field_145850_b.func_175625_s(gratePos);
            if (!(grate instanceof TileEntityCokeKilnGrate)) {
                return null;
            }
            if (((TileEntityCokeKilnGrate)grate).fluidTank.fillInternal((FluidStack)entry.ingredient, false) >= ((FluidStack)entry.ingredient).amount) continue;
            return null;
        }
        return result;
    }

    public ContainerBase<TileEntityCokeKiln> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create(this, player, GuiParser.parse(this.teBlock));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public double getGuiValue(String name) {
        if (name.equals("progress")) {
            return this.guiProgress;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " Cannot get value for " + name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> info, ITooltipFlag advanced) {
        info.add("");
        info.add("MultiBlock Structure:");
        info.add("");
        info.add(" Bottom Layer - 3x3 of Refractory Blocks with a Coke Kiln Grate in the centre");
        info.add("");
        info.add(" Middle Layer - 3x3 of Refractory Blocks with a hollow centre and this block in the middle of one of the sides");
        info.add("");
        info.add(" Top Layer - 3x3 of Refractory Blocks with a Coke Kiln Hatch in the centre");
        info.add("");
    }
}

