/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe.dynamic;

import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.core.IC2;
import ic2.core.init.MainConfig;
import ic2.core.recipe.dynamic.DynamicRecipe;
import ic2.core.recipe.dynamic.IDynamicRecipeManager;
import ic2.core.recipe.dynamic.RecipeIngredient;
import ic2.core.recipe.dynamic.RecipeInputFluidStack;
import ic2.core.recipe.dynamic.RecipeInputIngredient;
import ic2.core.recipe.dynamic.RecipeInputItemStack;
import ic2.core.recipe.dynamic.RecipeOutputIngredient;
import ic2.core.util.LogCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DynamicRecipeManager
implements IDynamicRecipeManager<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> {
    protected final Map<Collection<RecipeInputIngredient>, MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>> recipes = new HashMap<Collection<RecipeInputIngredient>, MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>();
    private final Map<Item, List<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>> recipeCacheItem = new IdentityHashMap<Item, List<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>>();
    private final Map<Fluid, List<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>> recipeCacheFluid = new IdentityHashMap<Fluid, List<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>>();
    private final List<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>> uncacheableRecipes = new ArrayList<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>();

    public DynamicRecipe createRecipe() {
        return new DynamicRecipe(this);
    }

    @Override
    public boolean addRecipe(Collection<RecipeInputIngredient> input, Collection<RecipeOutputIngredient> output, NBTTagCompound metadata, boolean replace) {
        if (input == null) {
            throw new NullPointerException("The recipe input is null");
        }
        if (input.size() <= 0) {
            throw new IllegalArgumentException("No inputs");
        }
        if (output == null) {
            throw new NullPointerException("The recipe output is null");
        }
        if (output.size() <= 0) {
            throw new IllegalArgumentException("No outputs");
        }
        ArrayList<RecipeInputIngredient> listOfInputs = new ArrayList<RecipeInputIngredient>(input.size());
        for (RecipeInputIngredient recipeInputIngredient : input) {
            if (recipeInputIngredient.isEmpty()) {
                this.displayError("The RecipeInputIngredient " + recipeInputIngredient.toStringSafe() + " is invalid.");
                return false;
            }
            listOfInputs.add(recipeInputIngredient);
        }
        ArrayList<RecipeOutputIngredient> listOfOutputs = new ArrayList<RecipeOutputIngredient>(output.size());
        for (RecipeOutputIngredient entry : output) {
            if (entry.isEmpty()) {
                this.displayError("The RecipeOutputIngredient " + entry.toStringSafe() + " is invalid.");
                return false;
            }
            listOfOutputs.add(entry);
        }
        MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> machineRecipe = this.getRecipe(input);
        if (machineRecipe != null) {
            if (replace) {
                MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> machineRecipe2;
                do {
                    this.recipes.remove(input);
                    this.removeCachedRecipes(input);
                } while ((machineRecipe2 = this.getRecipe(input)) != null);
            } else {
                IC2.log.error(LogCategory.Recipe, "Skipping %s => %s due to duplicate recipe for %s (%s => %s)", input, output, input, machineRecipe.getInput(), machineRecipe.getOutput());
                return false;
            }
        }
        MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> newRecipe = new MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>(listOfInputs, output, metadata);
        this.recipes.put(input, newRecipe);
        this.addToCache(newRecipe);
        return true;
    }

    protected MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> getRecipe(Collection<RecipeInputIngredient> input) {
        ArrayList<RecipeInputIngredient> confirmedInputs;
        if (input.isEmpty()) {
            return null;
        }
        ArrayList recipes = new ArrayList();
        for (RecipeInputIngredient recipeInputIngredient : input) {
            Object unspecific = recipeInputIngredient.getUnspecific();
            if (unspecific instanceof Item) {
                if (this.recipeCacheItem.get(unspecific) == null) continue;
                recipes.addAll(this.recipeCacheItem.get(unspecific));
                continue;
            }
            if (!(unspecific instanceof Fluid) || this.recipeCacheFluid.get(unspecific) == null) continue;
            recipes.addAll(this.recipeCacheFluid.get(unspecific));
        }
        if (!recipes.isEmpty()) {
            for (MachineRecipe machineRecipe : recipes) {
                confirmedInputs = new ArrayList<RecipeInputIngredient>();
                for (RecipeInputIngredient entry : input) {
                    for (RecipeInputIngredient temp : (Collection)machineRecipe.getInput()) {
                        if (!temp.matches(entry.ingredient) || entry.getCount() < temp.getCount()) continue;
                        confirmedInputs.add(entry);
                    }
                }
                if (confirmedInputs.size() != ((Collection)machineRecipe.getInput()).size()) continue;
                return machineRecipe;
            }
        }
        for (MachineRecipe machineRecipe : this.uncacheableRecipes) {
            confirmedInputs = new ArrayList();
            for (RecipeInputIngredient entry : input) {
                for (RecipeInputIngredient temp : (Collection)machineRecipe.getInput()) {
                    if (!temp.matches(entry.ingredient) || entry.getCount() < temp.getCount()) continue;
                    confirmedInputs.add(entry);
                }
            }
            if (confirmedInputs.size() != ((Collection)machineRecipe.getInput()).size()) continue;
            return machineRecipe;
        }
        return null;
    }

    @Override
    public MachineRecipeResult<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>, Collection<RecipeInputIngredient>> apply(Collection<RecipeInputIngredient> input, boolean acceptTest) {
        for (RecipeInputIngredient entry : input) {
            if (!entry.isEmpty()) continue;
            return null;
        }
        MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> recipe = this.getRecipe(input);
        if (recipe == null) {
            return null;
        }
        if (input.size() != recipe.getInput().size()) {
            return null;
        }
        ListIterator<RecipeInputIngredient> itB = new ArrayList<RecipeInputIngredient>(recipe.getInput()).listIterator();
        block1: for (RecipeInputIngredient entry : input) {
            while (itB.hasNext()) {
                RecipeInputIngredient temp = itB.next();
                if (!temp.matches(entry.ingredient) || entry.getCount() < temp.getCount()) continue;
                itB.remove();
                while (itB.hasPrevious()) {
                    itB.previous();
                }
                continue block1;
            }
            return null;
        }
        ArrayList adjustedInput = new ArrayList();
        itB = new ArrayList<RecipeInputIngredient>(recipe.getInput()).listIterator();
        block4: for (RecipeInputIngredient entry : input) {
            while (itB.hasNext()) {
                RecipeInputIngredient temp = itB.next();
                if (!temp.matches(entry.ingredient)) continue;
                RecipeInputIngredient adjustedEntry = entry.copy();
                adjustedEntry.shrink(temp.getCount());
                adjustedInput.add(adjustedEntry);
                itB.remove();
                while (itB.hasPrevious()) {
                    itB.previous();
                }
                continue block4;
            }
            return null;
        }
        return recipe.getResult(adjustedInput);
    }

    @Override
    public Iterable<? extends MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>> getRecipes() {
        return () -> new Iterator<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>>(){
            private final Iterator recipeIt;
            private Collection lastInput;
            {
                this.recipeIt = DynamicRecipeManager.this.recipes.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.recipeIt.hasNext();
            }

            @Override
            public MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> next() {
                MachineRecipe next = (MachineRecipe)this.recipeIt.next();
                this.lastInput = (Collection)next.getInput();
                return next;
            }

            @Override
            public void remove() {
                this.recipeIt.remove();
                DynamicRecipeManager.this.removeCachedRecipes(this.lastInput);
            }
        };
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    protected void addToCache(MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> recipe) {
        Collection<Item> items = this.getItemsFromRecipe(recipe.getInput());
        Collection<Fluid> fluids = this.getFluidsFromRecipe(recipe.getInput());
        if (items != null) {
            for (Item item : items) {
                this.addToCache(item, recipe);
            }
        }
        if (fluids != null) {
            for (Fluid fluid : fluids) {
                this.addToCache(fluid, recipe);
            }
        }
        if (items == null && fluids == null) {
            this.uncacheableRecipes.add(recipe);
        }
    }

    private void addToCache(Item item, MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> recipe) {
        List recipes = this.recipeCacheItem.computeIfAbsent(item, newValue -> new ArrayList());
        if (!recipes.contains(recipe)) {
            recipes.add(recipe);
        }
    }

    private void addToCache(Fluid fluid, MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> recipe) {
        List recipes = this.recipeCacheFluid.computeIfAbsent(fluid, newValue -> new ArrayList());
        if (!recipes.contains(recipe)) {
            recipes.add(recipe);
        }
    }

    protected void removeCachedRecipes(Collection<RecipeInputIngredient> input) {
        List<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>> recipes;
        Collection<Item> items = this.getItemsFromRecipe(input);
        Collection<Fluid> fluids = this.getFluidsFromRecipe(input);
        if (items != null) {
            for (Item item : items) {
                recipes = this.recipeCacheItem.get(item);
                if (recipes == null) {
                    IC2.log.warn(LogCategory.Recipe, "Inconsistent recipe cache, the entry for the item " + item + " is missing.");
                    continue;
                }
                this.removeInputFromRecipes(recipes.iterator(), input);
                if (!recipes.isEmpty()) continue;
                this.recipeCacheItem.remove(item);
            }
        }
        if (fluids != null) {
            for (Fluid fluid : fluids) {
                recipes = this.recipeCacheFluid.get(fluid);
                if (recipes == null) {
                    IC2.log.warn(LogCategory.Recipe, "Inconsistent recipe cache, the entry for the fluid " + fluid + " is missing.");
                    continue;
                }
                this.removeInputFromRecipes(recipes.iterator(), input);
                if (!recipes.isEmpty()) continue;
                this.recipeCacheFluid.remove(fluid);
            }
        }
        if (items == null && fluids == null) {
            this.removeInputFromRecipes(this.uncacheableRecipes.iterator(), input);
        }
    }

    private void removeInputFromRecipes(Iterator<MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>>> it, Collection<RecipeInputIngredient> target) {
        assert (target != null);
        while (it.hasNext()) {
            if (!target.equals(it.next().getInput())) continue;
            it.remove();
        }
    }

    private Collection<Item> getItemsFromRecipe(Collection<RecipeInputIngredient> recipe) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (RecipeInputIngredient entry : recipe) {
            if (!(entry instanceof RecipeInputItemStack)) continue;
            inputs.add(((RecipeInputItemStack)entry).ingredient);
        }
        if (inputs.isEmpty()) {
            return null;
        }
        Set<Item> ret = Collections.newSetFromMap(new IdentityHashMap(inputs.size()));
        for (ItemStack itemStack : inputs) {
            ret.add(itemStack.func_77973_b());
        }
        return ret;
    }

    private Collection<Fluid> getFluidsFromRecipe(Collection<RecipeInputIngredient> recipe) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (RecipeInputIngredient entry : recipe) {
            if (!(entry instanceof RecipeInputFluidStack)) continue;
            inputs.add(((RecipeInputFluidStack)entry).ingredient);
        }
        if (inputs.isEmpty()) {
            return null;
        }
        Set<Fluid> ret = Collections.newSetFromMap(new IdentityHashMap(inputs.size()));
        for (FluidStack fluidStack : inputs) {
            ret.add(fluidStack.getFluid());
        }
        return ret;
    }

    @Override
    public boolean removeRecipe(Collection<RecipeInputIngredient> input, Collection<RecipeOutputIngredient> output) {
        MachineRecipe<Collection<RecipeInputIngredient>, Collection<RecipeOutputIngredient>> recipe = this.getRecipe(input);
        if (recipe == null) {
            return false;
        }
        if (DynamicRecipeManager.checkListEqualityIngredient(output, recipe.getOutput(), true)) {
            this.recipes.remove(recipe.getInput());
            this.removeCachedRecipes(recipe.getInput());
        }
        return false;
    }

    private static boolean checkListEqualityIngredient(Collection<? extends RecipeIngredient> first, Collection<? extends RecipeIngredient> second, boolean strict) {
        if (first.size() != second.size()) {
            return false;
        }
        ListIterator<? extends RecipeIngredient> itB = new ArrayList<RecipeIngredient>(second).listIterator();
        block0: for (RecipeIngredient recipeIngredient : first) {
            while (itB.hasNext()) {
                if (!(strict ? recipeIngredient.matchesStrict(itB.next()) : recipeIngredient.matches(itB.next()))) continue;
                itB.remove();
                while (itB.hasPrevious()) {
                    itB.previous();
                }
                continue block0;
            }
            return false;
        }
        return true;
    }

    protected void displayError(String message) {
        if (!MainConfig.ignoreInvalidRecipes) {
            throw new RuntimeException(message);
        }
        IC2.log.warn(LogCategory.Recipe, message);
    }
}

