/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.CropSoilType;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.api.network.NetworkHelper;
import ic2.core.IC2;
import ic2.core.Ic2Player;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.block.state.UnlistedProperty;
import ic2.core.crop.IC2Crops;
import ic2.core.item.ItemCropSeed;
import ic2.core.item.type.CropResItemType;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.util.BiomeUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCrop
extends TileEntityBlock
implements ICropTile {
    public char ticker = (char)IC2.random.nextInt(tickRate);
    public boolean dirty = true;
    public static int tickRate = 256;
    private CropCard crop = null;
    private byte statGrowth;
    private byte statGain;
    private byte statResistance;
    private short storageNutrients;
    private short storageWater;
    private short storageWeedEX;
    private byte terrainAirQuality;
    private byte terrainHumidity;
    private byte terrainNutrients;
    private byte currentSize;
    private short growthPoints = 0;
    private byte scanLevel;
    private boolean crossingBase;
    private NBTTagCompound customData = new NBTTagCompound();
    public static final IUnlistedProperty<CropRenderState> renderStateProperty = new UnlistedProperty<CropRenderState>("renderstate", CropRenderState.class);
    private volatile CropRenderState cropRenderState;
    public static final boolean debug = System.getProperty("ic2.crops.debug") != null;
    public static final boolean debugGrowth = debug && System.getProperty("ic2.crops.debug").contains("growth");
    public static final boolean debugWeedWork = debug && System.getProperty("ic2.crops.debug").contains("weedwork");
    public static final boolean debugCollision = debug && System.getProperty("ic2.crops.debug").contains("collision");
    public static final boolean debugTerrain = debug && System.getProperty("ic2.crops.debug").contains("terrain");

    public TileEntityCrop() {
        if (debug) {
            IC2.log.info(LogCategory.Block, "Debug mode is running");
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.crossingBase = nbt.func_74767_n("crossingBase");
        if (nbt.func_74764_b("cropOwner") && nbt.func_74764_b("cropId")) {
            this.crop = Crops.instance.getCropCard(nbt.func_74779_i("cropOwner"), nbt.func_74779_i("cropId"));
            this.statGrowth = nbt.func_74771_c("statGrowth");
            this.statGain = nbt.func_74771_c("statGain");
            this.statResistance = nbt.func_74771_c("statResistance");
            this.storageNutrients = nbt.func_74765_d("storageNutrients");
            this.storageWater = nbt.func_74765_d("storageWater");
            this.storageWeedEX = nbt.func_74765_d("storageWeedEX");
            this.terrainHumidity = nbt.func_74771_c("terrainHumidity");
            this.terrainNutrients = nbt.func_74771_c("terrainNutrients");
            this.terrainAirQuality = nbt.func_74771_c("terrainAirQuality");
            this.currentSize = nbt.func_74771_c("currentSize");
            this.growthPoints = nbt.func_74765_d("growthPoints");
            this.scanLevel = nbt.func_74771_c("scanLevel");
            this.customData = nbt.func_74775_l("customData");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("crossingBase", this.crossingBase);
        if (this.crop != null) {
            nbt.func_74778_a("cropOwner", this.crop.getOwner());
            nbt.func_74778_a("cropId", this.crop.getId());
            nbt.func_74774_a("statGrowth", this.statGrowth);
            nbt.func_74774_a("statGain", this.statGain);
            nbt.func_74774_a("statResistance", this.statResistance);
            nbt.func_74777_a("storageNutrients", this.storageNutrients);
            nbt.func_74777_a("storageWater", this.storageWater);
            nbt.func_74777_a("storageWeedEX", this.storageWeedEX);
            nbt.func_74774_a("terrainHumidity", this.terrainHumidity);
            nbt.func_74774_a("terrainNutrients", this.terrainNutrients);
            nbt.func_74774_a("terrainAirQuality", this.terrainAirQuality);
            nbt.func_74774_a("currentSize", this.currentSize);
            nbt.func_74777_a("growthPoints", this.growthPoints);
            nbt.func_74774_a("scanLevel", this.scanLevel);
            nbt.func_74782_a("customData", (NBTBase)this.customData.func_74737_b());
        }
        return nbt;
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("crop");
        ret.add("currentSize");
        ret.add("statGrowth");
        ret.add("statGain");
        ret.add("statResistance");
        ret.add("storageNutrients");
        ret.add("storageWater");
        ret.add("storageWeedEX");
        ret.add("terrainHumidity");
        ret.add("terrainNutrients");
        ret.add("terrainAirQuality");
        ret.add("currentSize");
        ret.add("growthPoints");
        ret.add("scanLevel");
        ret.add("crossingBase");
        ret.add("customData");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.updateRenderState();
        this.rerender();
        super.onNetworkUpdate(field);
    }

    @Override
    protected EnumPlantType getPlantType() {
        return EnumPlantType.Crop;
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            this.updateRenderState();
        }
    }

    @Override
    public void updateEntityServer() {
        char c = this.ticker;
        this.ticker = (char)(c + '\u0001');
        if (c % tickRate == 0) {
            this.performTick();
        }
        if (this.dirty) {
            this.dirty = false;
            World world = this.func_145831_w();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
            world.func_190522_c(this.field_174879_c, (Block)this.getBlockType());
            world.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
            if (!world.field_72995_K) {
                for (String field : this.getNetworkedFields()) {
                    IC2.network.get(true).updateTileEntityField(this, field);
                }
            }
        }
    }

    public void performTick() {
        assert (!this.func_145831_w().field_72995_K);
        if (this.ticker % (tickRate << 2) == 0) {
            this.updateTerrainHumidity();
            if (debug) {
                IC2.log.info(LogCategory.Block, "Crop at %s - terrain humidity: %s", this.field_174879_c, this.terrainHumidity);
            }
        }
        if ((this.ticker + tickRate) % (tickRate << 2) == 0) {
            this.updateTerrainNutrients();
            if (debug) {
                IC2.log.info(LogCategory.Block, "Crop at %s - terrain nutrients: %s", this.field_174879_c, this.terrainNutrients);
            }
        }
        if ((this.ticker + tickRate * 2) % (tickRate << 2) == 0) {
            this.updateTerrainAirQuality();
            if (debug) {
                IC2.log.info(LogCategory.Block, "Crop at %s - terrain air quality: %s", this.field_174879_c, this.terrainAirQuality);
            }
        }
        if (!(this.crop != null || this.isCrossingBase() && this.attemptCrossing())) {
            if (IC2.random.nextInt(100) == 0 && this.getStorageWeedEX() <= 0) {
                this.reset();
                this.crop = IC2Crops.weed;
                this.setCurrentSize(1);
            } else {
                if (this.getStorageWeedEX() > 0 && IC2.random.nextInt(10) == 0) {
                    this.storageWeedEX = (short)(this.storageWeedEX - 1);
                }
                return;
            }
        }
        this.crop.tick(this);
        if (debug) {
            System.out.println("Plant: " + this.getCrop().getUnlocalizedName());
        }
        if (this.crop.canGrow(this)) {
            this.performGrowthTick();
            if (this.crop == null) {
                return;
            }
            if (this.growthPoints >= this.crop.getGrowthDuration(this)) {
                this.growthPoints = 0;
                this.setCurrentSize(this.getCurrentSize() + 1);
                this.dirty = true;
            }
        }
        if (this.storageNutrients > 0) {
            this.storageNutrients = (short)(this.storageNutrients - 1);
        }
        if (this.storageWater > 0) {
            this.storageWater = (short)(this.storageWater - 1);
        }
        if (this.crop.isWeed(this) && IC2.random.nextInt(50) - this.getStatGrowth() <= 2) {
            this.performWeedWork();
        }
    }

    public void performGrowthTick() {
        if (this.crop == null) {
            return;
        }
        if (debugGrowth) {
            IC2.log.info(LogCategory.Block, "Crop at %s - growth points (before): %s", this.field_174879_c, this.growthPoints);
        }
        int totalGrowth = 0;
        int baseGrowth = 3 + IC2.random.nextInt(7) + this.getStatGrowth();
        int providedQuality = 75;
        int minimumQuality = (this.crop.getProperties().getTier() - 1) * 4 + this.getStatGrowth() + this.statGain + this.statResistance;
        minimumQuality = minimumQuality < 0 ? 0 : minimumQuality;
        if (providedQuality >= minimumQuality) {
            totalGrowth = baseGrowth * (100 + (providedQuality - minimumQuality)) / 100;
        } else {
            int aux = (minimumQuality - providedQuality) * 4;
            if (aux > 100 && IC2.random.nextInt(32) > this.statResistance) {
                this.reset();
                totalGrowth = 0;
            } else {
                totalGrowth = baseGrowth * (100 - aux) / 100;
                totalGrowth = totalGrowth < 0 ? 0 : totalGrowth;
            }
        }
        this.growthPoints = (short)(this.growthPoints + totalGrowth);
        if (debugGrowth) {
            IC2.log.info(LogCategory.Block, "Crop at %s - base growth: %s", this.field_174879_c, baseGrowth);
            IC2.log.info(LogCategory.Block, "Crop at %s - minimum quality: %s", this.field_174879_c, minimumQuality);
            IC2.log.info(LogCategory.Block, "Crop at %s - provided quality: %s", this.field_174879_c, providedQuality);
            IC2.log.info(LogCategory.Block, "Crop at %s - total growth: %s", this.field_174879_c, totalGrowth);
            IC2.log.info(LogCategory.Block, "Crop at %s - growth points (after): %s", this.field_174879_c, this.growthPoints);
        }
    }

    public void performWeedWork() {
        BlockPos dstPos;
        World world = this.func_145831_w();
        TileEntity dstRaw = world.func_175625_s(dstPos = this.field_174879_c.func_177972_a(EnumFacing.field_176754_o[IC2.random.nextInt(4)]));
        if (dstRaw instanceof TileEntityCrop) {
            TileEntityCrop tileEntityCrop;
            CropCard neighborCrop;
            if (debugWeedWork) {
                IC2.log.info(LogCategory.Block, "Crop at %s - trying to generate weed", dstPos);
            }
            if ((neighborCrop = (tileEntityCrop = (TileEntityCrop)dstRaw).getCrop()) == null || !neighborCrop.isWeed(tileEntityCrop) && IC2.random.nextInt(32) >= tileEntityCrop.getStatResistance() && !tileEntityCrop.hasWeedEX()) {
                int newGrowth;
                if (debugWeedWork) {
                    IC2.log.info(LogCategory.Block, "Crop at %s - weed generated", dstPos);
                }
                if ((newGrowth = Math.max(this.getStatGrowth(), tileEntityCrop.getStatGrowth())) < 31 && IC2.random.nextBoolean()) {
                    ++newGrowth;
                }
                tileEntityCrop.reset();
                tileEntityCrop.crop = Crops.weed;
                tileEntityCrop.setCurrentSize(1);
                tileEntityCrop.setStatGrowth(newGrowth);
            }
        } else if (world.func_175623_d(dstPos)) {
            BlockPos soilPos;
            Block block;
            if (debugWeedWork) {
                IC2.log.info(LogCategory.Block, "Block at %s - trying to generate grass", dstPos);
            }
            if ((block = world.func_180495_p(soilPos = dstPos.func_177977_b()).func_177230_c()) == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak) {
                world.func_180501_a(soilPos, Blocks.field_150349_c.func_176223_P(), 7);
                world.func_180501_a(dstPos, Blocks.field_150329_H.func_176203_a(1), 7);
            }
        }
    }

    public boolean hasWeedEX() {
        if (this.storageWeedEX > 0) {
            this.storageWeedEX = (short)(this.storageWeedEX - 5);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.func_145831_w().field_72995_K) {
            return true;
        }
        return this.rightClick(player, hand);
    }

    @Override
    protected void onClicked(EntityPlayer player) {
        if (this.crop != null) {
            this.crop.onLeftClick(this, player);
        } else if (this.crossingBase && !this.func_145831_w().field_72995_K) {
            this.crossingBase = false;
            this.dirty = true;
            StackUtil.dropAsEntity(this.func_145831_w(), this.field_174879_c, ItemName.crop_stick.getItemStack());
        }
    }

    @Override
    protected SoundType getBlockSound(Entity entity) {
        return SoundType.field_185850_c;
    }

    @Override
    protected void onBlockBreak() {
        if (!this.func_145831_w().field_72995_K) {
            this.pick();
        }
    }

    @Override
    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>();
        if (forCollision) {
            ret.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        } else {
            ret.add(new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.85f, (double)0.8f));
        }
        return ret;
    }

    public boolean rightClick(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = StackUtil.get(player, hand);
        boolean creative = player.field_71075_bZ.field_75098_d;
        if (!StackUtil.isEmpty(heldItem)) {
            if (this.crop == null && !this.crossingBase && heldItem.func_77973_b() == ItemName.crop_stick.getInstance()) {
                if (!creative) {
                    StackUtil.consumeOrError(player, hand, 1);
                }
                this.crossingBase = true;
                this.dirty = true;
                return true;
            }
            if (this.crop != null && StackUtil.checkItemEquality(heldItem, ItemName.crop_res.getItemStack(CropResItemType.fertilizer))) {
                if (this.applyFertilizer(true)) {
                    this.dirty = true;
                }
                if (!creative) {
                    StackUtil.consumeOrError(player, hand, 1);
                }
                return true;
            }
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
            if (handler != null) {
                if (this.applyHydration((IFluidHandler)handler) || this.applyWeedEx((IFluidHandler)handler, true)) {
                    this.dirty = true;
                }
                return true;
            }
            if (this.crop == null && !this.crossingBase && Crops.instance.getBaseSeed(heldItem) != null) {
                this.reset();
                BaseSeed bs = Crops.instance.getBaseSeed(heldItem);
                this.crop = bs.crop;
                this.currentSize = (byte)bs.size;
                this.statGain = (byte)bs.statGain;
                this.statGrowth = (byte)bs.statGrowth;
                this.statResistance = (byte)bs.statResistance;
                if (!creative) {
                    StackUtil.consumeOrError(player, hand, 1);
                }
                return true;
            }
        }
        if (this.crop == null) {
            return false;
        }
        return this.crop.onRightClick(this, player);
    }

    public boolean tryPlantIn(CropCard crop, int size, int statGr, int statGa, int statRe, int scan) {
        if (crop == null || crop == IC2Crops.weed || this.isCrossingBase()) {
            return false;
        }
        if (!crop.canGrow(this)) {
            return false;
        }
        this.reset();
        this.crop = crop;
        this.setCurrentSize(size);
        this.setStatGain(statGa);
        this.setStatGrowth(statGr);
        this.setStatResistance(statRe);
        this.setScanLevel(scan);
        NetworkHelper.sendInitialData(this);
        return true;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.crop == null) {
            return;
        }
        if (this.crop.onEntityCollision(this, entity)) {
            World world = this.func_145831_w();
            if (world.field_72995_K) {
                return;
            }
            if (IC2.random.nextInt(100) == 0 && IC2.random.nextInt(40) > this.statResistance) {
                this.reset();
                world.func_180501_a(this.field_174879_c.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 7);
                if (debugCollision) {
                    IC2.log.info(LogCategory.Block, "Crop at %s - crop was trampled", this.field_174879_c);
                }
            }
        }
    }

    public void updateTerrainAirQuality() {
        World world = this.func_145831_w();
        int value = 0;
        int height = (this.field_174879_c.func_177956_o() - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = this.field_174879_c.func_177958_n() - 1; x < this.field_174879_c.func_177958_n() + 1 && fresh > 0; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - 1; z < this.field_174879_c.func_177952_p() + 1 && fresh > 0; ++z) {
                if (!world.func_175677_d(new BlockPos(x, this.field_174879_c.func_177956_o(), z), false) && !(world.func_175625_s(new BlockPos(x, this.field_174879_c.func_177956_o(), z)) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (world.func_175678_i(this.field_174879_c.func_177984_a())) {
            value += 2;
        }
        this.setTerrainAirQuality(value);
    }

    public void updateTerrainHumidity() {
        World world = this.func_145831_w();
        int humidity = Crops.instance.getHumidityBiomeBonus(BiomeUtil.getBiome(world, this.field_174879_c));
        if ((Integer)world.func_180495_p(this.field_174879_c.func_177977_b()).func_177229_b((IProperty)BlockFarmland.field_176531_a) >= 7) {
            humidity += 2;
        }
        if (this.getStorageWater() >= 5) {
            humidity += 2;
        }
        this.setTerrainHumidity(humidity += (this.getStorageWater() + 24) / 25);
    }

    public void updateTerrainNutrients() {
        World world = this.func_145831_w();
        int nutrients = Crops.instance.getNutrientBiomeBonus(BiomeUtil.getBiome(world, this.field_174879_c));
        for (int i = 1; i < 5 && world.func_180495_p(this.field_174879_c.func_177979_c(i)).func_177230_c() == Blocks.field_150346_d; ++i) {
            ++nutrients;
        }
        this.setTerrainNutrients(nutrients += (this.getStorageNutrients() + 19) / 20);
    }

    @Override
    public CropCard getCrop() {
        return this.crop;
    }

    @Override
    public void setCrop(CropCard crop) {
        this.crop = crop;
    }

    @Override
    public int getCurrentSize() {
        return this.currentSize;
    }

    @Override
    public void setCurrentSize(int size) {
        this.currentSize = (byte)size;
    }

    @Override
    public int getStatGrowth() {
        return this.statGrowth;
    }

    @Override
    public void setStatGrowth(int growth) {
        this.statGrowth = (byte)growth;
    }

    @Override
    public int getStatGain() {
        return this.statGain;
    }

    @Override
    public void setStatGain(int gain) {
        this.statGain = (byte)gain;
    }

    @Override
    public int getStatResistance() {
        return this.statResistance;
    }

    @Override
    public void setStatResistance(int resistance) {
        this.statResistance = (byte)resistance;
    }

    @Override
    public int getStorageNutrients() {
        return this.storageNutrients;
    }

    @Override
    public void setStorageNutrients(int nutrients) {
        this.storageNutrients = (short)nutrients;
    }

    @Override
    public int getStorageWater() {
        return this.storageWater;
    }

    @Override
    public void setStorageWater(int water) {
        this.storageWater = (short)water;
    }

    @Override
    public int getStorageWeedEX() {
        return this.storageWeedEX;
    }

    @Override
    public void setStorageWeedEX(int weedEX) {
        this.storageWeedEX = (short)weedEX;
    }

    @Override
    public int getTerrainAirQuality() {
        return this.terrainAirQuality;
    }

    public void setTerrainAirQuality(int value) {
        this.terrainAirQuality = (byte)value;
    }

    @Override
    public int getTerrainHumidity() {
        return this.terrainHumidity;
    }

    public void setTerrainHumidity(int humidity) {
        this.terrainHumidity = (byte)humidity;
    }

    @Override
    public int getTerrainNutrients() {
        return this.terrainNutrients;
    }

    public void setTerrainNutrients(int nutrients) {
        this.terrainNutrients = (byte)nutrients;
    }

    @Override
    public int getScanLevel() {
        return this.scanLevel;
    }

    @Override
    public void setScanLevel(int scanLevel) {
        this.scanLevel = (byte)scanLevel;
    }

    @Override
    public int getGrowthPoints() {
        return this.growthPoints;
    }

    @Override
    public void setGrowthPoints(int growthPoints) {
        this.growthPoints = (short)growthPoints;
    }

    @Override
    public boolean isCrossingBase() {
        return this.crossingBase;
    }

    @Override
    public void setCrossingBase(boolean crossingBase) {
        this.crossingBase = crossingBase;
    }

    @Override
    public NBTTagCompound getCustomData() {
        return this.customData;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    @Deprecated
    public BlockPos getLocation() {
        return this.field_174879_c;
    }

    @Override
    public int getLightLevel() {
        return this.func_145831_w().func_175699_k(this.field_174879_c);
    }

    @Override
    public int getLightValue() {
        return this.crop == null ? 0 : this.crop.getEmittedLight(this);
    }

    @Override
    public boolean pick() {
        int i;
        if (this.crop == null) {
            return false;
        }
        World world = this.func_145831_w();
        boolean bonus = this.crop.canBeHarvested(this);
        float firstchance = this.crop.dropSeedChance(this);
        firstchance = (float)((double)firstchance * Math.pow(1.1, this.statResistance));
        int dropCount = 0;
        if (bonus) {
            if (world.field_73012_v.nextFloat() <= (firstchance + 1.0f) * 0.8f) {
                ++dropCount;
            }
            float chance = this.crop.dropSeedChance(this) + (float)this.getStatGrowth() / 100.0f;
            for (i = 23; i < this.statGain; ++i) {
                chance *= 0.95f;
            }
            if (world.field_73012_v.nextFloat() <= chance) {
                ++dropCount;
            }
        } else if (world.field_73012_v.nextFloat() <= firstchance * 1.5f) {
            ++dropCount;
        }
        ItemStack[] drops = new ItemStack[dropCount];
        for (i = 0; i < dropCount; ++i) {
            drops[i] = this.crop.getSeeds(this);
        }
        this.reset();
        if (!world.field_72995_K && drops.length > 0) {
            for (ItemStack drop : drops) {
                if (drop.func_77973_b() != ItemName.crop_seed_bag.getInstance()) {
                    drop.func_77982_d(null);
                }
                StackUtil.dropAsEntity(world, this.field_174879_c, drop);
            }
        }
        return true;
    }

    @Override
    public boolean performManualHarvest() {
        List<ItemStack> dropItems = this.performHarvest();
        if (dropItems != null && !dropItems.isEmpty()) {
            World world = this.func_145831_w();
            for (ItemStack stack : dropItems) {
                StackUtil.dropAsEntity(world, this.field_174879_c, stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> performHarvest() {
        int i;
        if (this.crop == null || !this.crop.canBeHarvested(this)) {
            return null;
        }
        double chance = this.crop.dropGainChance();
        chance *= Math.pow(1.03, this.getStatGain());
        if (debug) {
            System.out.println("chance: " + chance);
            int simCount = 200;
            int sum = 0;
            for (i = 0; i < 200; ++i) {
                int dropCount = (int)Math.max(0L, Math.round(IC2.random.nextGaussian() * chance * 0.6827 + chance));
                sum += dropCount;
                System.out.print(dropCount + " ");
            }
            System.out.println();
            System.out.println("sum: " + sum + ", avg: " + (double)sum / 200.0);
        }
        int dropCount = (int)Math.max(0L, Math.round(IC2.random.nextGaussian() * chance * 0.6827 + chance));
        ItemStack[] ret = new ItemStack[dropCount];
        for (i = 0; i < dropCount; ++i) {
            ret[i] = this.crop.getGain(this);
            if (ret[i] == null || IC2.random.nextInt(100) > this.getStatGain()) continue;
            ret[i] = StackUtil.incSize(ret[i]);
        }
        this.setCurrentSize(this.crop.getSizeAfterHarvest(this));
        this.dirty = true;
        return Arrays.asList(ret);
    }

    @Override
    public void reset() {
        this.crop = null;
        this.customData = new NBTTagCompound();
        this.statGain = 0;
        this.statResistance = 0;
        this.statGrowth = 0;
        this.terrainAirQuality = (byte)-1;
        this.terrainHumidity = (byte)-1;
        this.terrainNutrients = (byte)-1;
        this.growthPoints = 0;
        this.scanLevel = 0;
        this.currentSize = 1;
        this.dirty = true;
    }

    @Override
    public void updateState() {
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    public boolean isBlockBelow(Block reqBlock) {
        if (this.crop == null) {
            return false;
        }
        World world = this.func_145831_w();
        for (int i = 1; i < this.crop.getRootsLength(this); ++i) {
            BlockPos blockPos = this.field_174879_c.func_177979_c(i);
            IBlockState state = world.func_180495_p(blockPos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)world, blockPos)) {
                return false;
            }
            if (block != reqBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockBelow(String oreDictionaryEntry) {
        if (this.crop == null) {
            return false;
        }
        World world = this.func_145831_w();
        for (int i = 1; i < this.crop.getRootsLength(this); ++i) {
            BlockPos blockPos = this.field_174879_c.func_177979_c(i);
            IBlockState state = world.func_180495_p(blockPos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)world, blockPos)) {
                return false;
            }
            ItemStack stackBelow = StackUtil.getPickStack(world, blockPos, state, Ic2Player.get(world));
            for (ItemStack stack : OreDictionary.getOres((String)oreDictionaryEntry)) {
                if (!StackUtil.checkItemEquality(stackBelow, stack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack generateSeeds(CropCard crop, int growth, int gain, int resistance, int scan) {
        return ItemCropSeed.generateItemStackFromValues(crop, growth, gain, resistance, scan);
    }

    @Override
    protected int getLightOpacity() {
        return 0;
    }

    @Override
    public Ic2BlockState.Ic2BlockStateInstance getExtendedState(Ic2BlockState.Ic2BlockStateInstance state) {
        state = super.getExtendedState(state);
        CropRenderState renderState = this.cropRenderState;
        if (renderState != null) {
            state = state.withProperties(renderStateProperty, renderState);
        }
        return state;
    }

    private void updateRenderState() {
        this.cropRenderState = new CropRenderState(this.crop, this.getCurrentSize(), this.crossingBase);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    protected ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        if (this.crop == null) {
            return ItemName.crop_stick.getItemStack();
        }
        return this.generateSeeds(this.crop, this.statGrowth, this.statGain, this.statResistance, this.scanLevel);
    }

    private boolean attemptCrossing() {
        if (IC2.random.nextInt(3) != 0) {
            return false;
        }
        ArrayList<TileEntityCrop> cropTes = new ArrayList<TileEntityCrop>(4);
        this.askCropJoinCross(this.field_174879_c.func_177978_c(), cropTes);
        this.askCropJoinCross(this.field_174879_c.func_177968_d(), cropTes);
        this.askCropJoinCross(this.field_174879_c.func_177974_f(), cropTes);
        this.askCropJoinCross(this.field_174879_c.func_177976_e(), cropTes);
        if (debug) {
            System.out.print("Attempted cross with " + cropTes.size() + " plants: ");
            for (int i = 0; i < cropTes.size(); ++i) {
                System.out.print(((TileEntityCrop)cropTes.get(i)).getCrop().getUnlocalizedName() + " ");
            }
            System.out.println();
        }
        if (cropTes.size() < 2) {
            return false;
        }
        CropCard[] crops = Crops.instance.getCrops().toArray(new CropCard[0]);
        if (crops.length == 0) {
            return false;
        }
        int[] ratios = new int[crops.length];
        int total = 0;
        for (int i = 0; i < ratios.length; ++i) {
            CropCard crop = crops[i];
            if (crop.canGrow(this)) {
                for (TileEntityCrop te : cropTes) {
                    total += this.calculateRatioFor(crop, te.getCrop());
                }
            }
            ratios[i] = total;
        }
        if (debug) {
            int lastChance = 0;
            for (int i = 0; i < crops.length; ++i) {
                int currentChance = ratios[i];
                System.out.printf("%s: %.1f%% %d%n", crops[i].getUnlocalizedName(), (double)(currentChance - lastChance) * 100.0 / (double)total, ratios[i]);
                lastChance = currentChance;
            }
        }
        int search = IC2.random.nextInt(total);
        if (debug) {
            System.out.printf("rnd: %d / %d%n", search, total);
        }
        int min = 0;
        int max = ratios.length - 1;
        while (min < max) {
            int cur = (min + max) / 2;
            int value = ratios[cur];
            if (debug) {
                System.out.printf("min: %d, max: %d, cur: %d, value: %d%n", min, max, cur, value);
            }
            if (search < value) {
                max = cur;
                continue;
            }
            min = cur + 1;
        }
        if (debug) {
            System.out.printf("result: %s (%d %d)%n", crops[min].getUnlocalizedName(), min, max);
        }
        assert (min == max);
        assert (min >= 0 && min < ratios.length);
        assert (ratios[min] > search);
        assert (min == 0 || ratios[min - 1] <= search);
        this.setCrossingBase(false);
        this.crop = crops[min];
        this.dirty = true;
        this.setCurrentSize(1);
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        for (TileEntityCrop te : cropTes) {
            this.statGrowth = (byte)(this.statGrowth + te.statGrowth);
            this.statResistance = (byte)(this.statResistance + te.statResistance);
            this.statGain = (byte)(this.statGain + te.statGain);
        }
        int count = cropTes.size();
        this.statGrowth = (byte)(this.statGrowth / count);
        this.statResistance = (byte)(this.statResistance / count);
        this.statGain = (byte)(this.statGain / count);
        this.statGrowth = (byte)(this.statGrowth + (IC2.random.nextInt(1 + 2 * count) - count));
        this.statGain = (byte)(this.statGain + (IC2.random.nextInt(1 + 2 * count) - count));
        this.statResistance = (byte)(this.statResistance + (IC2.random.nextInt(1 + 2 * count) - count));
        this.statGrowth = (byte)Util.limit(this.statGrowth, 0, 31);
        this.statGain = (byte)Util.limit(this.statGain, 0, 31);
        this.statResistance = (byte)Util.limit(this.statResistance, 0, 31);
        return true;
    }

    private int calculateRatioFor(CropCard newCrop, CropCard oldCrop) {
        if (newCrop == oldCrop) {
            return 500;
        }
        int value = 0;
        int[] nArray = oldCrop.getProperties().getAllProperties();
        int[] propNew = newCrop.getProperties().getAllProperties();
        assert (nArray.length == propNew.length);
        for (int i = 0; i < 5; ++i) {
            int delta = Math.abs(nArray[i] - propNew[i]);
            value += -delta + 2;
        }
        for (String attributeNew : newCrop.getAttributes()) {
            for (String attributeOld : oldCrop.getAttributes()) {
                if (!attributeNew.equalsIgnoreCase(attributeOld)) continue;
                value += 5;
            }
        }
        int n = newCrop.getProperties().getTier() - oldCrop.getProperties().getTier();
        if (n > 1) {
            value -= 2 * n;
        }
        if (n < -3) {
            value -= -n;
        }
        return Math.max(value, 0);
    }

    private void askCropJoinCross(BlockPos pos, List<TileEntityCrop> crops) {
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (!(te instanceof TileEntityCrop)) {
            return;
        }
        TileEntityCrop sideCrop = (TileEntityCrop)te;
        CropCard neighborCrop = sideCrop.getCrop();
        if (neighborCrop == null) {
            return;
        }
        if (!neighborCrop.canGrow(this) || !neighborCrop.canCross(sideCrop)) {
            return;
        }
        int base = 4;
        if (sideCrop.statGrowth >= 16) {
            ++base;
        }
        if (sideCrop.statGrowth >= 30) {
            ++base;
        }
        if (sideCrop.statResistance >= 28) {
            base += 27 - sideCrop.statResistance;
        }
        if (base >= IC2.random.nextInt(20)) {
            crops.add(sideCrop);
        }
    }

    @Override
    protected void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        World world = this.func_145831_w();
        if (!CropSoilType.contais(world.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c())) {
            this.pick();
            world.func_175698_g(this.field_174879_c);
        }
    }

    public boolean applyHydration(IFluidHandler handler) {
        short limit = 200;
        if (this.storageWater >= limit) {
            return false;
        }
        FluidStack stack = handler.drain(new FluidStack(FluidRegistry.WATER, limit - this.storageWater), true);
        if (stack == null || stack.amount <= 0) {
            return false;
        }
        this.storageWater = (short)(this.storageWater + stack.amount);
        return true;
    }

    public boolean applyWeedEx(IFluidHandler handler, boolean manual) {
        short limit;
        short s = limit = manual ? (short)100 : 150;
        if (this.storageWeedEX >= limit) {
            return false;
        }
        FluidStack stack = handler.drain(new FluidStack(FluidName.weed_ex.getInstance(), limit - this.storageWeedEX), true);
        if (stack == null || stack.amount <= 0) {
            return false;
        }
        this.storageWeedEX = (short)(this.storageWeedEX + stack.amount);
        return true;
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.storageNutrients >= 100) {
            return false;
        }
        this.storageNutrients = (short)(this.storageNutrients + (manual ? 100 : 90));
        return true;
    }

    public static class CropRenderState {
        public final CropCard crop;
        public final int size;
        public final boolean crosscrop;

        public CropRenderState(CropCard crop, int size, boolean crosscrop) {
            this.crop = crop;
            this.size = size;
            this.crosscrop = crosscrop;
        }

        public int hashCode() {
            int ret = this.crop != null ? this.crop.hashCode() : 1;
            ret = ret * 31 + (this.size + 1) * 5;
            ret = ret * 31 + (this.crosscrop ? 1 : 0);
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CropRenderState)) {
                return false;
            }
            CropRenderState crs = (CropRenderState)obj;
            return crs.crop == this.crop && crs.size == this.size && crs.crosscrop == this.crosscrop;
        }

        public String toString() {
            return "CropState<" + this.crop + ", " + this.size + ", " + this.crosscrop + '>';
        }
    }
}

