/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.items;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.util.StackUtil;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;

public class InvSlotPipe
extends InvSlot {
    public InvSlotPipe(TileEntityInventory tileEntityInventory, String name, int count, InvSlot.Access access) {
        super(tileEntityInventory, name, access, count, InvSlot.InvSide.ANY);
        this.setStackSizeLimit(64);
    }

    @Override
    public boolean accepts(ItemStack itemStack) {
        return this.access == InvSlot.Access.I;
    }

    public int add(Collection<ItemStack> itemStacks) {
        return this.add(itemStacks, false);
    }

    public int add(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack is null.");
        }
        return this.add(Collections.singletonList(itemStack), false);
    }

    public boolean canAdd(Collection<ItemStack> itemStacks) {
        return this.add(itemStacks, true) == 0;
    }

    public boolean canAdd(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack is null.");
        }
        return this.add(Collections.singletonList(itemStack), true) < itemStack.func_190916_E();
    }

    private int add(Collection<ItemStack> itemStacks, boolean simulate) {
        if (itemStacks == null || itemStacks.isEmpty()) {
            return 0;
        }
        ItemStack[] backup = simulate ? this.backup() : null;
        int totalAmount = 0;
        for (ItemStack itemStack : itemStacks) {
            int amount = StackUtil.getSize(itemStack);
            if (amount <= 0) continue;
            block1: for (int pass = 0; pass < 2; ++pass) {
                for (int i = 0; i < this.size(); ++i) {
                    ItemStack existingStack = this.get(i);
                    int space = this.getStackSizeLimit();
                    if (!StackUtil.isEmpty(existingStack)) {
                        space = Math.min(space, existingStack.func_77976_d()) - StackUtil.getSize(existingStack);
                    }
                    if (space <= 0) continue;
                    if (pass == 0 && !StackUtil.isEmpty(existingStack) && StackUtil.checkItemEqualityStrict(itemStack, existingStack)) {
                        if (space >= amount) {
                            this.put(i, StackUtil.incSize(existingStack, amount));
                            amount = 0;
                            break block1;
                        }
                        this.put(i, StackUtil.incSize(existingStack, space));
                        amount -= space;
                        continue;
                    }
                    if (pass != 1 || !StackUtil.isEmpty(existingStack)) continue;
                    if (space >= amount) {
                        this.put(i, StackUtil.copyWithSize(itemStack, amount));
                        amount = 0;
                        break block1;
                    }
                    this.put(i, StackUtil.copyWithSize(itemStack, space));
                    amount -= space;
                }
            }
            totalAmount += amount;
        }
        if (simulate) {
            this.restore(backup);
        }
        return totalAmount;
    }
}

