/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.covers;

import ic2.api.transport.IFluidTransportTile;
import ic2.core.IC2;
import ic2.core.block.transport.covers.ICover;
import ic2.core.util.LiquidUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PumpCover
implements ICover<IFluidTransportTile> {
    private int operationsPerSecond;
    private int updateTicker;
    private int tickRate;

    public PumpCover(int operationsPerSecond) {
        this.operationsPerSecond = operationsPerSecond;
        this.tickRate = 20 / operationsPerSecond;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
    }

    @Override
    public boolean workingTick() {
        return this.updateTicker++ % this.tickRate == 0;
    }

    @Override
    public void operate(IFluidTransportTile tile, World world, BlockPos pos, EnumFacing facing) {
        TileEntity target;
        if (world.func_175625_s(pos.func_177972_a(facing)) != null && LiquidUtil.isFluidTile(target = world.func_175625_s(pos.func_177972_a(facing)), facing.func_176734_d())) {
            int maxTransfer = Math.min(tile.getTransferRate() / this.operationsPerSecond, tile.getMaxInnerCapacity() - tile.getCurrentInnerCapacity());
            if (LiquidUtil.drainTile(target, facing.func_176734_d(), maxTransfer, true) != null) {
                tile.put(LiquidUtil.drainTile(target, facing.func_176734_d(), maxTransfer, false), facing, false);
            }
        }
    }
}

