/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport;

import ic2.api.transport.IFluidTransportTile;
import ic2.core.IC2;
import ic2.core.block.comp.Fluids;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.transport.TileEntityPipe;
import ic2.core.block.transport.items.PipeSize;
import ic2.core.block.transport.items.PipeType;
import ic2.core.item.block.ItemPipe;
import ic2.core.util.LiquidUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityFluidPipe
extends TileEntityPipe
implements IFluidTransportTile {
    protected PipeType type = PipeType.bronze;
    protected PipeSize size = PipeSize.small;
    protected byte tracker = 0;
    protected byte oldTracker = 0;
    protected Fluids fluids;
    protected FluidTank fluidTank;

    public TileEntityFluidPipe() {
    }

    public TileEntityFluidPipe(PipeType type, PipeSize size) {
        this();
        this.tickRate = 5;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
        this.type = type;
        this.size = size;
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("contents", (int)(size.thickness * 2.0f * 1000.0f), InvSlot.Access.NONE);
    }

    @Override
    public int put(FluidStack stack, EnumFacing facing, boolean simulate) {
        if (simulate) {
            return this.fluidTank.fillInternal(stack, false);
        }
        int ret = this.fluidTank.fillInternal(stack, true);
        if (ret > 0) {
            this.tracker = (byte)(this.tracker | 1 << facing.ordinal());
        }
        return ret;
    }

    @Override
    public FluidStack getContents() {
        return this.fluidTank.getFluid();
    }

    @Override
    public void setContents(FluidStack stack) {
        this.fluidTank.setFluid(stack);
    }

    @Override
    public int getTransferRate() {
        return this.type.transferRate;
    }

    @Override
    public int getCurrentInnerCapacity() {
        return this.fluidTank.getFluidAmount();
    }

    @Override
    public int getMaxInnerCapacity() {
        return this.fluidTank.getCapacity();
    }

    @Override
    public void flipConnection(EnumFacing facing) {
        TileEntity tile;
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        if (!world.field_72995_K && (tile = world.func_175625_s(pos.func_177972_a(facing))) != null && (LiquidUtil.isFluidTile(tile, facing.func_176734_d()) || tile instanceof IFluidTransportTile)) {
            this.connectivity = (byte)(this.connectivity ^ 1 << facing.ordinal());
            IC2.network.get(true).updateTileEntityField(this, "connectivity");
            world.func_175685_c(pos, this.field_145854_h, true);
            this.func_70296_d();
        }
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.updateTicker++ % this.tickRate != 0) {
            return;
        }
        boolean needsUpdate = false;
        if (this.tracker == 63) {
            this.tracker = 0;
        }
        if (this.tracker == this.oldTracker) {
            if (this.fluidTank.getFluid() != null) {
                FluidStack fStack = this.fluidTank.getFluid().copy();
                int outputs = 0;
                for (EnumFacing facing : EnumFacing.values()) {
                    if ((this.tracker & 1 << facing.ordinal()) != 0 || this.isConnected(facing)) continue;
                    ++outputs;
                }
                int maxTransfer = Math.min(fStack.amount, this.type.transferRate / 4);
                int actualTransfer = 0;
                int maxAmountPerOutput = (int)Math.floor((float)maxTransfer / (float)outputs);
                for (EnumFacing facing : EnumFacing.values()) {
                    TileEntity target;
                    if (!this.isConnected(facing) || (this.tracker & 1 << facing.ordinal()) != 0 || (target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null) continue;
                    FluidStack tempStack = fStack.copy();
                    fStack.amount = maxAmountPerOutput;
                    if (target instanceof IFluidTransportTile) {
                        if (((IFluidTransportTile)target).put(tempStack, facing.func_176734_d(), true) <= 0) continue;
                        actualTransfer += ((IFluidTransportTile)target).put(tempStack, facing.func_176734_d(), false);
                        continue;
                    }
                    if (!LiquidUtil.isFluidTile(target, facing.func_176734_d()) || LiquidUtil.fillTile(target, facing.func_176734_d(), tempStack, true) <= 0) continue;
                    actualTransfer += LiquidUtil.fillTile(target, facing.func_176734_d(), tempStack, false);
                }
                this.fluidTank.drainInternal(actualTransfer, true);
                needsUpdate = true;
            }
            this.tracker = 0;
        }
        this.oldTracker = this.tracker;
        if (needsUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = PipeType.values[nbt.func_74771_c("type") & 0xFF];
        this.size = PipeSize.values()[nbt.func_74771_c("size") & 0xFF];
        this.tracker = nbt.func_74771_c("tracker");
        this.oldTracker = nbt.func_74771_c("oldTracker");
        this.tickRate = 5;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("contents", (int)(this.size.thickness * 2.0f * 1000.0f), InvSlot.Access.NONE);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)this.type.ordinal());
        nbt.func_74774_a("size", (byte)this.size.ordinal());
        nbt.func_74774_a("tracker", this.tracker);
        nbt.func_74774_a("oldTracker", this.oldTracker);
        return nbt;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        if (this.func_145831_w().field_72995_K) {
            this.updateRenderState();
        } else {
            for (EnumFacing direction : EnumFacing.values()) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v());
                if (tile == null || !(tile instanceof IFluidTransportTile)) continue;
                ((IFluidTransportTile)tile).flipConnection(direction);
            }
            this.updateConnectivity();
        }
        super.onPlaced(stack, placer, facing);
    }

    @Override
    protected ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return ItemPipe.getPipe(this.type, this.size);
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> ret = super.getNetworkedFields();
        ret.add("type");
        ret.add("size");
        return ret;
    }

    @Override
    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        float th = this.size.thickness;
        float sp = (1.0f - th) / 2.0f;
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(7);
        ret.add(new AxisAlignedBB((double)sp, (double)sp, (double)sp, (double)(sp + th), (double)(sp + th), (double)(sp + th)));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            float zE;
            float zS;
            boolean hasConnection;
            boolean bl = hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
            if (!hasConnection) continue;
            float yS = zS = sp;
            float xS = zS;
            float yE = zE = sp + th;
            float xE = zE;
            switch (facing) {
                case DOWN: {
                    yS = 0.0f;
                    yE = sp;
                    break;
                }
                case UP: {
                    yS = sp + th;
                    yE = 1.0f;
                    break;
                }
                case NORTH: {
                    zS = 0.0f;
                    zE = sp;
                    break;
                }
                case SOUTH: {
                    zS = sp + th;
                    zE = 1.0f;
                    break;
                }
                case WEST: {
                    xS = 0.0f;
                    xE = sp;
                    break;
                }
                case EAST: {
                    xS = sp + th;
                    xE = 1.0f;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ret.add(new AxisAlignedBB((double)xS, (double)yS, (double)zS, (double)xE, (double)yE, (double)zE));
        }
        return ret;
    }

    @Override
    protected void updateRenderState() {
        this.renderState = new TileEntityPipe.PipeRenderState(this.type, this.size, this.connectivity, this.getFacing().ordinal());
    }

    @Override
    protected void updateConnectivity() {
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        int mask = 1;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tile = world.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tile != null) {
                if (tile instanceof IFluidTransportTile) {
                    if (((IFluidTransportTile)tile).isConnected(direction.func_176734_d())) {
                        newConnectivity = (byte)(newConnectivity | mask);
                    }
                } else if (LiquidUtil.isFluidTile(tile, direction.func_176734_d())) {
                    newConnectivity = (byte)(newConnectivity | mask);
                }
            }
            mask *= 2;
        }
        if (this.connectivity != newConnectivity) {
            this.connectivity = newConnectivity;
            IC2.network.get(true).updateTileEntityField(this, "connectivity");
        }
    }
}

