/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.covers;

import ic2.api.transport.IItemTransportTile;
import ic2.core.IC2;
import ic2.core.block.transport.covers.ICover;
import ic2.core.util.StackUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Inserter
implements ICover<IItemTransportTile> {
    private int updateTicker;
    private int tickRate;

    public Inserter(int operationsPerSecond) {
        this.tickRate = 20 / operationsPerSecond;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
    }

    @Override
    public boolean workingTick() {
        return this.updateTicker++ % this.tickRate == 0;
    }

    @Override
    public void operate(IItemTransportTile tile, World world, BlockPos pos, EnumFacing facing) {
        TileEntity target;
        if (world.func_175625_s(pos.func_177972_a(facing)) != null && (target = world.func_175625_s(pos.func_177972_a(facing))) instanceof IInventory) {
            ItemStack stack = tile.getContents();
            if (StackUtil.isEmpty(stack)) {
                return;
            }
            if (StackUtil.putInInventory(target, facing.func_176734_d(), stack, true) > 0) {
                int newAmount = StackUtil.putInInventory(target, facing.func_176734_d(), stack, false);
                tile.setContents(StackUtil.copyShrunk(stack, newAmount));
            }
        }
    }
}

