/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.items;

import ic2.api.transport.IItemTransportTile;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.block.state.UnlistedProperty;
import ic2.core.block.transport.items.ItemPipeType;
import ic2.core.block.transport.items.PipeSize;
import ic2.core.item.block.ItemPipe;
import ic2.core.util.StackUtil;
import ic2.core.util.Tuple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;

public class TileEntityItemPipe
extends TileEntityBlock
implements IItemTransportTile {
    public static final IUnlistedProperty<PipeRenderState> renderStateProperty = new UnlistedProperty<PipeRenderState>("renderstate", PipeRenderState.class);
    protected ItemPipeType type = ItemPipeType.bronze;
    protected PipeSize size = PipeSize.small;
    private byte connectivity = 0;
    private volatile PipeRenderState renderState;
    private int updateTicker;
    private int tickRate;
    private Queue<Tuple.T2<ItemStack, EnumFacing>> contents = new ArrayDeque<Tuple.T2<ItemStack, EnumFacing>>();
    private Tuple.T2<ItemStack, EnumFacing> temp;

    public TileEntityItemPipe() {
    }

    public TileEntityItemPipe(ItemPipeType type, PipeSize size) {
        this();
        this.tickRate = 20 / type.transferRate;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
        this.type = type;
        this.size = size;
    }

    @Override
    public int putItems(ItemStack itemStack, EnumFacing facing, boolean simulate) {
        if (this.temp != null) {
            return 0;
        }
        if (itemStack.func_190926_b()) {
            return 0;
        }
        int acceptedAmount = Math.min(itemStack.func_190916_E(), this.getMaxStackSizeAllowed());
        if (!simulate) {
            this.temp = new Tuple.T2<ItemStack, EnumFacing>(StackUtil.copyWithSize(itemStack, acceptedAmount), facing);
        }
        return acceptedAmount;
    }

    @Override
    public int getMaxStackSizeAllowed() {
        return this.size.maxStackSize;
    }

    @Override
    public int getTransferRate() {
        return this.type.transferRate;
    }

    @Override
    protected void updateEntityServer() {
        TileEntity target;
        EnumFacing facing;
        super.updateEntityServer();
        if (this.updateTicker++ % this.tickRate != 0) {
            return;
        }
        boolean needsInventoryUpdate = false;
        if (this.temp != null) {
            for (int ordinal : TileEntityItemPipe.shuffledFacings()) {
                ItemStack newStack;
                int amount;
                facing = EnumFacing.values()[ordinal];
                if (facing == this.temp.b) continue;
                target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (target instanceof IInventory && StackUtil.putInInventory(target, facing.func_176734_d(), (ItemStack)this.temp.a, true) > 0) {
                    amount = StackUtil.putInInventory(target, facing.func_176734_d(), (ItemStack)this.temp.a, false);
                    newStack = StackUtil.copyShrunk((ItemStack)this.temp.a, amount);
                    if (newStack.func_190926_b()) {
                        this.temp = null;
                    } else {
                        this.temp.a = newStack;
                    }
                    needsInventoryUpdate = true;
                    break;
                }
                if (!(target instanceof IItemTransportTile) || ((IItemTransportTile)target).putItems((ItemStack)this.temp.a, facing.func_176734_d(), true) <= 0) continue;
                amount = ((IItemTransportTile)target).putItems((ItemStack)this.temp.a, facing.func_176734_d(), false);
                newStack = StackUtil.copyShrunk((ItemStack)this.temp.a, amount);
                if (newStack.func_190926_b()) {
                    this.temp = null;
                } else {
                    this.temp.a = newStack;
                }
                needsInventoryUpdate = true;
                break;
            }
        }
        if (this.temp == null) {
            for (int ordinal : TileEntityItemPipe.shuffledFacings()) {
                facing = EnumFacing.values()[ordinal];
                if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing)) == null || !((target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) instanceof IInventory) || StackUtil.getFromInventory(target, facing.func_176734_d(), null, this.size.maxStackSize, false, true).func_190926_b()) continue;
                this.temp = new Tuple.T2<ItemStack, EnumFacing>(StackUtil.getFromInventory(target, facing.func_176734_d(), null, this.size.maxStackSize, false, false), facing);
                needsInventoryUpdate = true;
                break;
            }
        }
        if (needsInventoryUpdate) {
            this.func_70296_d();
        }
    }

    private static int[] shuffledFacings() {
        int[] ordinals = new int[]{0, 1, 2, 3, 4, 5};
        for (int i = ordinals.length - 1; i > 0; --i) {
            int index = IC2.random.nextInt(i + 1);
            if (index == i) continue;
            int n = index;
            ordinals[n] = ordinals[n] ^ ordinals[i];
            int n2 = i;
            ordinals[n2] = ordinals[n2] ^ ordinals[index];
            int n3 = index;
            ordinals[n3] = ordinals[n3] ^ ordinals[i];
        }
        return ordinals;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = ItemPipeType.values[nbt.func_74771_c("type") & 0xFF];
        this.size = PipeSize.values()[nbt.func_74771_c("size") & 0xFF];
        NBTTagList contentsTag = nbt.func_150295_c("contents", 10);
        for (int i = 0; i < contentsTag.func_74745_c(); ++i) {
            NBTTagCompound contentTag = contentsTag.func_150305_b(i);
            EnumFacing facing = EnumFacing.values()[contentTag.func_74771_c("facing") & 0xFF];
            ItemStack stack = new ItemStack(contentTag);
            if (StackUtil.isEmpty(stack)) continue;
            this.temp = new Tuple.T2<ItemStack, EnumFacing>(stack, facing);
        }
        this.tickRate = 20 / this.type.transferRate;
        this.updateTicker = IC2.random.nextInt(this.tickRate);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("type", (byte)this.type.ordinal());
        nbt.func_74774_a("size", (byte)this.size.ordinal());
        if (this.temp != null && !StackUtil.isEmpty((ItemStack)this.temp.a)) {
            NBTTagList contentsTag = new NBTTagList();
            ItemStack content = (ItemStack)this.temp.a;
            NBTTagCompound contentTag = new NBTTagCompound();
            contentTag.func_74774_a("facing", (byte)((EnumFacing)this.temp.b).ordinal());
            content.func_77955_b(contentTag);
            contentsTag.func_74742_a((NBTBase)contentTag);
            nbt.func_74782_a("contents", (NBTBase)contentsTag);
        }
        return nbt;
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (this.func_145831_w().field_72995_K) {
            this.updateRenderState();
        } else {
            this.updateConnectivity();
        }
    }

    @Override
    protected void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    protected SoundType getBlockSound(Entity entity) {
        return SoundType.field_185852_e;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        this.updateRenderState();
        super.onPlaced(stack, placer, facing);
    }

    @Override
    protected ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return ItemPipe.getPipe(this.type, this.size);
    }

    @Override
    protected List<ItemStack> getAuxDrops(int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(super.getAuxDrops(fortune));
        if (this.temp != null && !((ItemStack)this.temp.a).func_190926_b()) {
            ret.add((ItemStack)this.temp.a);
        }
        return ret;
    }

    @Override
    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        float th = this.size.thickness;
        float sp = (1.0f - th) / 2.0f;
        ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(7);
        ret.add(new AxisAlignedBB((double)sp, (double)sp, (double)sp, (double)(sp + th), (double)(sp + th), (double)(sp + th)));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            float zE;
            float zS;
            boolean hasConnection;
            boolean bl = hasConnection = (this.connectivity & 1 << facing.ordinal()) != 0;
            if (!hasConnection) continue;
            float yS = zS = sp;
            float xS = zS;
            float yE = zE = sp + th;
            float xE = zE;
            switch (facing) {
                case DOWN: {
                    yS = 0.0f;
                    yE = sp;
                    break;
                }
                case UP: {
                    yS = sp + th;
                    yE = 1.0f;
                    break;
                }
                case NORTH: {
                    zS = 0.0f;
                    zE = sp;
                    break;
                }
                case SOUTH: {
                    zS = sp + th;
                    zE = 1.0f;
                    break;
                }
                case WEST: {
                    xS = 0.0f;
                    xE = sp;
                    break;
                }
                case EAST: {
                    xS = sp + th;
                    xE = 1.0f;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ret.add(new AxisAlignedBB((double)xS, (double)yS, (double)zS, (double)xE, (double)yE, (double)zE));
        }
        return ret;
    }

    @Override
    protected boolean isNormalCube() {
        return false;
    }

    @Override
    protected boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    protected boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public Ic2BlockState.Ic2BlockStateInstance getExtendedState(Ic2BlockState.Ic2BlockStateInstance state) {
        state = super.getExtendedState(state);
        PipeRenderState pipeRenderState = this.renderState;
        if (pipeRenderState != null) {
            state = state.withProperties(renderStateProperty, pipeRenderState);
        }
        return state;
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (!this.func_145831_w().field_72995_K) {
            this.updateConnectivity();
        }
    }

    private void updateConnectivity() {
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        int mask = 1;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tile = world.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tile instanceof IInventory || tile instanceof IItemTransportTile) {
                newConnectivity = (byte)(newConnectivity | mask);
            }
            mask *= 2;
        }
        if (this.connectivity != newConnectivity) {
            this.connectivity = newConnectivity;
            IC2.network.get(true).updateTileEntityField(this, "connectivity");
        }
    }

    @Override
    protected int getLightOpacity() {
        return 0;
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> ret = super.getNetworkedFields();
        ret.add("type");
        ret.add("size");
        ret.add("connectivity");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.updateRenderState();
        this.rerender();
        super.onNetworkUpdate(field);
    }

    @Override
    protected boolean clientNeedsExtraModelInfo() {
        return true;
    }

    private void updateRenderState() {
        this.renderState = new PipeRenderState(this.type, this.size, this.connectivity, this.getFacing().ordinal());
    }

    public static class PipeRenderState {
        public final ItemPipeType type;
        public final PipeSize size;
        public final int connectivity;
        public final int facing;

        public PipeRenderState(ItemPipeType type, PipeSize size, int connectivity, int facing) {
            this.type = type;
            this.size = size;
            this.connectivity = connectivity;
            this.facing = facing;
        }

        public int hashCode() {
            int ret = this.type.hashCode();
            ret = ret * 31 + this.size.hashCode();
            ret = ret * 31 + this.connectivity;
            ret = ret * 31 + this.facing;
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PipeRenderState)) {
                return false;
            }
            PipeRenderState o = (PipeRenderState)obj;
            return o.type == this.type && o.size == this.size && o.connectivity == this.connectivity && o.facing == this.facing;
        }

        public String toString() {
            return "PipeState<" + this.type + ", " + this.size + ", " + this.connectivity + ", " + this.facing + '>';
        }
    }
}

