/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.items;

import ic2.core.block.state.IIdProvider;
import ic2.core.block.transport.items.PipeSize;
import java.util.HashMap;
import java.util.Map;

public enum ItemPipeType implements IIdProvider
{
    bronze(2, 255, 128, 0);

    public final int transferRate;
    public final int red;
    public final int green;
    public final int blue;
    public static final ItemPipeType[] values;
    private static final Map<String, ItemPipeType> nameMap;

    private ItemPipeType(int transferRate, int red, int green, int blue) {
        this.transferRate = transferRate;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public String getName(PipeSize size) {
        StringBuilder ret = new StringBuilder(this.getName());
        ret.append("_pipe");
        if (size != null) {
            ret.append('_');
            ret.append(size.name());
        }
        return ret.toString();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    public static ItemPipeType get(String name) {
        return nameMap.get(name);
    }

    static {
        values = ItemPipeType.values();
        nameMap = new HashMap<String, ItemPipeType>();
        for (ItemPipeType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

