/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.gui;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public class Ic2GuiFactory
implements IModGuiFactory {
    public void initialize(Minecraft mc) {
    }

    @Deprecated
    public Class<? extends GuiScreen> mainConfigGuiClass() {
        return IC2ConfigGuiScreen.class;
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return Collections.emptySet();
    }

    @Deprecated
    public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
        return null;
    }

    public boolean hasConfigGui() {
        return true;
    }

    public GuiScreen createConfigGui(GuiScreen parentScreen) {
        return new IC2ConfigGuiScreen(parentScreen);
    }

    public static class IC2ConfigGuiScreen
    extends GuiConfig {
        private static final int LANG_KEY_LENGTH = "ic2.config.".length();
        private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
        private static final Pattern IS_BOOLEAN = Pattern.compile("true|false", 2);
        private static final Pattern IS_INT = Pattern.compile("\\d");
        private static final Pattern IS_DOUBLE = Pattern.compile("\\d\\.\\d");

        public IC2ConfigGuiScreen(GuiScreen parent) {
            super(parent, IC2ConfigGuiScreen.sinkCategoryLevel(MainConfig.get(), "."), "ic2", false, false, "IC2 Configuration");
        }

        private static List<IConfigElement> sinkCategoryLevel(Config config, String parentName) {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>(config.getNumberOfSections() + config.getNumberOfConfigs());
            if (config.hasChildSection()) {
                Iterator<Config> configCategories = config.sectionIterator();
                while (configCategories.hasNext()) {
                    Config category = configCategories.next();
                    list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(category.name, "ic2.config.sub." + category.name, IC2ConfigGuiScreen.sinkCategoryLevel(category, parentName + category.name + '.')));
                }
                if (!config.isEmptySection()) {
                    IC2ConfigGuiScreen.getConfigs(list, config.valueIterator(), parentName);
                }
            } else {
                IC2ConfigGuiScreen.getConfigs(list, config.valueIterator(), parentName);
            }
            return list;
        }

        private static void getConfigs(List<IConfigElement> list, Iterator<Config.Value> configs, String parentName) {
            while (configs.hasNext()) {
                Config.Value conf = configs.next();
                Config.Value defaultConf = MainConfig.getDefault(parentName.substring(1).replace('.', '/') + conf.name);
                if (defaultConf.value.isEmpty() || defaultConf.value.contains(",") || defaultConf.comment.contains("comma")) {
                    list.add((IConfigElement)new ListElement(conf.name, conf.value, defaultConf.value, "ic2.config" + parentName + conf.name));
                    continue;
                }
                ConfigGuiType type = IS_DOUBLE.matcher(conf.value).matches() ? ConfigGuiType.DOUBLE : (IS_INT.matcher(conf.value).matches() ? ConfigGuiType.INTEGER : (IS_BOOLEAN.matcher(conf.value).matches() ? ConfigGuiType.BOOLEAN : ConfigGuiType.STRING));
                list.add((IConfigElement)new ConfigElement(conf.name, conf.value, defaultConf.value, type, "ic2.config" + parentName + conf.name));
            }
        }

        public void func_146281_b() {
            for (IConfigElement config : this.configElements) {
                this.saveConfig(config);
            }
            MainConfig.save();
            super.func_146281_b();
        }

        private void saveConfig(IConfigElement config) {
            if (config.getChildElements() != null) {
                for (IConfigElement subConfig : config.getChildElements()) {
                    this.saveConfig(subConfig);
                }
            }
            if (config.isProperty()) {
                if (config.isList()) {
                    assert (config.getClass() == ListElement.class) : "Unexpected class type: " + config.getClass();
                    if (!((ListElement)config).previous.equals(config.getList())) {
                        MainConfig.get().set(config.getLanguageKey().substring(LANG_KEY_LENGTH).replace('.', '/'), COMMA_JOINER.join(config.getList()));
                    }
                } else {
                    assert (config.getClass() == ConfigElement.class) : "Unexpected class type: " + config.getClass();
                    if (!Objects.equals(config.get(), ((ConfigElement)config).previous)) {
                        MainConfig.get().set(config.getLanguageKey().substring(LANG_KEY_LENGTH).replace('.', '/'), config.get());
                    }
                }
            }
        }

        private static class ListElement
        extends DummyConfigElement.DummyListElement {
            private Object[] previous;
            private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
            private static final Pattern COMMA_PATTERN = Pattern.compile("^([A-Za-z0-9_]+:[A-Za-z0-9_]+((,){1}( )*|$))+?");

            private ListElement(String name, CharSequence value, CharSequence defaultValues, String langKey) {
                super(name, COMMA_SPLITTER.splitToList(defaultValues).toArray(), ConfigGuiType.STRING, langKey, COMMA_PATTERN);
                this.values = COMMA_SPLITTER.splitToList(value).toArray();
                this.previous = this.values;
            }

            public void set(Object[] values) {
                this.previous = this.values;
                this.values = values;
            }

            public void setToDefault() {
                this.previous = this.values;
                super.setToDefault();
            }

            public String toString() {
                return "ConfigListElement<" + this.name + '>';
            }
        }

        private static class ConfigElement
        extends DummyConfigElement {
            private Object previous;

            private ConfigElement(String name, Object value, Object defaultValue, ConfigGuiType type, String langKey) {
                super(name, defaultValue, type, langKey);
                this.previous = this.value = value;
            }

            public void set(Object value) {
                this.previous = this.value;
                this.value = value;
            }

            public void setToDefault() {
                this.previous = this.value;
                super.setToDefault();
            }

            public String toString() {
                return "ConfigElement<" + this.name + '>';
            }
        }
    }
}

