/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.IWorldTickCallback;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TeBlockRegistry;
import ic2.core.block.comp.Components;
import ic2.core.block.comp.RedstoneEmitter;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.block.state.MaterialProperty;
import ic2.core.block.state.SkippedBooleanProperty;
import ic2.core.block.type.ResourceBlock;
import ic2.core.gui.dynamic.IGuiConditionProvider;
import ic2.core.ref.BlockName;
import ic2.core.ref.MetaTeBlockProperty;
import ic2.core.ref.TeBlock;
import ic2.core.util.AabbUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
ITickable,
IGuiConditionProvider {
    public static final String teBlockName = "teBlk";
    protected static final int lightOpacityTranslucent = 0;
    protected static final int lightOpacityOpaque = 255;
    protected static final EnumPlantType noCrop = EnumPlantType.getPlantType((String)"IC2_NO_CROP");
    private static final NBTTagCompound emptyNbt = new NBTTagCompound();
    private static final List<AxisAlignedBB> defaultAabbs = Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final List<TileEntityComponent> emptyComponents = Collections.emptyList();
    private static final Map<Class<?>, TickSubscription> tickSubscriptions = new HashMap();
    private static final byte loadStateInitial = 0;
    private static final byte loadStateQueued = 1;
    private static final byte loadStateLoaded = 2;
    private static final byte loadStateUnloaded = 3;
    protected final ITeBlock teBlock;
    private final BlockTileEntity block;
    private Map<Class<? extends TileEntityComponent>, TileEntityComponent> components;
    private Map<Capability<?>, TileEntityComponent> capabilityComponents;
    private List<TileEntityComponent> updatableComponents;
    private boolean active = false;
    private byte facing = (byte)EnumFacing.DOWN.ordinal();
    private byte loadState = 0;
    private boolean enableWorldTick;

    public static TileEntityBlock instantiate(Class<? extends TileEntityBlock> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TileEntityBlock() {
        ITeBlock teb = TeBlockRegistry.get(this.getClass());
        this.teBlock = teb == null ? TeBlock.invalid : teb;
        this.block = TeBlockRegistry.get(this.teBlock.getIdentifier());
    }

    public final BlockTileEntity getBlockType() {
        return this.block;
    }

    public final IBlockState getBlockState() {
        return this.block.func_176223_P().func_177226_a((IProperty)this.block.materialProperty, (Comparable)MaterialProperty.WrappedMaterial.getMaterial(this.teBlock)).func_177226_a(this.block.typeProperty, (Comparable)MetaTeBlockProperty.getState(this.teBlock, this.getActive())).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing()).func_177226_a(BlockTileEntity.transparentProperty, (Comparable)SkippedBooleanProperty.getValue(this.teBlock));
    }

    public final void func_145843_s() {
        if (this.loadState != 3) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public final void onChunkUnload() {
        if (this.loadState != 3) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public final void func_145829_t() {
        super.func_145829_t();
        World world = this.func_145831_w();
        if (world == null || this.field_174879_c == null) {
            throw new IllegalStateException("no world/pos");
        }
        if (this.loadState != 0 && this.loadState != 3) {
            throw new IllegalStateException("invalid load state: " + this.loadState);
        }
        this.loadState = 1;
        IC2.tickHandler.requestSingleWorldTick(world, new IWorldTickCallback(){

            @Override
            public void onTick(World world) {
                if (world == TileEntityBlock.this.func_145831_w() && TileEntityBlock.this.field_174879_c != null && !TileEntityBlock.this.func_145837_r() && TileEntityBlock.this.loadState == 1 && world.func_175667_e(TileEntityBlock.this.field_174879_c) && world.func_175625_s(TileEntityBlock.this.field_174879_c) == TileEntityBlock.this) {
                    TileEntityBlock.this.onLoaded();
                }
            }
        });
    }

    public final void onLoad() {
    }

    protected void onLoaded() {
        if (this.loadState != 1) {
            throw new IllegalStateException("invalid load state: " + this.loadState);
        }
        this.loadState = (byte)2;
        this.enableWorldTick = this.requiresWorldTick();
        if (this.components != null) {
            for (TileEntityComponent component : this.components.values()) {
                component.onLoaded();
                if (!component.enableWorldTick()) continue;
                if (this.updatableComponents == null) {
                    this.updatableComponents = new ArrayList<TileEntityComponent>(4);
                }
                this.updatableComponents.add(component);
            }
        }
        if (!this.enableWorldTick && this.updatableComponents == null) {
            this.func_145831_w().field_175730_i.remove(this);
        }
    }

    protected void onUnloaded() {
        if (this.loadState == 3) {
            throw new IllegalStateException("invalid load state: " + this.loadState);
        }
        this.loadState = (byte)3;
        if (this.components != null) {
            for (TileEntityComponent component : this.components.values()) {
                component.onUnloaded();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!this.getSupportedFacings().isEmpty()) {
            byte facingValue = nbt.func_74771_c("facing");
            this.facing = facingValue >= 0 && facingValue < EnumFacing.field_82609_l.length && this.getSupportedFacings().contains(EnumFacing.field_82609_l[facingValue]) ? facingValue : (!this.getSupportedFacings().isEmpty() ? (byte)this.getSupportedFacings().iterator().next().ordinal() : (byte)EnumFacing.DOWN.ordinal());
        }
        this.active = nbt.func_74767_n("active");
        if (this.components != null && nbt.func_150297_b("components", 10)) {
            NBTTagCompound componentsNbt = nbt.func_74775_l("components");
            for (String name : componentsNbt.func_150296_c()) {
                Object component;
                Class cls = Components.getClass(name);
                if (cls == null || (component = this.getComponent(cls)) == null) {
                    IC2.log.warn(LogCategory.Block, "Can't find component %s while loading %s.", name, this);
                    continue;
                }
                NBTTagCompound componentNbt = componentsNbt.func_74775_l(name);
                ((TileEntityComponent)component).readFromNbt(componentNbt);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.getSupportedFacings().isEmpty()) {
            nbt.func_74774_a("facing", this.facing);
        }
        nbt.func_74757_a("active", this.active);
        if (this.components != null) {
            NBTTagCompound componentsNbt = null;
            for (TileEntityComponent component : this.components.values()) {
                NBTTagCompound componentNbt = component.writeToNbt();
                if (componentNbt == null) continue;
                if (componentsNbt == null) {
                    componentsNbt = new NBTTagCompound();
                    nbt.func_74782_a("components", (NBTBase)componentsNbt);
                }
                componentsNbt.func_74782_a(Components.getId(component.getClass()), (NBTBase)componentNbt);
            }
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        IC2.network.get(true).sendInitialData(this);
        return emptyNbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        IC2.network.get(true).sendInitialData(this);
        return null;
    }

    public final void func_73660_a() {
        if (this.loadState != 2) {
            return;
        }
        if (this.updatableComponents != null) {
            for (TileEntityComponent component : this.updatableComponents) {
                component.onWorldTick();
            }
        }
        if (this.enableWorldTick) {
            if (this.func_145831_w().field_72995_K) {
                this.updateEntityClient();
            } else {
                this.updateEntityServer();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
    }

    protected void updateEntityServer() {
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> ret = new ArrayList<String>(3);
        ret.add("teBlk=" + this.teBlock.getName());
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") || field.equals("facing")) {
            this.rerender();
        }
    }

    protected Ic2BlockState.Ic2BlockStateInstance getExtendedState(Ic2BlockState.Ic2BlockStateInstance state) {
        return state;
    }

    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            // empty if block
        }
        if ((facing = this.getPlacementFacing(placer, facing)) != this.getFacing()) {
            this.setFacing(facing);
        }
        if (world.field_72995_K) {
            this.rerender();
        }
    }

    protected RayTraceResult collisionRayTrace(Vec3d start, Vec3d end) {
        Vec3d startNormalized = start.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        double lengthSq = Util.square(end.field_72450_a - start.field_72450_a) + Util.square(end.field_72448_b - start.field_72448_b) + Util.square(end.field_72449_c - start.field_72449_c);
        double lengthInv = 1.0 / Math.sqrt(lengthSq);
        Vec3d direction = new Vec3d((end.field_72450_a - start.field_72450_a) * lengthInv, (end.field_72448_b - start.field_72448_b) * lengthInv, (end.field_72449_c - start.field_72449_c) * lengthInv);
        double minDistanceSq = lengthSq;
        Vec3d minIntersection = null;
        EnumFacing minIntersectionSide = null;
        MutableObject intersectionOut = new MutableObject();
        for (AxisAlignedBB aabb : this.getAabbs(false)) {
            EnumFacing side = AabbUtil.getIntersection(startNormalized, direction, aabb, (MutableObject<Vec3d>)intersectionOut);
            if (side == null) continue;
            Vec3d intersection = (Vec3d)intersectionOut.getValue();
            double distanceSq = Util.square(intersection.field_72450_a - startNormalized.field_72450_a) + Util.square(intersection.field_72448_b - startNormalized.field_72448_b) + Util.square(intersection.field_72449_c - startNormalized.field_72449_c);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            minIntersection = intersection;
            minIntersectionSide = side;
        }
        if (minIntersection == null) {
            return null;
        }
        return new RayTraceResult(minIntersection.func_72441_c((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()), minIntersectionSide, this.field_174879_c);
    }

    public AxisAlignedBB getVisualBoundingBox() {
        return this.getAabb(false);
    }

    protected AxisAlignedBB getPhysicsBoundingBox() {
        return this.getAabb(true);
    }

    protected AxisAlignedBB getOutlineBoundingBox() {
        return this.getVisualBoundingBox();
    }

    protected void addCollisionBoxesToList(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB maskNormalized = mask.func_72317_d((double)(-this.field_174879_c.func_177958_n()), (double)(-this.field_174879_c.func_177956_o()), (double)(-this.field_174879_c.func_177952_p()));
        for (AxisAlignedBB aabb : this.getAabbs(true)) {
            if (!aabb.func_72326_a(maskNormalized)) continue;
            list.add(aabb.func_186670_a(this.field_174879_c));
        }
    }

    private AxisAlignedBB getAabb(boolean forCollision) {
        List<AxisAlignedBB> aabbs = this.getAabbs(forCollision);
        if (aabbs.isEmpty()) {
            throw new RuntimeException("No AABBs for " + this);
        }
        if (aabbs.size() == 1) {
            return aabbs.get(0);
        }
        double zS = Double.POSITIVE_INFINITY;
        double yS = Double.POSITIVE_INFINITY;
        double xS = Double.POSITIVE_INFINITY;
        double zE = Double.NEGATIVE_INFINITY;
        double yE = Double.NEGATIVE_INFINITY;
        double xE = Double.NEGATIVE_INFINITY;
        for (AxisAlignedBB aabb : aabbs) {
            xS = Math.min(xS, aabb.field_72340_a);
            yS = Math.min(yS, aabb.field_72338_b);
            zS = Math.min(zS, aabb.field_72339_c);
            xE = Math.max(xE, aabb.field_72336_d);
            yE = Math.max(yE, aabb.field_72337_e);
            zE = Math.max(zE, aabb.field_72334_f);
        }
        return new AxisAlignedBB(xS, yS, zS, xE, yE, zE);
    }

    protected void onEntityCollision(Entity entity) {
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        World world;
        AxisAlignedBB aabb = this.getVisualBoundingBox();
        if (aabb != defaultAabbs) {
            switch (side) {
                case DOWN: {
                    if (!(aabb.field_72338_b > 0.0)) break;
                    return true;
                }
                case UP: {
                    if (!(aabb.field_72337_e < 1.0)) break;
                    return true;
                }
                case NORTH: {
                    if (!(aabb.field_72339_c > 0.0)) break;
                    return true;
                }
                case SOUTH: {
                    if (!(aabb.field_72334_f < 1.0)) break;
                    return true;
                }
                case WEST: {
                    if (!(aabb.field_72340_a > 0.0)) break;
                    return true;
                }
                case EAST: {
                    if (!(aabb.field_72336_d < 1.0)) break;
                    return true;
                }
            }
        }
        return !(world = this.func_145831_w()).func_180495_p(otherPos).doesSideBlockRendering((IBlockAccess)world, otherPos, side.func_176734_d());
    }

    protected boolean doesSideBlockRendering(EnumFacing side) {
        return TileEntityBlock.checkSide(this.getAabbs(false), side, false);
    }

    private static boolean checkSide(List<AxisAlignedBB> aabbs, EnumFacing side, boolean strict) {
        if (aabbs == defaultAabbs) {
            return true;
        }
        int dx = side.func_82601_c();
        int dy = side.func_96559_d();
        int dz = side.func_82599_e();
        int xS = (dx + 1) / 2;
        int yS = (dy + 1) / 2;
        int zS = (dz + 1) / 2;
        int xE = (dx + 2) / 2;
        int yE = (dy + 2) / 2;
        int zE = (dz + 2) / 2;
        if (strict) {
            for (AxisAlignedBB aabb : aabbs) {
                switch (side) {
                    case DOWN: {
                        if (!(aabb.field_72338_b < 0.0)) break;
                        return false;
                    }
                    case UP: {
                        if (!(aabb.field_72337_e > 1.0)) break;
                        return false;
                    }
                    case NORTH: {
                        if (!(aabb.field_72339_c < 0.0)) break;
                        return false;
                    }
                    case SOUTH: {
                        if (!(aabb.field_72334_f > 1.0)) break;
                        return false;
                    }
                    case WEST: {
                        if (!(aabb.field_72340_a < 0.0)) break;
                        return false;
                    }
                    case EAST: {
                        if (!(aabb.field_72336_d > 1.0)) break;
                        return false;
                    }
                }
            }
        }
        for (AxisAlignedBB aabb : aabbs) {
            if (!(aabb.field_72340_a <= (double)xS) || !(aabb.field_72338_b <= (double)yS) || !(aabb.field_72339_c <= (double)zS) || !(aabb.field_72336_d >= (double)xE) || !(aabb.field_72337_e >= (double)yE) || !(aabb.field_72334_f >= (double)zE)) continue;
            return true;
        }
        return false;
    }

    protected boolean isNormalCube() {
        List<AxisAlignedBB> aabbs = this.getAabbs(false);
        if (aabbs == defaultAabbs) {
            return true;
        }
        if (aabbs.size() != 1) {
            return false;
        }
        AxisAlignedBB aabb = aabbs.get(0);
        return aabb.field_72340_a <= 0.0 && aabb.field_72338_b <= 0.0 && aabb.field_72339_c <= 0.0 && aabb.field_72336_d >= 1.0 && aabb.field_72337_e >= 1.0 && aabb.field_72334_f >= 1.0;
    }

    protected boolean isSideSolid(EnumFacing side) {
        return TileEntityBlock.checkSide(this.getAabbs(false), side, true);
    }

    protected int getLightOpacity() {
        return this.isNormalCube() ? 255 : 0;
    }

    protected int getLightValue() {
        return 0;
    }

    protected boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this instanceof IHasGui) {
            if (!this.func_145831_w().field_72995_K) {
                return IC2.platform.launchGui(player, (IHasGui)((Object)this));
            }
            return true;
        }
        return false;
    }

    protected void onClicked(EntityPlayer player) {
    }

    protected void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        if (this.components != null) {
            for (TileEntityComponent component : this.components.values()) {
                component.onNeighborChange(neighbor, neighborPos);
            }
        }
    }

    protected int getStrongPower(EnumFacing side) {
        return 0;
    }

    protected int getWeakPower(EnumFacing side) {
        RedstoneEmitter rs = this.getComponent(RedstoneEmitter.class);
        if (rs == null) {
            return 0;
        }
        return rs.getLevel();
    }

    protected boolean connectRedstone(EnumFacing side) {
        return this.getWeakPower(side) > 0;
    }

    protected int getComparatorInputOverride() {
        return 0;
    }

    protected boolean recolor(EnumFacing side, EnumDyeColor mcColor) {
        return false;
    }

    protected void onExploded(Explosion explosion) {
    }

    protected void onBlockBreak() {
    }

    protected boolean onRemovedByPlayer(EntityPlayer player, boolean willHarvest) {
        return true;
    }

    protected ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return this.block.getItemStack(this.teBlock);
    }

    protected boolean canHarvest(EntityPlayer player, boolean defaultValue) {
        return defaultValue;
    }

    protected List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack drop = this.getPickBlock(null, null);
        if ((drop = this.adjustDrop(drop, wrench)) == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(drop);
    }

    protected List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    protected float getHardness() {
        return this.teBlock.getHardness();
    }

    protected float getExplosionResistance(Entity exploder, Explosion explosion) {
        return this.teBlock.getExplosionResistance();
    }

    protected boolean canEntityDestroy(Entity entity) {
        return true;
    }

    public EnumFacing getFacing() {
        return EnumFacing.field_82609_l[this.facing];
    }

    protected boolean setFacingWrench(EnumFacing facing, EntityPlayer player) {
        if (!this.teBlock.allowWrenchRotating()) {
            return false;
        }
        if (facing == this.getFacing()) {
            return false;
        }
        if (!this.getSupportedFacings().contains(facing)) {
            return false;
        }
        this.setFacing(facing);
        return true;
    }

    protected boolean wrenchCanRemove(EntityPlayer player) {
        return true;
    }

    protected List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(this.getSelfDrops(fortune, true));
        ret.addAll(this.getAuxDrops(fortune));
        return ret;
    }

    protected EnumPlantType getPlantType() {
        return noCrop;
    }

    protected SoundType getBlockSound(Entity entity) {
        return SoundType.field_185851_d;
    }

    protected EnumFacing getPlacementFacing(EntityLivingBase placer, EnumFacing facing) {
        Set<EnumFacing> supportedFacings = this.getSupportedFacings();
        if (supportedFacings.isEmpty()) {
            return EnumFacing.DOWN;
        }
        if (placer == null) {
            return facing != null && supportedFacings.contains(facing.func_176734_d()) ? facing.func_176734_d() : this.getSupportedFacings().iterator().next();
        }
        Vec3d dir = placer.func_70040_Z();
        EnumFacing bestFacing = null;
        double maxMatch = Double.NEGATIVE_INFINITY;
        for (EnumFacing cFacing : supportedFacings) {
            double match = dir.func_72430_b(new Vec3d(cFacing.func_176734_d().func_176730_m()));
            if (!(match > maxMatch)) continue;
            maxMatch = match;
            bestFacing = cFacing;
        }
        return bestFacing;
    }

    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return defaultAabbs;
    }

    protected ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                case Self: {
                    break;
                }
                case None: {
                    drop = null;
                    break;
                }
                case Generator: {
                    drop = BlockName.te.getItemStack(TeBlock.generator);
                    break;
                }
                case Machine: {
                    drop = BlockName.resource.getItemStack(ResourceBlock.machine);
                    break;
                }
                case AdvMachine: {
                    drop = BlockName.resource.getItemStack(ResourceBlock.advanced_machine);
                }
            }
        }
        return drop;
    }

    protected Set<EnumFacing> getSupportedFacings() {
        return this.teBlock.getSupportedFacings();
    }

    protected void setFacing(EnumFacing facing) {
        if (facing == null) {
            throw new NullPointerException("null facing");
        }
        if (this.facing == facing.ordinal()) {
            throw new IllegalArgumentException("unchanged facing");
        }
        if (!this.getSupportedFacings().contains(facing)) {
            throw new IllegalArgumentException("invalid facing: " + facing + ", supported: " + this.getSupportedFacings());
        }
        this.facing = (byte)facing.ordinal();
        if (!this.func_145831_w().field_72995_K) {
            IC2.network.get(true).updateTileEntityField(this, "facing");
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        IC2.network.get(true).updateTileEntityField(this, "active");
    }

    @Override
    public boolean getGuiState(String name) {
        if ("active".equals(name)) {
            return this.getActive();
        }
        throw new IllegalArgumentException("Unexpected GUI value requested: " + name);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (this.capabilityComponents == null) {
            return false;
        }
        TileEntityComponent comp = this.capabilityComponents.get(capability);
        if (comp == null) {
            return false;
        }
        return comp.getProvidedCapabilities(facing).contains(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.capabilityComponents == null) {
            return (T)super.getCapability(capability, facing);
        }
        TileEntityComponent comp = this.capabilityComponents.get(capability);
        if (comp == null) {
            return (T)super.getCapability(capability, facing);
        }
        return comp.getCapability(capability, facing);
    }

    protected final <T extends TileEntityComponent> T addComponent(T component) {
        TileEntityComponent prev;
        if (component == null) {
            throw new NullPointerException("null component");
        }
        if (this.components == null) {
            this.components = new IdentityHashMap<Class<? extends TileEntityComponent>, TileEntityComponent>(4);
        }
        if ((prev = this.components.put(component.getClass(), component)) != null) {
            throw new RuntimeException("conflicting component while adding " + component + ", already used by " + prev + ".");
        }
        for (Capability<?> cap : component.getProvidedCapabilities(null)) {
            this.addComponentCapability(cap, component);
        }
        return component;
    }

    public boolean hasComponent(Class<? extends TileEntityComponent> cls) {
        if (this.components == null) {
            return false;
        }
        return this.components.containsKey(cls);
    }

    public <T extends TileEntityComponent> T getComponent(Class<T> cls) {
        if (this.components == null) {
            return null;
        }
        return (T)this.components.get(cls);
    }

    public final Iterable<? extends TileEntityComponent> getComponents() {
        if (this.components == null) {
            return emptyComponents;
        }
        return this.components.values();
    }

    private void addComponentCapability(Capability<?> cap, TileEntityComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        TileEntityComponent prev = this.capabilityComponents.put(cap, component);
        assert (prev == null);
    }

    protected final void rerender() {
        IBlockState state = this.getBlockState();
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private final synchronized boolean requiresWorldTick() {
        Class<?> cls = this.getClass();
        TickSubscription subscription = tickSubscriptions.get(cls);
        if (subscription == null) {
            boolean hasUpdateClient = false;
            boolean hasUpdateServer = false;
            boolean isClient = FMLCommonHandler.instance().getSide().isClient();
            while (cls != TileEntityBlock.class && (!hasUpdateClient && isClient || !hasUpdateServer)) {
                boolean found;
                if (!hasUpdateClient && isClient) {
                    found = true;
                    try {
                        cls.getDeclaredMethod("updateEntityClient", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        found = false;
                    }
                    if (found) {
                        hasUpdateClient = true;
                    }
                }
                if (!hasUpdateServer) {
                    found = true;
                    try {
                        cls.getDeclaredMethod("updateEntityServer", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        found = false;
                    }
                    if (found) {
                        hasUpdateServer = true;
                    }
                }
                cls = cls.getSuperclass();
            }
            subscription = hasUpdateClient ? (hasUpdateServer ? TickSubscription.Both : TickSubscription.Client) : (hasUpdateServer ? TickSubscription.Server : TickSubscription.None);
            tickSubscriptions.put(this.getClass(), subscription);
        }
        if (this.func_145831_w().field_72995_K) {
            return subscription == TickSubscription.Both || subscription == TickSubscription.Client;
        }
        return subscription == TickSubscription.Both || subscription == TickSubscription.Server;
    }

    private static enum TickSubscription {
        None,
        Client,
        Server,
        Both;

    }
}

