/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.jetpack;

import ic2.api.item.ElectricItem;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import ic2.core.item.armor.jetpack.JetpackHandler;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class JetpackAttachmentRecipe
implements IRecipe {
    private final IRecipeInput attachmentPlate = Recipes.inputFactory.forStack(ItemName.crafting.getItemStack(CraftingItemType.jetpack_attachment_plate));
    public static final Set<Item> blacklistedItems = new HashSet<Item>();

    JetpackAttachmentRecipe() {
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.func_77572_b(inv) != StackUtil.emptyStack;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack jetpack = null;
        ItemStack armor = null;
        boolean attachmentPlate = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (StackUtil.isEmpty(currentStack)) continue;
            Item item = currentStack.func_77973_b();
            if (item == ItemName.jetpack_electric.getInstance()) {
                if (jetpack != null) {
                    return StackUtil.emptyStack;
                }
                jetpack = currentStack;
                continue;
            }
            if (EntityLiving.func_184640_d((ItemStack)currentStack) == EntityEquipmentSlot.CHEST && !blacklistedItems.contains(item)) {
                if (armor != null) {
                    return StackUtil.emptyStack;
                }
                armor = currentStack;
                continue;
            }
            if (this.attachmentPlate.matches(currentStack)) {
                if (attachmentPlate) {
                    return StackUtil.emptyStack;
                }
                attachmentPlate = true;
                continue;
            }
            return StackUtil.emptyStack;
        }
        if (jetpack == null || armor == null || !attachmentPlate || JetpackHandler.hasJetpackAttached(armor)) {
            return StackUtil.emptyStack;
        }
        ItemStack ret = armor.func_77946_l();
        JetpackHandler.setJetpackAttached(ret, true);
        ElectricItem.manager.charge(ret, ElectricItem.manager.getCharge(jetpack), Integer.MAX_VALUE, true, false);
        return ret;
    }

    public int func_77570_a() {
        return 3;
    }

    public ItemStack func_77571_b() {
        return StackUtil.emptyStack;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    static {
        blacklistedItems.add((Item)ItemName.jetpack.getInstance());
        blacklistedItems.add((Item)ItemName.jetpack_electric.getInstance());
        blacklistedItems.add((Item)ItemName.quantum_chestplate.getInstance());
    }
}

