/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import com.google.common.collect.Iterables;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.IRecipeInputFactory;
import ic2.core.recipe.RecipeInputFluidContainer;
import ic2.core.recipe.RecipeInputItemStack;
import ic2.core.recipe.RecipeInputMultiple;
import ic2.core.recipe.RecipeInputOreDict;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class RecipeInputFactory
implements IRecipeInputFactory {
    @Override
    public IRecipeInput forStack(ItemStack stack) {
        return new RecipeInputItemStack(stack);
    }

    @Override
    public IRecipeInput forStack(ItemStack stack, int amount) {
        return new RecipeInputItemStack(stack, amount);
    }

    @Override
    public IRecipeInput forOreDict(String name) {
        return new RecipeInputOreDict(name);
    }

    @Override
    public IRecipeInput forOreDict(String name, int amount) {
        return new RecipeInputOreDict(name, amount);
    }

    @Override
    public IRecipeInput forOreDict(String name, int amount, int metaOverride) {
        return new RecipeInputOreDict(name, amount, metaOverride);
    }

    @Override
    public IRecipeInput forFluidContainer(Fluid fluid) {
        return new RecipeInputFluidContainer(fluid);
    }

    @Override
    public IRecipeInput forFluidContainer(Fluid fluid, int amount) {
        return new RecipeInputFluidContainer(fluid, amount);
    }

    @Override
    public IRecipeInput forAny(IRecipeInput ... options) {
        return new RecipeInputMultiple(options);
    }

    @Override
    public IRecipeInput forAny(Iterable<IRecipeInput> options) {
        if (options instanceof Collection) {
            return new RecipeInputMultiple(((Collection)options).toArray(new IRecipeInput[0]));
        }
        return new RecipeInputMultiple((IRecipeInput[])Iterables.toArray(options, IRecipeInput.class));
    }
}

