/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.model;

import ic2.core.block.state.Ic2BlockState;
import ic2.core.model.BasicBakedBlockModel;
import ic2.core.util.Util;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelComparator {
    private static final EnumFacing[] facings = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    private static final ConcurrentMap<CacheKey, CacheResult> cache = new ConcurrentHashMap<CacheKey, CacheResult>();

    public static boolean isEqual(IBlockState stateA, IBlockState stateB, World world, BlockPos pos) {
        CacheResult cacheResult;
        CacheKey cacheKey;
        assert (stateA != stateB);
        byte renderMask = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            boolean renderB;
            boolean renderA = stateA.func_185894_c((IBlockAccess)world, pos, facing);
            if (renderA != (renderB = stateB.func_185894_c((IBlockAccess)world, pos, facing))) {
                return false;
            }
            if (!renderA) continue;
            renderMask = (byte)(renderMask | 1 << facing.ordinal());
        }
        if (stateA.getClass() == stateB.getClass() && (stateA.getClass() == BlockStateContainer.StateImplementation.class || stateA instanceof Ic2BlockState.Ic2BlockStateInstance && !((Ic2BlockState.Ic2BlockStateInstance)stateA).hasExtraProperties() && !((Ic2BlockState.Ic2BlockStateInstance)stateB).hasExtraProperties() || stateA instanceof IExtendedBlockState && ((IExtendedBlockState)stateA).getClean() == stateA && ((IExtendedBlockState)stateB).getClean() == stateB)) {
            cacheKey = new CacheKey(stateA, stateB, renderMask);
            cacheResult = (CacheResult)((Object)cache.get(cacheKey));
            if (cacheResult != null) {
                if (cacheResult != CacheResult.UNCACHEABLE) {
                    return cacheResult == CacheResult.EQUAL;
                }
                cacheKey = null;
            }
        } else {
            cacheKey = null;
            cacheResult = CacheResult.UNCACHEABLE;
        }
        assert (cacheResult == null || cacheResult == CacheResult.UNCACHEABLE);
        BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel modelA = renderer.func_184389_a(stateA);
        IBakedModel modelB = renderer.func_184389_a(stateB);
        Class<?> modelCls = modelA.getClass();
        if (modelB.getClass() != modelCls) {
            if (cacheKey != null) {
                cache.putIfAbsent(cacheKey, CacheResult.NOT_EQUAL);
            }
            return false;
        }
        if (cacheResult == null && modelCls != SimpleBakedModel.class && modelCls != BasicBakedBlockModel.class && !modelCls.getName().equals("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper$1")) {
            if (Util.inDev()) assert (false);
            cacheResult = CacheResult.UNCACHEABLE;
        }
        long rand = MathHelper.func_180186_a((Vec3i)pos);
        boolean ret = true;
        block1: for (EnumFacing facing : facings) {
            if (facing != null && (renderMask & 1 << facing.ordinal()) == 0) continue;
            List quadsA = modelA.func_188616_a(stateA, facing, rand);
            List quadsB = modelB.func_188616_a(stateB, facing, rand);
            if (quadsA.size() != quadsB.size()) {
                ret = false;
                break;
            }
            if (quadsA.isEmpty()) continue;
            for (int i = 0; i < quadsA.size(); ++i) {
                if (Arrays.equals(((BakedQuad)quadsA.get(i)).func_178209_a(), ((BakedQuad)quadsB.get(i)).func_178209_a())) continue;
                ret = false;
                continue block1;
            }
        }
        if (cacheKey != null) {
            if (cacheResult == null) {
                cacheResult = ret ? CacheResult.EQUAL : CacheResult.NOT_EQUAL;
            }
            cache.putIfAbsent(cacheKey, cacheResult);
        }
        return ret;
    }

    public static void onReload() {
        cache.clear();
    }

    private static enum CacheResult {
        EQUAL,
        NOT_EQUAL,
        UNCACHEABLE;

    }

    private static class CacheKey {
        private final IBlockState stateA;
        private final IBlockState stateB;
        private final byte renderMask;

        CacheKey(IBlockState stateA, IBlockState stateB, byte renderMask) {
            this.stateA = stateA;
            this.stateB = stateB;
            this.renderMask = renderMask;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != CacheKey.class) {
                return false;
            }
            CacheKey o = (CacheKey)obj;
            return this.renderMask == o.renderMask && (this.stateA == o.stateA && this.stateB == o.stateB || this.stateA == o.stateB && this.stateB == o.stateA);
        }

        public int hashCode() {
            return (System.identityHashCode(this.stateA) ^ System.identityHashCode(this.stateB)) + this.renderMask;
        }
    }
}

