/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ICustomDamageItem;
import ic2.core.item.ItemIC2;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGradualInt
extends ItemIC2
implements ICustomDamageItem {
    private static final boolean alwaysShowDurability = true;
    private static final String nbtKey = "advDmg";
    private final int maxDamage;

    public ItemGradualInt(ItemName name, int maxDamage) {
        super(name);
        this.setNoRepair();
        this.maxDamage = maxDamage;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack);
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(nbtKey);
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.maxDamage;
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74768_a(nbtKey, damage);
        int maxStackDamage = stack.func_77958_k();
        if (maxStackDamage > 2) {
            stack.func_77964_b(1 + (int)Util.map(damage, this.maxDamage, maxStackDamage - 2));
        }
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        this.setCustomDamage(stack, this.getCustomDamage(stack) + damage);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        ItemStack stack = new ItemStack(item);
        this.setCustomDamage(stack, 0);
        subItems.add((Object)stack);
    }
}

