/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.gui;

import ic2.core.GuiIC2;
import ic2.core.IC2;
import ic2.core.block.machine.container.ContainerWeightedFluidDistributor;
import ic2.core.block.machine.tileentity.TileEntityWeightedFluidDistributor;
import ic2.core.gui.IClickHandler;
import ic2.core.gui.IEnableHandler;
import ic2.core.gui.MouseButton;
import ic2.core.gui.TankGauge;
import ic2.core.gui.Text;
import ic2.core.gui.VanillaButton;
import ic2.core.gui.dynamic.TextProvider;
import java.util.List;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class GuiWeightedFluidDistributor
extends GuiIC2<ContainerWeightedFluidDistributor> {
    protected final StickyButton[][] buttons;

    public GuiWeightedFluidDistributor(ContainerWeightedFluidDistributor container) {
        super(container, 211);
        this.addElement(TankGauge.createPlain(this, 33, 111, 110, 10, (IFluidTank)((TileEntityWeightedFluidDistributor)container.base).fluidTank));
        this.buttons = new StickyButton[5][6];
        for (int y = 0; y < 5; ++y) {
            TextProvider.ITextProvider text;
            final int row = y;
            for (int col = 0; col < 6; ++col) {
                final EnumFacing facing = EnumFacing.func_82600_a((int)GuiWeightedFluidDistributor.facingOffset(col));
                StickyButton stickyButton = new StickyButton(63 + col * 18, 17 + y * 18, 16, 16, new IClickHandler(){

                    private void rebalance(int change) {
                        block0: for (int i = change + 1; i < GuiWeightedFluidDistributor.this.buttons.length; ++i) {
                            for (int side = 0; side < 6; ++side) {
                                StickyButton button = GuiWeightedFluidDistributor.this.buttons[i][side];
                                if (!button.isOn()) continue;
                                GuiWeightedFluidDistributor.this.buttons[i - 1][side].setOn(true);
                                button.setOn(false);
                                continue block0;
                            }
                        }
                    }

                    private int findNextEmptyRow(int start) {
                        while (start-- > 0) {
                            for (StickyButton button : GuiWeightedFluidDistributor.this.buttons[start]) {
                                if (!button.isOn()) continue;
                                return start + 1;
                            }
                        }
                        return 0;
                    }

                    @Override
                    public void onClick(MouseButton mouse) {
                        boolean switchingOff = false;
                        int aim = GuiWeightedFluidDistributor.buttonOffset(facing.func_176745_a());
                        for (int i = 0; i < GuiWeightedFluidDistributor.this.buttons.length; ++i) {
                            if (!GuiWeightedFluidDistributor.this.buttons[i][aim].isOn()) continue;
                            GuiWeightedFluidDistributor.this.buttons[i][aim].setOn(false);
                            switchingOff = i == row;
                            this.rebalance(i);
                            break;
                        }
                        if (!switchingOff) {
                            StickyButton[] switches = GuiWeightedFluidDistributor.this.buttons[this.findNextEmptyRow(row)];
                            int aim2 = GuiWeightedFluidDistributor.buttonOffset(facing.func_176745_a());
                            for (int i = 0; i < switches.length; ++i) {
                                switches[i].setOn(i == aim2);
                            }
                        }
                        List<EnumFacing> priorities = ((TileEntityWeightedFluidDistributor)((ContainerWeightedFluidDistributor)((Object)GuiWeightedFluidDistributor.this.getContainer())).base).getPriority();
                        priorities.clear();
                        block2: for (StickyButton[] switches : GuiWeightedFluidDistributor.this.buttons) {
                            for (int i = 0; i < switches.length; ++i) {
                                if (!switches[i].isOn()) continue;
                                priorities.add(EnumFacing.func_82600_a((int)GuiWeightedFluidDistributor.facingOffset(i)));
                                continue block2;
                            }
                        }
                        System.out.println("Made new list of " + priorities);
                        IC2.network.get(false).updateTileEntityField((TileEntity)((ContainerWeightedFluidDistributor)((Object)GuiWeightedFluidDistributor.this.getContainer())).base, "priority");
                    }
                }).withDisableHandler(new IEnableHandler(){

                    @Override
                    public boolean isEnabled() {
                        return ((TileEntityWeightedFluidDistributor)((ContainerWeightedFluidDistributor)((Object)GuiWeightedFluidDistributor.this.getContainer())).base).getFacing() != facing;
                    }
                }).withText(facing.func_176610_l().substring(0, 1).toUpperCase(Locale.ENGLISH)).withTooltip(GuiWeightedFluidDistributor.getNameForFacing(facing));
                this.buttons[y][col] = stickyButton;
                this.addElement(stickyButton);
            }
            switch (y) {
                case 0: {
                    text = TextProvider.ofTranslated("ic2.WeightedFluidDistributor.gui.highest");
                    break;
                }
                case 1: {
                    text = TextProvider.of("\u2191");
                    break;
                }
                case 2: {
                    text = TextProvider.ofTranslated("ic2.WeightedFluidDistributor.gui.priority");
                    break;
                }
                case 3: {
                    text = TextProvider.of("\u2193");
                    break;
                }
                case 4: {
                    text = TextProvider.ofTranslated("ic2.WeightedFluidDistributor.gui.lowest");
                    break;
                }
                default: {
                    throw new IllegalStateException("Ended up being on y=" + y);
                }
            }
            this.addElement(Text.create(this, 8, 21 + y * 18, text, 0x404040, false));
        }
        int end = 0;
        System.out.println(((TileEntityWeightedFluidDistributor)container.base).getPriority());
        for (EnumFacing side : ((TileEntityWeightedFluidDistributor)container.base).getPriority()) {
            this.buttons[end++][GuiWeightedFluidDistributor.buttonOffset(side.func_176745_a())].setOn(true);
        }
    }

    static int facingOffset(int facing) {
        return (facing + 1) % 6;
    }

    static int buttonOffset(int facing) {
        return (facing + 5) % 6;
    }

    private static String getNameForFacing(EnumFacing facing) {
        switch (facing) {
            case WEST: {
                return "ic2.dir.West";
            }
            case EAST: {
                return "ic2.dir.East";
            }
            case DOWN: {
                return "ic2.dir.Bottom";
            }
            case UP: {
                return "ic2.dir.Top";
            }
            case NORTH: {
                return "ic2.dir.North";
            }
            case SOUTH: {
                return "ic2.dir.South";
            }
        }
        throw new IllegalStateException("Unexpected direction: " + facing);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("ic2", "textures/gui/GUIWeightedFluidDistributor.png");
    }

    public class StickyButton
    extends VanillaButton {
        protected boolean isOn;

        public StickyButton(int x, int y, int width, int height, IClickHandler handler) {
            super(GuiWeightedFluidDistributor.this, x, y, width, height, handler);
            this.isOn = false;
        }

        public void setOn(boolean on) {
            this.isOn = on;
        }

        public boolean isOn() {
            return this.isOn;
        }

        @Override
        public StickyButton withDisableHandler(IEnableHandler handler) {
            super.withDisableHandler(handler);
            return this;
        }

        @Override
        public StickyButton withText(String text) {
            super.withText(text);
            return this;
        }

        @Override
        public StickyButton withTooltip(String tooltip) {
            super.withTooltip(tooltip);
            return this;
        }

        @Override
        protected boolean isActive(int mouseX, int mouseY) {
            return this.isOn || super.isActive(mouseX, mouseY);
        }
    }
}

