/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import ic2.api.energy.prefab.BasicEnergyTile;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.ILocatable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BasicSink
extends BasicEnergyTile
implements IEnergySink {
    protected int tier;

    public BasicSink(TileEntity parent, double capacity, int tier) {
        super(parent, capacity);
        this.tier = tier;
    }

    public BasicSink(ILocatable parent, double capacity, int tier) {
        super(parent, capacity);
        this.tier = tier;
    }

    public BasicSink(World world, BlockPos pos, double capacity, int tier) {
        super(world, pos, capacity);
        this.tier = tier;
    }

    public void setSinkTier(int tier) {
        this.tier = tier;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return Math.max(0.0, this.capacity - this.energyStored);
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.energyStored += amount;
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    protected String getNbtTagName() {
        return "IC2BasicSink";
    }
}

