/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.google.common.base.Predicate;
import ic2.core.IC2;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.PositionSpec;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.item.tool.ItemToolCrafting;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemToolCutter
extends ItemToolCrafting {
    public ItemToolCutter() {
        super(ItemName.cutter, 60);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            Predicate<ItemStack> request = StackUtil.sameStack(ItemName.crafting.getItemStack(CraftingItemType.rubber));
            if (StackUtil.consumeFromPlayerInventory(player, request, 1, true) && cable.tryAddInsulation()) {
                StackUtil.consumeFromPlayerInventory(player, request, 1, false);
                StackUtil.damageOrError(player, hand, 1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean removeInsulation(EntityPlayer player, EnumHand hand, TileEntityCable cable) {
        if (cable.tryRemoveInsulation(true) && StackUtil.damage(player, hand, StackUtil.sameItem(this), 3)) {
            cable.tryRemoveInsulation(false);
            if (cable.func_145831_w().field_72995_K) {
                IC2.audioManager.playOnce(new AudioPosition(cable.func_145831_w(), cable.func_174877_v()), PositionSpec.Center, "Tools/InsulationCutters.ogg", true, IC2.audioManager.getDefaultVolume());
            } else {
                StackUtil.dropAsEntity(cable.func_145831_w(), cable.func_174877_v(), ItemName.crafting.getItemStack(CraftingItemType.rubber));
            }
            return true;
        }
        return false;
    }
}

