/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.prefab.BasicEnergyTile;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.ILocatable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BasicSinkSource
extends BasicEnergyTile
implements IEnergySink,
IEnergySource {
    protected int sinkTier;
    protected int sourceTier;

    public BasicSinkSource(TileEntity parent, double capacity, int sinkTier, int sourceTier) {
        super(parent, capacity);
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        double power = EnergyNet.instance.getPowerFromTier(sourceTier);
        if (this.getCapacity() < power) {
            this.setCapacity(power);
        }
    }

    public BasicSinkSource(ILocatable parent, double capacity, int sinkTier, int sourceTier) {
        super(parent, capacity);
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        double power = EnergyNet.instance.getPowerFromTier(sourceTier);
        if (this.getCapacity() < power) {
            this.setCapacity(power);
        }
    }

    public BasicSinkSource(World world, BlockPos pos, double capacity, int sinkTier, int sourceTier) {
        super(world, pos, capacity);
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        double power = EnergyNet.instance.getPowerFromTier(sourceTier);
        if (this.getCapacity() < power) {
            this.setCapacity(power);
        }
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public void setSourceTier(int tier) {
        double power = EnergyNet.instance.getPowerFromTier(tier);
        if (this.getCapacity() < power) {
            this.setCapacity(power);
        }
        this.sourceTier = tier;
    }

    @Override
    public double getDemandedEnergy() {
        return Math.max(0.0, this.capacity - this.energyStored);
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.energyStored += amount;
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return this.sinkTier;
    }

    @Override
    public double getOfferedEnergy() {
        return this.energyStored;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energyStored -= amount;
    }

    @Override
    public int getSourceTier() {
        return this.sourceTier;
    }

    @Override
    protected String getNbtTagName() {
        return "IC2BasicSinkSource";
    }
}

