/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import com.google.common.base.Function;
import ic2.core.IC2;
import ic2.core.init.Localization;
import ic2.core.ref.IItemModelProvider;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIC2
extends Item
implements IItemModelProvider {
    private EnumRarity rarity = EnumRarity.COMMON;
    private Map<Capability<?>, Function<ItemStack, ?>> caps;

    public ItemIC2(ItemName name) {
        this.func_77637_a(IC2.tabIC2);
        if (name != null) {
            this.func_77655_b(name.name());
            GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)IC2.getIdentifier(name.name()));
            name.setInstance(this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        this.registerModel(0, name, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, ItemName name, String extraName) {
        ItemIC2.registerModel(this, meta, name, extraName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, ItemName name, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemIC2.getModelLocation(name, extraName));
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(ItemName name, String extraName) {
        StringBuilder loc = new StringBuilder();
        loc.append("ic2");
        loc.append(':');
        loc.append(name.getPath(extraName));
        return new ModelResourceLocation(loc.toString(), null);
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77657_g(ItemStack stack) {
        return this.func_77667_c(stack);
    }

    public String func_77653_i(ItemStack stack) {
        return Localization.translate(this.func_77667_c(stack));
    }

    public ItemIC2 setRarity(EnumRarity rarity) {
        if (rarity == null) {
            throw new NullPointerException("null rarity");
        }
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77948_v() && this.rarity != EnumRarity.EPIC) {
            return EnumRarity.RARE;
        }
        return this.rarity;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ItemIC2.shouldReequip(oldStack, newStack, slotChanged);
    }

    public static boolean shouldReequip(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!StackUtil.checkItemEquality(newStack, oldStack)) {
            return true;
        }
        if (oldStack == null) {
            return false;
        }
        if (StackUtil.getSize(oldStack) != StackUtil.getSize(newStack)) {
            return true;
        }
        return slotChanged && StackUtil.checkItemEqualityStrict(oldStack, newStack);
    }

    protected static int getRemainingUses(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i() + 1;
    }

    public <T> void addCapability(Capability<T> cap, Function<ItemStack, T> lookup) {
        if (this.caps == null) {
            this.caps = new HashMap();
        }
        assert (!this.caps.containsKey(cap));
        this.caps.put(cap, lookup);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return ItemIC2.this.caps != null && ItemIC2.this.caps.containsKey(capability);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(ItemIC2.this.caps == null || !ItemIC2.this.caps.containsKey(capability) ? null : ((Function)ItemIC2.this.caps.get(capability)).apply((Object)stack));
            }
        };
    }
}

