/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import ic2.api.recipe.IBasicMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.RecipeOutput;
import ic2.core.IC2;
import ic2.core.init.MainConfig;
import ic2.core.recipe.RecipeInputItemStack;
import ic2.core.recipe.RecipeInputOreDict;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class BasicMachineRecipeManager
implements IBasicMachineRecipeManager {
    private final Map<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipes = new HashMap<IRecipeInput, MachineRecipe<IRecipeInput, Collection<ItemStack>>>();
    private final Map<Item, List<MachineRecipe<IRecipeInput, Collection<ItemStack>>>> recipeCache = new IdentityHashMap<Item, List<MachineRecipe<IRecipeInput, Collection<ItemStack>>>>();
    private final List<MachineRecipe<IRecipeInput, Collection<ItemStack>>> uncacheableRecipes = new ArrayList<MachineRecipe<IRecipeInput, Collection<ItemStack>>>();
    private boolean oreRegisterEventSubscribed;

    @Override
    public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean replace, ItemStack ... outputs) {
        return this.addRecipe(input, (Collection<ItemStack>)Arrays.asList(outputs), metadata, replace);
    }

    @Override
    public boolean addRecipe(IRecipeInput input, Collection<ItemStack> output, NBTTagCompound metadata, boolean replace) {
        if (input == null) {
            throw new NullPointerException("null recipe input");
        }
        if (output == null) {
            throw new NullPointerException("null recipe output");
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("no outputs");
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(output.size());
        for (ItemStack stack : output) {
            if (StackUtil.isEmpty(stack)) {
                this.displayError("The output ItemStack " + StackUtil.toStringSafe(stack) + " is invalid.");
                return false;
            }
            if (input.matches(stack) && (metadata == null || !metadata.func_74764_b("ignoreSameInputOutput"))) {
                this.displayError("The output ItemStack " + stack.toString() + " is the same as the recipe input " + input + ".");
                return false;
            }
            items.add(stack.func_77946_l());
        }
        for (ItemStack is : input.getInputs()) {
            MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe = this.getRecipe(is);
            if (recipe == null) continue;
            if (replace) {
                do {
                    this.recipes.remove(input);
                    this.removeCachedRecipes(input);
                } while ((recipe = this.getRecipe(is)) != null);
                continue;
            }
            return false;
        }
        MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe = new MachineRecipe<IRecipeInput, Collection<ItemStack>>(input, items, metadata);
        this.recipes.put(input, recipe);
        this.addToCache(recipe);
        return true;
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
        MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe = this.getRecipe(input);
        if (recipe == null) {
            return null;
        }
        if (!(StackUtil.getSize(input) < recipe.getInput().getAmount() || input.func_77973_b().hasContainerItem(input) && StackUtil.getSize(input) != recipe.getInput().getAmount())) {
            if (adjustInput) {
                if (input.func_77973_b().hasContainerItem(input)) {
                    throw new UnsupportedOperationException("can't adjust input item, use apply() instead");
                }
                input.func_190918_g(recipe.getInput().getAmount());
            }
            return new RecipeOutput(recipe.getMetaData(), new ArrayList<ItemStack>(recipe.getOutput()));
        }
        return null;
    }

    @Override
    public MachineRecipeResult<IRecipeInput, Collection<ItemStack>, ItemStack> apply(ItemStack input, boolean acceptTest) {
        ItemStack adjustedInput;
        if (StackUtil.isEmpty(input)) {
            return null;
        }
        MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe = this.getRecipe(input);
        if (recipe == null) {
            return null;
        }
        if (StackUtil.getSize(input) < recipe.getInput().getAmount()) {
            return null;
        }
        if (input.func_77973_b().hasContainerItem(input) && !StackUtil.isEmpty(adjustedInput = input.func_77973_b().getContainerItem(input))) {
            if (StackUtil.getSize(input) != recipe.getInput().getAmount()) {
                return null;
            }
            adjustedInput = StackUtil.copy(input);
        } else {
            adjustedInput = StackUtil.copyWithSize(input, StackUtil.getSize(input) - recipe.getInput().getAmount());
        }
        return recipe.getResult(adjustedInput);
    }

    @Override
    public Iterable<? extends MachineRecipe<IRecipeInput, Collection<ItemStack>>> getRecipes() {
        return new Iterable<MachineRecipe<IRecipeInput, Collection<ItemStack>>>(){

            @Override
            public Iterator<MachineRecipe<IRecipeInput, Collection<ItemStack>>> iterator() {
                return new Iterator<MachineRecipe<IRecipeInput, Collection<ItemStack>>>(){
                    private final Iterator<MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipeIt;
                    private IRecipeInput lastInput;
                    {
                        this.recipeIt = BasicMachineRecipeManager.this.recipes.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.recipeIt.hasNext();
                    }

                    @Override
                    public MachineRecipe<IRecipeInput, Collection<ItemStack>> next() {
                        MachineRecipe<IRecipeInput, Collection<ItemStack>> next = this.recipeIt.next();
                        this.lastInput = next.getInput();
                        return next;
                    }

                    @Override
                    public void remove() {
                        this.recipeIt.remove();
                        BasicMachineRecipeManager.this.removeCachedRecipes(this.lastInput);
                    }
                };
            }
        };
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @SubscribeEvent
    public void onOreRegister(OreDictionary.OreRegisterEvent event) {
        Item item = event.getOre().func_77973_b();
        if (item == null) {
            IC2.log.warn(LogCategory.Recipe, "Found null item ore dict registration.", new Throwable());
            return;
        }
        for (MachineRecipe<IRecipeInput, Collection<ItemStack>> rawRecipe : this.recipes.values()) {
            if (rawRecipe.getInput().getClass() != RecipeInputOreDict.class) continue;
            RecipeInputOreDict recipe = (RecipeInputOreDict)rawRecipe.getInput();
            if (!recipe.input.equals(event.getName())) continue;
            this.addToCache(item, rawRecipe);
        }
    }

    private MachineRecipe<IRecipeInput, Collection<ItemStack>> getRecipe(ItemStack input) {
        if (StackUtil.isEmpty(input)) {
            return null;
        }
        List<MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipes = this.recipeCache.get(input.func_77973_b());
        if (recipes != null) {
            for (MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe : recipes) {
                if (!recipe.getInput().matches(input)) continue;
                return recipe;
            }
        }
        for (MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe : this.uncacheableRecipes) {
            if (!recipe.getInput().matches(input)) continue;
            return recipe;
        }
        return null;
    }

    private void addToCache(MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe) {
        Collection<Item> items = this.getItemsFromRecipe(recipe.getInput());
        if (items != null) {
            for (Item item : items) {
                this.addToCache(item, recipe);
            }
            if (recipe.getInput().getClass() == RecipeInputOreDict.class && !this.oreRegisterEventSubscribed) {
                MinecraftForge.EVENT_BUS.register((Object)this);
                this.oreRegisterEventSubscribed = true;
            }
        } else {
            this.uncacheableRecipes.add(recipe);
        }
    }

    private void addToCache(Item item, MachineRecipe<IRecipeInput, Collection<ItemStack>> recipe) {
        List<MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipes = this.recipeCache.get(item);
        if (recipes == null) {
            recipes = new ArrayList<MachineRecipe<IRecipeInput, Collection<ItemStack>>>();
            this.recipeCache.put(item, recipes);
        }
        if (!recipes.contains(recipe)) {
            recipes.add(recipe);
        }
    }

    private void removeCachedRecipes(IRecipeInput input) {
        Collection<Item> items = this.getItemsFromRecipe(input);
        if (items != null) {
            for (Item item : items) {
                List<MachineRecipe<IRecipeInput, Collection<ItemStack>>> recipes = this.recipeCache.get(item);
                if (recipes == null) {
                    IC2.log.warn(LogCategory.Recipe, "Inconsistent recipe cache, the entry for the item " + item + " is missing.");
                    continue;
                }
                recipes.remove(input);
                if (!recipes.isEmpty()) continue;
                this.recipeCache.remove(item);
            }
        } else {
            Iterator<MachineRecipe<IRecipeInput, Collection<ItemStack>>> it = this.uncacheableRecipes.iterator();
            while (it.hasNext()) {
                MachineRecipe<IRecipeInput, Collection<ItemStack>> data = it.next();
                if (data.getInput() != input) continue;
                it.remove();
            }
        }
    }

    private Collection<Item> getItemsFromRecipe(IRecipeInput recipe) {
        Class<?> recipeClass = recipe.getClass();
        if (recipeClass == RecipeInputItemStack.class || recipeClass == RecipeInputOreDict.class) {
            List<ItemStack> inputs = recipe.getInputs();
            Set<Item> ret = Collections.newSetFromMap(new IdentityHashMap(inputs.size()));
            for (ItemStack stack : inputs) {
                ret.add(stack.func_77973_b());
            }
            return ret;
        }
        return null;
    }

    private void displayError(String msg) {
        if (!MainConfig.ignoreInvalidRecipes) {
            throw new RuntimeException(msg);
        }
        IC2.log.warn(LogCategory.Recipe, msg);
    }
}

