/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import ic2.api.energy.tile.IKineticSource;
import ic2.api.upgrade.IUpgradableBlock;
import ic2.api.upgrade.UpgradableProperty;
import ic2.core.ContainerBase;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Fluids;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.kineticgenerator.container.ContainerSteamKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiSteamKineticGenerator;
import ic2.core.block.machine.tileentity.TileEntityCondenser;
import ic2.core.init.MainConfig;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LiquidUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySteamKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IHasGui,
IUpgradableBlock {
    protected final FluidTank steamTank;
    protected final FluidTank distilledWaterTank;
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 1);
    public final InvSlotConsumable turbineSlot = new InvSlotConsumableItemStack((TileEntityInventory)this, "Turbineslot", 1, ItemName.crafting.getItemStack(CraftingItemType.steam_turbine));
    private static final float outputModifier = ConfigUtil.getFloat(MainConfig.get(), "balance/energy/kineticgenerator/steam");
    private int kUoutput;
    private boolean isTurbineFilledWithWater = false;
    private float condensationProgress = 0.0f;
    private int updateTicker = IC2.random.nextInt(this.getTickRate());
    protected final Fluids fluids;

    public TileEntitySteamKineticGenerator() {
        this.turbineSlot.setStackSizeLimit(1);
        this.fluids = this.addComponent(new Fluids(this));
        this.steamTank = this.fluids.addTankInsert("steamTank", 21000, Fluids.fluidPredicate(FluidName.steam.getInstance(), FluidName.superheated_steam.getInstance()));
        this.distilledWaterTank = this.fluids.addTank("distilledWaterTank", 1000, Fluids.fluidPredicate(FluidName.distilled_water.getInstance(), FluidRegistry.WATER));
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.distilledWaterTank.getCapacity() - this.distilledWaterTank.getFluidAmount() >= 1 && this.isTurbineFilledWithWater) {
            this.isTurbineFilledWithWater = false;
        }
        if (this.steamTank.getFluidAmount() > 10 && !this.isTurbineFilledWithWater && !this.turbineSlot.isEmpty()) {
            if (!this.getActive()) {
                this.setActive(true);
                needsInvUpdate = true;
            }
            boolean turbineDoneWork = this.turbineDoWork();
            if (this.updateTicker++ >= this.getTickRate()) {
                if (turbineDoneWork) {
                    this.turbineSlot.damage(this.isHotSteam() ? 1 : 2, false);
                }
                this.updateTicker = 0;
            }
        } else if (this.getActive()) {
            this.setActive(false);
            needsInvUpdate = true;
            this.kUoutput = 0;
        }
        if (needsInvUpdate |= this.upgradeSlot.tickNoMark()) {
            super.func_70296_d();
        }
    }

    private float handleSteam(int amount) {
        this.steamTank.drainInternal(amount, true);
        float KUWorkbuffer = (float)(amount * 2) * (this.isHotSteam() ? 2.0f : 1.0f);
        if (this.isHotSteam()) {
            this.Steamoutput(amount);
        } else {
            this.condensationProgress += (float)amount / 100.0f * 10.0f;
            this.Steamoutput((float)amount / 100.0f * 90.0f);
        }
        return KUWorkbuffer;
    }

    private boolean turbineDoWork() {
        float KUWorkbuffer = 0.0f;
        int steamAmount = this.steamTank.getFluidAmount();
        if (steamAmount > 18000) {
            KUWorkbuffer = this.handleSteam(1000);
        } else if (steamAmount > 16000) {
            KUWorkbuffer = this.handleSteam(800);
        } else if (steamAmount > 12000) {
            KUWorkbuffer = this.handleSteam(600);
        } else if (steamAmount > 8000) {
            KUWorkbuffer = this.handleSteam(400);
        } else if (steamAmount > 4000) {
            KUWorkbuffer = this.handleSteam(200);
        } else if (steamAmount > 2000) {
            KUWorkbuffer = this.handleSteam(100);
        } else if (steamAmount > 1000) {
            KUWorkbuffer = this.handleSteam(50);
        } else if (steamAmount > 800) {
            KUWorkbuffer = this.handleSteam(40);
        } else if (steamAmount > 600) {
            KUWorkbuffer = this.handleSteam(30);
        } else if (steamAmount > 400) {
            KUWorkbuffer = this.handleSteam(20);
        } else if (steamAmount > 10) {
            KUWorkbuffer = this.handleSteam(10);
        }
        if (this.condensationProgress >= 100.0f) {
            if (this.distilledWaterTank.fillInternal(new FluidStack(FluidName.distilled_water.getInstance(), 1), false) == 1) {
                this.condensationProgress -= 100.0f;
                this.distilledWaterTank.fillInternal(new FluidStack(FluidName.distilled_water.getInstance(), 1), true);
            } else {
                this.isTurbineFilledWithWater = true;
            }
        }
        this.kUoutput = (int)(KUWorkbuffer * (100.0f - (float)this.distilledWaterTank.getFluidAmount() / (float)this.distilledWaterTank.getCapacity() * 100.0f) / 100.0f * outputModifier);
        return KUWorkbuffer > 0.0f;
    }

    private void Steamoutput(float amount) {
        World world = this.func_145831_w();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = world.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (!this.isHotSteam() ? !(te instanceof TileEntityCondenser) : !(te instanceof TileEntityCondenser) && !(te instanceof TileEntitySteamKineticGenerator)) continue;
            int transAmount = LiquidUtil.fillTile(te, dir.func_176734_d(), new FluidStack(FluidName.steam.getInstance(), (int)amount), false);
            if (transAmount > 0 && (amount -= (float)transAmount) <= 0.0f) break;
        }
        if (amount > 0.0f && world.field_73012_v.nextInt(10) == 0) {
            new ExplosionIC2(world, null, this.field_174879_c, 1, 1.0f, ExplosionIC2.Type.Heat).doExplosion();
        }
    }

    public int getKUoutput() {
        return this.kUoutput;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.condensationProgress = nbttagcompound.func_74760_g("condensationprogress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("condensationprogress", this.condensationProgress);
        return nbt;
    }

    public ContainerBase<TileEntitySteamKineticGenerator> getGuiContainer(EntityPlayer player) {
        return new ContainerSteamKineticGenerator(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiSteamKineticGenerator(new ContainerSteamKineticGenerator(player, this));
    }

    @Override
    public int maxrequestkineticenergyTick(EnumFacing directionFrom) {
        return directionFrom == this.getFacing() ? this.kUoutput : 0;
    }

    @Override
    public int requestkineticenergy(EnumFacing directionFrom, int requestkineticenergy) {
        return directionFrom == this.getFacing() ? this.kUoutput : 0;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public int gaugeLiquidScaled(int i, int tank) {
        if (tank == 0 && this.distilledWaterTank.getFluidAmount() > 0) {
            return this.distilledWaterTank.getFluidAmount() * i / this.distilledWaterTank.getCapacity();
        }
        return 0;
    }

    @Override
    public double getEnergy() {
        return 0.0;
    }

    @Override
    public boolean useEnergy(double amount) {
        return false;
    }

    public int getDistilledWaterTankFill() {
        return this.distilledWaterTank.getFluidAmount();
    }

    public FluidTank getDistilledWaterTank() {
        return this.distilledWaterTank;
    }

    public boolean isHotSteam() {
        return this.steamTank.getFluid() != null && this.steamTank.getFluid().getFluid() == FluidName.superheated_steam.getInstance();
    }

    public boolean hasTurbine() {
        return !this.turbineSlot.isEmpty();
    }

    public boolean isTurbineBlockedByWater() {
        return this.isTurbineFilledWithWater;
    }

    public int getTickRate() {
        return 20;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemConsuming, UpgradableProperty.FluidConsuming, UpgradableProperty.FluidProducing);
    }
}

