/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.grid;

import ic2.core.IC2;
import ic2.core.energy.grid.ChangeHandler;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.energy.grid.EnergyNetLocal;
import ic2.core.energy.grid.Grid;
import ic2.core.energy.grid.GridChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class GridUpdater
implements Runnable {
    private final EnergyNetLocal enet;
    private final List<GridChange> changes = new ArrayList<GridChange>();
    private final GridCalcTask[] calcTaskCache = new GridCalcTask[16];
    private final AtomicInteger pendingCalculations = new AtomicInteger(0);
    private boolean busy;
    private boolean isChangeStep;

    GridUpdater(EnergyNetLocal enet) {
        this.enet = enet;
    }

    void startChangeCalc(Collection<GridChange> changes) {
        assert (!changes.isEmpty());
        assert (this.changes.isEmpty());
        assert (!this.busy);
        this.busy = true;
        this.isChangeStep = true;
        this.changes.addAll(changes);
        changes.clear();
        this.prepareUpdate();
        IC2.getInstance().threadPool.execute(this);
    }

    void startTransferCalc() {
        assert (!this.busy);
        this.busy = true;
        this.isChangeStep = false;
        int cacheIdx = 0;
        this.pendingCalculations.set(this.enet.grids.size());
        for (Grid grid : this.enet.grids) {
            if (EnergyNetGlobal.getCalculator().runSyncStep(grid)) {
                GridCalcTask task;
                if (cacheIdx < this.calcTaskCache.length) {
                    task = this.calcTaskCache[cacheIdx];
                    if (task == null) {
                        this.calcTaskCache[cacheIdx] = task = new GridCalcTask();
                    }
                    ++cacheIdx;
                } else {
                    task = new GridCalcTask();
                }
                task.grid = grid;
                IC2.getInstance().threadPool.execute(task);
                continue;
            }
            this.pendingCalculations.decrementAndGet();
        }
        if (this.pendingCalculations.get() == 0) {
            this.busy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitCompletion() {
        try {
            GridUpdater gridUpdater = this;
            synchronized (gridUpdater) {
                while (this.busy) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isInChangeStep() {
        return this.isChangeStep;
    }

    @Override
    public void run() {
        this.updateGrid();
    }

    private void prepareUpdate() {
        Iterator<GridChange> it = this.changes.iterator();
        while (it.hasNext()) {
            GridChange change = it.next();
            if (ChangeHandler.prepareSync(this.enet, change)) continue;
            it.remove();
        }
    }

    private void updateGrid() {
        long startTime = 0L;
        for (GridChange change : this.changes) {
            switch (change.type) {
                case ADDITION: {
                    ChangeHandler.applyAddition(this.enet, change.ioTile, change.pos, change.subTiles);
                    break;
                }
                case REMOVAL: {
                    ChangeHandler.applyRemoval(this.enet, change.ioTile, change.pos);
                }
            }
        }
        this.changes.clear();
        this.notifyCalculator();
    }

    private void notifyCalculator() {
        ArrayList<Grid> dirtyGrids = new ArrayList<Grid>();
        for (Grid grid : this.enet.grids) {
            if (!grid.clearDirty()) continue;
            dirtyGrids.add(grid);
        }
        if (dirtyGrids.isEmpty()) {
            this.clearBusy();
            return;
        }
        this.pendingCalculations.set(dirtyGrids.size());
        if (dirtyGrids.size() > 1) {
            for (int i = 1; i < dirtyGrids.size(); ++i) {
                GridUpdateTask task = new GridUpdateTask();
                task.grid = (Grid)dirtyGrids.get(i);
                IC2.getInstance().threadPool.execute(task);
            }
        }
        EnergyNetGlobal.getCalculator().handleGridChange((Grid)dirtyGrids.get(0));
        this.onTaskDone();
    }

    private void onTaskDone() {
        if (this.pendingCalculations.decrementAndGet() == 0) {
            this.clearBusy();
        }
    }

    private synchronized void clearBusy() {
        this.busy = false;
        this.notifyAll();
    }

    private class GridCalcTask
    implements Runnable {
        Grid grid;

        private GridCalcTask() {
        }

        @Override
        public void run() {
            EnergyNetGlobal.getCalculator().runAsyncStep(this.grid);
            this.grid = null;
            GridUpdater.this.onTaskDone();
        }
    }

    private class GridUpdateTask
    implements Runnable {
        Grid grid;

        private GridUpdateTask() {
        }

        @Override
        public void run() {
            EnergyNetGlobal.getCalculator().handleGridChange(this.grid);
            this.grid = null;
            GridUpdater.this.onTaskDone();
        }
    }
}

