/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.grid;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.IEnergyNetEventReceiver;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.core.IC2;
import ic2.core.energy.grid.EnergyNetGlobal;
import ic2.core.energy.grid.EnergyNetLocal;
import ic2.core.energy.grid.Grid;
import ic2.core.energy.grid.GridChange;
import ic2.core.energy.grid.Node;
import ic2.core.energy.grid.NodeType;
import ic2.core.energy.grid.Tile;
import ic2.core.util.LogCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

class ChangeHandler {
    ChangeHandler() {
    }

    static boolean prepareSync(EnergyNetLocal enet, GridChange change) {
        World world = enet.getWorld();
        GridChange.Type type = change.type;
        IEnergyTile ioTile = change.ioTile;
        BlockPos pos = change.pos;
        if (EnergyNet.instance.getWorld(ioTile) != world) {
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s) had the wrong world in grid update (%s)", new Object[]{ioTile, pos, type});
            return false;
        }
        if (type != GridChange.Type.REMOVAL && !EnergyNet.instance.getPos(ioTile).equals((Object)change.pos)) {
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s) has the wrong position in grid update (%s)", new Object[]{ioTile, pos, type});
            return false;
        }
        if (type != GridChange.Type.REMOVAL && !world.func_175667_e(change.pos)) {
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s) was unloaded in grid update (%s)", new Object[]{ioTile, pos, type});
            return false;
        }
        if (type != GridChange.Type.REMOVAL && ioTile instanceof TileEntity && ((TileEntity)ioTile).func_145837_r()) {
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s) was invalidated in grid update (%s)", new Object[]{ioTile, pos, type});
            return false;
        }
        if (change.type == GridChange.Type.ADDITION) {
            if (ioTile instanceof IMetaDelegate) {
                change.subTiles = new ArrayList<IEnergyTile>(((IMetaDelegate)ioTile).getSubTiles());
                if (change.subTiles.isEmpty()) {
                    throw new RuntimeException("Tile " + ioTile + " (" + pos + ") must return at least 1 sub tile for IMetaDelegate.getSubTiles().");
                }
            } else {
                change.subTiles = Arrays.asList(ioTile);
            }
        }
        return true;
    }

    static void applyAddition(EnergyNetLocal enet, IEnergyTile ioTile, BlockPos pos, List<IEnergyTile> subTiles) {
        if (enet.registeredIoTiles.containsKey(ioTile)) {
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s) is already registered", ioTile, pos);
            return;
        }
        for (IEnergyTile subTile : subTiles) {
            BlockPos subPos = EnergyNet.instance.getPos(subTile);
            if (!enet.registeredTiles.containsKey(subPos)) continue;
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s), sub tile %s (%s) addition is conflicting with a previous registration at the same location", ioTile, pos, subPos, subTile);
            return;
        }
        Tile tile = new Tile(enet, ioTile, subTiles);
        enet.registeredIoTiles.put(ioTile, tile);
        for (IEnergyTile subTile : subTiles) {
            BlockPos subPos = EnergyNet.instance.getPos(subTile);
            enet.registeredTiles.put(subPos, tile);
            enet.addPositionToNotify(subPos);
        }
        ChangeHandler.addTileToGrids(enet, tile);
        for (IEnergyNetEventReceiver receiver : EnergyNetGlobal.getEventReceivers()) {
            receiver.onAdd(ioTile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addTileToGrids(EnergyNetLocal enet, Tile tile) {
        ArrayList<Node> extraNodes = new ArrayList<Node>();
        IEnergyTile ioTile = tile.getMainTile();
        block4: for (Node node : tile.nodes) {
            Grid grid;
            ArrayList<Node> neighbors = new ArrayList<Node>();
            for (IEnergyTile iEnergyTile : tile.subTiles) {
                for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                    BlockPos coords = EnergyNet.instance.getPos(iEnergyTile).func_177972_a(enumFacing);
                    Tile neighborTile = enet.registeredTiles.get(coords);
                    if (neighborTile == null || neighborTile == node.tile) continue;
                    for (Node neighbor : neighborTile.nodes) {
                        if (neighbor.isExtraNode()) continue;
                        IEnergyTile neighborIoTile = neighbor.tile.getMainTile();
                        boolean canEmit = false;
                        if ((node.nodeType == NodeType.Source || node.nodeType == NodeType.Conductor) && neighbor.nodeType != NodeType.Source) {
                            IEnergyEmitter emitter = (IEnergyEmitter)(iEnergyTile instanceof IEnergyEmitter ? iEnergyTile : ioTile);
                            IEnergyTile neighborSubTe = neighborTile.getSubTileAt(coords);
                            IEnergyAcceptor acceptor = (IEnergyAcceptor)(neighborSubTe instanceof IEnergyAcceptor ? neighborSubTe : neighborIoTile);
                            canEmit = emitter.emitsEnergyTo((IEnergyAcceptor)neighborIoTile, enumFacing) && acceptor.acceptsEnergyFrom((IEnergyEmitter)ioTile, enumFacing.func_176734_d());
                        }
                        boolean canAccept = false;
                        if (!(canEmit || node.nodeType != NodeType.Sink && node.nodeType != NodeType.Conductor || neighbor.nodeType == NodeType.Sink)) {
                            IEnergyAcceptor acceptor = (IEnergyAcceptor)(iEnergyTile instanceof IEnergyAcceptor ? iEnergyTile : ioTile);
                            IEnergyTile neighborSubTe = neighborTile.getSubTileAt(coords);
                            IEnergyEmitter emitter = (IEnergyEmitter)(neighborSubTe instanceof IEnergyEmitter ? neighborSubTe : neighborIoTile);
                            boolean bl = canAccept = acceptor.acceptsEnergyFrom((IEnergyEmitter)neighborIoTile, enumFacing) && emitter.emitsEnergyTo((IEnergyAcceptor)ioTile, enumFacing.func_176734_d());
                        }
                        if (!canEmit && !canAccept) continue;
                        neighbors.add(neighbor);
                    }
                }
            }
            if (neighbors.isEmpty()) {
                grid = new Grid(enet);
                grid.add(node, neighbors);
                continue;
            }
            switch (node.nodeType) {
                case Conductor: {
                    Node neighbor2;
                    grid = null;
                    for (Node neighbor : neighbors) {
                        if (neighbor.nodeType != NodeType.Conductor && !neighbor.links.isEmpty()) continue;
                        grid = neighbor.getGrid();
                        break;
                    }
                    if (grid == null) {
                        grid = new Grid(enet);
                    }
                    HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
                    ListIterator<Node> it = neighbors.listIterator();
                    while (it.hasNext()) {
                        Node neighbor = (Node)it.next();
                        if (neighbor.getGrid() == grid) continue;
                        if (neighbor.nodeType != NodeType.Conductor && !neighbor.links.isEmpty()) {
                            boolean found = false;
                            for (int i = 0; i < it.previousIndex(); ++i) {
                                neighbor2 = (Node)neighbors.get(i);
                                if (neighbor2.tile != neighbor.tile || neighbor2.nodeType != neighbor.nodeType || neighbor2.getGrid() != grid) continue;
                                found = true;
                                it.set(neighbor2);
                                break;
                            }
                            if (found) continue;
                            neighbor = new Node(enet.allocateNodeId(), neighbor.tile, neighbor.nodeType);
                            neighbor.tile.addExtraNode(neighbor);
                            grid.add(neighbor, Collections.<Node>emptyList());
                            it.set(neighbor);
                            assert (neighbor.getGrid() != null);
                            continue;
                        }
                        grid.merge(neighbor.getGrid(), hashMap);
                    }
                    it = neighbors.listIterator();
                    while (it.hasNext()) {
                        Node neighbor = (Node)it.next();
                        Node replacement = (Node)hashMap.get(neighbor);
                        if (replacement != null) {
                            neighbor = replacement;
                            it.set(replacement);
                        }
                        assert (neighbor.getGrid() == grid);
                    }
                    grid.add(node, neighbors);
                    assert (node.getGrid() != null);
                    break;
                }
                case Sink: 
                case Source: {
                    void var8_13;
                    Node neighbor2;
                    ArrayList neighborGroups = new ArrayList();
                    for (Node neighbor : neighbors) {
                        boolean found = false;
                        if (node.nodeType == NodeType.Conductor) {
                            for (List list : neighborGroups) {
                                neighbor2 = (Node)list.get(0);
                                if (neighbor2.nodeType != NodeType.Conductor || neighbor2.getGrid() != neighbor.getGrid()) continue;
                                list.add(neighbor);
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        ArrayList<Node> nodeList = new ArrayList<Node>();
                        nodeList.add(neighbor);
                        neighborGroups.add(nodeList);
                    }
                    assert (!neighborGroups.isEmpty());
                    boolean bl = false;
                    while (var8_13 < neighborGroups.size()) {
                        Node currentNode;
                        List nodeList = (List)neighborGroups.get((int)var8_13);
                        Node neighbor = (Node)nodeList.get(0);
                        if (neighbor.nodeType != NodeType.Conductor && !neighbor.links.isEmpty()) {
                            assert (nodeList.size() == 1);
                            neighbor = new Node(enet.allocateNodeId(), neighbor.tile, neighbor.nodeType);
                            neighbor.tile.addExtraNode(neighbor);
                            new Grid(enet).add(neighbor, Collections.<Node>emptyList());
                            nodeList.set(0, neighbor);
                            assert (neighbor.getGrid() != null);
                        }
                        if (var8_13 == false) {
                            currentNode = node;
                        } else {
                            currentNode = new Node(enet.allocateNodeId(), tile, node.nodeType);
                            currentNode.setExtraNode(true);
                            extraNodes.add(currentNode);
                        }
                        neighbor.getGrid().add(currentNode, nodeList);
                        assert (currentNode.getGrid() != null);
                        ++var8_13;
                    }
                    continue block4;
                }
            }
        }
        for (Node node : extraNodes) {
            tile.addExtraNode(node);
        }
    }

    static void applyRemoval(EnergyNetLocal enet, IEnergyTile ioTile, BlockPos pos) {
        Tile tile = enet.registeredIoTiles.remove(ioTile);
        if (tile == null) {
            IC2.log.warn(LogCategory.EnergyNet, "Tile %s (%s) removal without registration", ioTile, pos);
            return;
        }
        for (IEnergyTile subTile : tile.subTiles) {
            BlockPos subPos = EnergyNet.instance.getPos(subTile);
            enet.registeredTiles.remove(subPos);
            enet.addPositionToNotify(subPos);
        }
        ChangeHandler.removeTileFromGrids(tile);
        for (IEnergyNetEventReceiver receiver : EnergyNetGlobal.getEventReceivers()) {
            receiver.onRemove(ioTile);
        }
    }

    private static void removeTileFromGrids(Tile tile) {
        for (Node node : tile.nodes) {
            node.getGrid().remove(node);
        }
    }
}

