/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.util.Ic2Color;
import ic2.core.util.StackUtil;
import java.util.Map;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeQArmorDye
extends RecipesArmorDyes {
    public static final Map<ItemStack, float[]> stackToRGB = new TCustomHashMap((HashingStrategy)new HashingStrategy<ItemStack>(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(ItemStack stack) {
            assert (stack != null);
            int h = stack.func_77973_b().hashCode();
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }

        public boolean equals(ItemStack aStack, ItemStack bStack) {
            return OreDictionary.itemMatches((ItemStack)aStack, (ItemStack)bStack, (boolean)false);
        }
    });

    public static void buildDyeMap() {
        for (Ic2Color colour : Ic2Color.values) {
            float[] RGB = EntitySheep.func_175513_a((EnumDyeColor)colour.mcColor);
            for (ItemStack stack : OreDictionary.getOres((String)colour.oreDictDyeName)) {
                stackToRGB.put(stack, RGB);
            }
        }
    }

    public boolean func_77569_a(InventoryCrafting craftingInv, World world) {
        ItemStack Qsuit = null;
        for (int slot = 0; slot < craftingInv.func_70302_i_(); ++slot) {
            ItemStack stack = craftingInv.func_70301_a(slot);
            if (StackUtil.isEmpty(stack) || !(stack.func_77973_b() instanceof ItemArmorQuantumSuit)) continue;
            if (Qsuit != null) {
                return false;
            }
            Qsuit = stack;
        }
        return Qsuit != null;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingInv) {
        ItemStack armourStack = null;
        ItemArmorQuantumSuit Qsuit = null;
        int[] newRBG = new int[3];
        int totalColour = 0;
        int numberOfDyes = 0;
        for (int slot = 0; slot < craftingInv.func_70302_i_(); ++slot) {
            ItemStack stack = craftingInv.func_70301_a(slot);
            if (StackUtil.isEmpty(stack)) continue;
            if (stack.func_77973_b() instanceof ItemArmorQuantumSuit) {
                Qsuit = (ItemArmorQuantumSuit)stack.func_77973_b();
                if (!StackUtil.isEmpty(armourStack)) {
                    return StackUtil.emptyStack;
                }
                armourStack = StackUtil.copyWithSize(stack, 1);
                if (!Qsuit.func_82816_b_(stack)) continue;
                int oldColour = Qsuit.func_82814_b(armourStack);
                float r = (float)(oldColour >> 16 & 0xFF) / 255.0f;
                float g = (float)(oldColour >> 8 & 0xFF) / 255.0f;
                float b = (float)(oldColour & 0xFF) / 255.0f;
                totalColour = (int)((float)totalColour + Math.max(r, Math.max(g, b)) * 255.0f);
                newRBG[0] = (int)((float)newRBG[0] + r * 255.0f);
                newRBG[1] = (int)((float)newRBG[1] + g * 255.0f);
                newRBG[2] = (int)((float)newRBG[2] + b * 255.0f);
                ++numberOfDyes;
                continue;
            }
            if (!stackToRGB.containsKey(stack)) {
                return StackUtil.emptyStack;
            }
            float[] dyeRGB = stackToRGB.get(stack);
            int r = (int)(dyeRGB[0] * 255.0f);
            int g = (int)(dyeRGB[1] * 255.0f);
            int b = (int)(dyeRGB[2] * 255.0f);
            totalColour += Math.max(r, Math.max(g, b));
            newRBG[0] = newRBG[0] + r;
            newRBG[1] = newRBG[1] + g;
            newRBG[2] = newRBG[2] + b;
            ++numberOfDyes;
        }
        if (Qsuit == null || numberOfDyes == 0) {
            return StackUtil.emptyStack;
        }
        if (Qsuit.func_82816_b_(armourStack) && numberOfDyes == 1) {
            Qsuit.func_82815_c(armourStack);
        } else {
            int averageRed = newRBG[0] / numberOfDyes;
            int averageGreen = newRBG[1] / numberOfDyes;
            int averageBlue = newRBG[2] / numberOfDyes;
            float gain = (float)totalColour / (float)numberOfDyes;
            float averageMax = Math.max(averageRed, Math.max(averageGreen, averageBlue));
            averageRed = (int)((float)averageRed * gain / averageMax);
            averageGreen = (int)((float)averageGreen * gain / averageMax);
            averageBlue = (int)((float)averageBlue * gain / averageMax);
            int finalColour = (averageRed << 8) + averageGreen;
            finalColour = (finalColour << 8) + averageBlue;
            Qsuit.colorQArmor(armourStack, finalColour);
        }
        return armourStack;
    }
}

